/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.tools.analyzer.IIUAnalyzer;
import org.eclipse.equinox.p2.repository.tools.analyzer.IUAnalyzer;

public class RepositoryAnalyzer {
    private final IMetadataRepository[] repositories;

    public RepositoryAnalyzer(IMetadataRepository[] repositories) {
        this.repositories = repositories;
    }

    public IStatus analyze(IProgressMonitor monitor) {
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.transformer", 0, null, null);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.repositories.length * 2));
        IConfigurationElement[] config = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.equinox.p2.repository.tools.verifier");
        IMetadataRepository[] iMetadataRepositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IMetadataRepository repository = iMetadataRepositoryArray[n2];
            IQueryResult queryResult = repository.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)sub);
            SubMonitor repositoryMonitor = SubMonitor.convert((IProgressMonitor)sub, (int)-1);
            IConfigurationElement[] iConfigurationElementArray = config;
            int n3 = config.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config1 = iConfigurationElementArray[n4];
                try {
                    IIUAnalyzer verifier = (IIUAnalyzer)config1.createExecutableExtension("class");
                    String analyizerName = config1.getAttribute("name");
                    if (verifier instanceof IUAnalyzer) {
                        ((IUAnalyzer)verifier).setName(analyizerName);
                    }
                    verifier.preAnalysis(repository);
                    for (IInstallableUnit iu : queryResult) {
                        verifier.analyzeIU(iu);
                    }
                    IStatus postAnalysisResult = verifier.postAnalysis();
                    if (postAnalysisResult == null) {
                        postAnalysisResult = new Status(0, "org.eclipse.equinox.p2.transformer", analyizerName);
                    }
                    if (postAnalysisResult.isOK() && !postAnalysisResult.isMultiStatus()) {
                        postAnalysisResult = new Status(0, "org.eclipse.equinox.p2.transformer", analyizerName);
                    }
                    result.add(postAnalysisResult);
                }
                catch (CoreException e) {
                    if (e.getCause() instanceof ClassNotFoundException) {
                        result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.transformer", "Cannot find: " + config1.getAttribute("class")));
                    }
                    e.printStackTrace();
                }
                ++n4;
            }
            repositoryMonitor.done();
            ++n2;
        }
        sub.done();
        return result;
    }
}

