/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.core.internal;

import de.rcenvironment.toolkit.core.api.ImmutableServiceRegistry;
import de.rcenvironment.toolkit.core.api.ToolkitException;
import de.rcenvironment.toolkit.core.internal.AbstractObjectGraph;
import de.rcenvironment.toolkit.core.internal.ImmutableServiceRegistryImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.picocontainer.ComponentFactory;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.behaviors.Caching;

public class PicoContainerObjectGraph
extends AbstractObjectGraph {
    private DefaultPicoContainer container;
    private Map<Class<?>, Object> services = new HashMap();

    public PicoContainerObjectGraph() {
        this.container = new DefaultPicoContainer((ComponentFactory)new Caching());
    }

    @Override
    protected void registerObject(Object object, Collection<Class<?>> privateInterfaces) {
        this.container.addComponent(object);
    }

    @Override
    protected void registerServiceClass(Object implementationClass, Collection<Class<?>> publicInterfaces, Collection<Class<?>> privateInterfaces) {
        this.container.addComponent(implementationClass);
        for (Class<?> i : publicInterfaces) {
            this.services.put(i, null);
        }
    }

    @Override
    public boolean isMissingService(Class<?> serviceInterface) {
        return !this.services.containsKey(serviceInterface);
    }

    @Override
    protected ImmutableServiceRegistry instantiateServices(Collection<Class<?>> serviceInterfaces) throws ToolkitException {
        try {
            for (Class<?> i : this.services.keySet()) {
                Object impl = this.container.getComponent(i);
                this.services.put(i, impl);
                this.logDebug("Publishing service " + i.getName() + " implemented by " + impl);
            }
            return new ImmutableServiceRegistryImpl(this.services);
        }
        catch (RuntimeException e) {
            if (e.getClass().getName().contains("UnsatisfiableDependenciesException")) {
                throw new ToolkitException("Error constructing the service object graph: " + e.getMessage());
            }
            throw new ToolkitException("Error constructing the service object graph", e);
        }
    }
}

