/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.osgi;

import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.io.File;
import org.osgi.framework.Bundle;

public final class BundleUtils {
    private BundleUtils() {
    }

    public static File resolveAbsolutePathToUnpackedBundle(Bundle bundle, File installationRootPath) throws OperationFailureException {
        String locationString = bundle.getLocation();
        if (!locationString.startsWith("reference:file:")) {
            throw new OperationFailureException("Unexpected bundle location value (expected prefix 'reference:file:') for bundle " + bundle.getSymbolicName() + ": " + locationString);
        }
        String bundleLocationString = locationString.substring("reference:file:".length());
        File bundleLocation = new File(bundleLocationString);
        File absoluteBundleLocation = bundleLocation.isAbsolute() ? bundleLocation : new File(installationRootPath, bundleLocationString);
        return absoluteBundleLocation;
    }
}

