/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authentication;

import de.rcenvironment.core.authentication.AuthenticationException;
import de.rcenvironment.core.authentication.LDAPUser;
import de.rcenvironment.core.authentication.User;
import de.rcenvironment.core.authentication.internal.AuthenticationConfiguration;

public final class Session {
    public static final String NOTIFICATION_ID_NEWUSER = "de.rcenvironment.rce.authentication.newuser";
    private static Session instance = null;
    private static User user = null;

    private Session(User user) {
        Session.user = user;
        instance = this;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static Session getInstance() throws AuthenticationException {
        if (instance != null) {
            return instance;
        }
        throw new AuthenticationException("There is no session initialized.");
    }

    public User getUser() {
        return user;
    }

    public static synchronized void create(User newUser) {
        if (instance == null) {
            new Session(newUser);
        } else {
            user = newUser;
        }
    }

    public static synchronized void create(String userID, int validityInDays) {
        AuthenticationConfiguration config = new AuthenticationConfiguration();
        LDAPUser newUser = new LDAPUser(userID, validityInDays, config.getLdapDomain());
        if (instance == null) {
            new Session(newUser);
        } else {
            user = newUser;
        }
    }

    public synchronized void destroy() {
        instance = null;
        user = null;
    }
}

