/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.tiglviewer.execution;

import de.rcenvironment.components.tiglviewer.execution.TiglViewerView;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.api.LocalExecutionOnly;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.gui.tiglviewer.TiglViewerConstants;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

@LocalExecutionOnly
public class TiglViewerComponent
extends DefaultComponent {
    private static final Log LOG = LogFactory.getLog(TiglViewerComponent.class);
    private static TiglViewerView view;
    private ComponentContext componentContext;
    private ComponentDataManagementService dataManagementService;
    private File tempFile = null;
    private boolean firstTime = true;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public void start() throws ComponentException {
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        Bundle guiBundle = Platform.getBundle((String)"de.rcenvironment.components.tiglviewer.gui");
        try {
            if (guiBundle != null && guiBundle.getState() != 32) {
                LOG.debug((Object)("Starting bundle: " + guiBundle));
                guiBundle.start();
            }
        }
        catch (BundleException e) {
            LOG.error((Object)("Failed to start bundle: " + guiBundle), (Throwable)e);
        }
    }

    public void processInputs() throws ComponentException {
        TypedDatum td = this.componentContext.readInput("TiGL Viewer File");
        if (td instanceof FileReferenceTD) {
            FileReferenceTD inputFile = (FileReferenceTD)td;
            if (this.firstTime) {
                try {
                    String fileSuffix = FilenameUtils.getExtension((String)inputFile.getFileName());
                    if (fileSuffix.isEmpty() || !Arrays.asList(TiglViewerConstants.SUPPORTED_FILE_EXTENSIONS).contains(fileSuffix.toLowerCase())) {
                        throw new ComponentException(StringUtils.format((String)"Only files with the extensions %s are supported by TiGL Viewer.", (Object[])new Object[]{Arrays.toString(TiglViewerConstants.SUPPORTED_FILE_EXTENSIONS)}));
                    }
                    this.tempFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("*." + fileSuffix);
                }
                catch (IOException | StringIndexOutOfBoundsException e) {
                    throw new ComponentException("Failed to create temporary geometry file required by TiGL Viewer", (Throwable)e);
                }
                try {
                    this.dataManagementService.copyReferenceToLocalFile(inputFile.getFileReference(), this.tempFile, this.componentContext.getStorageNetworkDestination());
                }
                catch (IOException e) {
                    throw new ComponentException("Failed to load geometry file into temporary file used by TiGL Viewer", (Throwable)e);
                }
                if (view == null) {
                    throw new ComponentException("Failed to show geometry in TiGL Viewer - most likely, because the TiGL Viewer is not supported on your operating system");
                }
                view.showView(this.tempFile);
                this.firstTime = false;
            } else {
                try {
                    this.dataManagementService.copyReferenceToLocalFile(inputFile.getFileReference(), this.tempFile, this.componentContext.getStorageNetworkDestination());
                }
                catch (IOException e) {
                    throw new ComponentException("Failed to update geometry in temporary file used by TiGL Viewer", (Throwable)e);
                }
            }
            this.componentContext.writeOutput("TiGL Viewer File", td);
        }
    }

    public static synchronized void setRuntimeView(TiglViewerView newView) {
        if (view != null) {
            LogFactory.getLog(TiglViewerComponent.class).warn((Object)("Tried to set TiGL Viewer Runtime View (" + newView + ")" + " when one is already configured: " + view));
        }
        view = newView;
    }
}

