/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.gui.properties;

import de.rcenvironment.components.excel.common.ExcelAddress;
import de.rcenvironment.components.excel.common.ExcelException;
import de.rcenvironment.components.excel.gui.properties.CellSelectionDialog;
import de.rcenvironment.components.excel.gui.properties.Messages;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import java.io.File;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class VariablesEditDialog
extends EndpointEditDialog {
    private File xlFile;
    private CellSelectionDialog selectionDialog;

    public VariablesEditDialog(Shell parentShell, EndpointActionType actionType, ComponentInstanceProperties configuration, EndpointType direction, String id, boolean isStatic, EndpointMetaDataDefinition metaData, Map<String, String> metadataValues, File xlFile) {
        super(parentShell, actionType, configuration, direction, id, isStatic, metaData, metadataValues);
        this.xlFile = xlFile;
    }

    public File getFile() {
        return this.xlFile;
    }

    protected void notifyAboutSelection() {
        if (this.selectionDialog.getAddress() != null && !this.selectionDialog.getAddress().isEmpty()) {
            ExcelAddress addr = null;
            try {
                addr = new ExcelAddress(this.xlFile, this.selectionDialog.getAddress());
            }
            catch (ExcelException ee) {
                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 520);
                messageBox.setText("Invalid Excel Address");
                messageBox.setMessage(ee.getMessage());
                messageBox.open();
            }
            Widget address = super.getWidget("address");
            if (addr != null && address instanceof Text) {
                ((Text)address).setText(addr.getFullAddress());
            }
        }
        this.selectionDialog.close();
    }

    protected Control createConfigurationArea(Composite parent) {
        Control superControl = super.createConfigurationArea(parent);
        Button selectButton = new Button(parent, 0);
        selectButton.setText(Messages.selectButton);
        selectButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                VariablesEditDialog.this.createExcelDialog();
            }
        });
        return superControl;
    }

    protected boolean validateMetaDataInputs() {
        boolean validation = false;
        if (super.validateMetaDataInputs()) {
            try {
                Widget address = super.getWidget("address");
                if (address instanceof Text) {
                    String rawAddress = ((Text)address).getText();
                    new ExcelAddress(this.xlFile, rawAddress);
                    validation = true;
                }
            }
            catch (ExcelException excelException) {
                validation = false;
            }
        }
        return validation;
    }

    private void createExcelDialog() {
        Shell excelDialog = new Shell(16384);
        this.selectionDialog = new CellSelectionDialog(excelDialog, 84064, this);
        excelDialog.setLayout((Layout)new FillLayout());
        excelDialog.setText(this.xlFile.getAbsolutePath());
        excelDialog.pack();
        excelDialog.setSize(0, 0);
        Rectangle parentSize = excelDialog.getBounds();
        Rectangle mySize = excelDialog.getBounds();
        int locationX = (parentSize.width - mySize.width) / 2 + parentSize.x;
        int locationY = (parentSize.height - mySize.height) / 2 + parentSize.y;
        excelDialog.setLocation(new Point(locationX, locationY));
        excelDialog.open();
        this.selectionDialog.open((String)super.getMetadataValues().get("address"));
    }
}

