import os, json, math, collections


def get_constraint_gradient(constraint_name):
    if (currentResult.has_key(("grad", constraint_name)) and currentResult.has_key(("const", constraint_name))):
        return currentResult["grad", constraint_name]
    return None   

def get_constraint_value(constraint_name):
    if (currentResult.has_key(("const", constraint_name))):
        return currentResult["const", constraint_name]  
    return None

def get_failed():
    failed_list = []
    for name in currentResult.keys():
       if (currentResult["failed", name[1]] and not name[1] in failed_list):
            failed_list.append(name[1])
    return failed_list

def get_objective_gradient(objective_name):
    if (currentResult.has_key(("grad", objective_name)) and currentResult.has_key(("objective", objective_name))):
        return currentResult["grad", objective_name]
    return None

def get_objective_value(objective_name):
    if (currentResult.has_key(("objective", objective_name))):
        return currentResult["objective", objective_name]
    return None
    
def has_gradient(name):
    return currentResult.has_key(("grad", name))

def ___read_evaluation(completeDir, inputFilename):
    evaluation = {}
    try:
        with open(os.path.join(completeDir, inputFilename)) as data_file:
            evaluation = json.load(data_file)
    except IOError as e: 
        print("Could not read result file" + str(e))
    global currentResult 
    currentResult = {}
    for key in evaluation.keys():
        for name in evaluation[key].keys():
            if (not isinstance(evaluation[key][name], (str, unicode)) and isinstance(evaluation[key][name], collections.Sequence)):
                for i, item in enumerate(evaluation[key][name]):
                    if (item == "NaN"):
                        currentResult["failed", name] = True
                    else:
                        currentResult["failed", name] = False
                    evaluation[key][name][i] = __replace_value(item)
                currentResult[key, name] = evaluation[key][name]
            else:
                if (evaluation[key][name] == "NaN"):
                    currentResult["failed", name] = True
                else:
                    currentResult["failed", name] = False
                currentResult[key, name] = __replace_value(evaluation[key][name])
    return currentResult

def __replace_value(value):
    if (value is None):
        value = float('NaN')
    if (value == "Infinity"):
        value = float("inf")
    if (value == "negative Infinity"):
        value = - float("inf")
    return value