/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.easymock.internal.ErrorMessage;
import org.easymock.internal.ExpectedInvocation;
import org.easymock.internal.ExpectedInvocationAndResults;
import org.easymock.internal.Invocation;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.Results;

public class UnorderedBehavior
implements Serializable {
    private static final long serialVersionUID = 2185791334636597469L;
    private final List<ExpectedInvocationAndResults> results = new ArrayList<ExpectedInvocationAndResults>();
    private final boolean checkOrder;

    public UnorderedBehavior(boolean checkOrder) {
        this.checkOrder = checkOrder;
    }

    public void addExpected(ExpectedInvocation expected, Result result, Range count) {
        for (ExpectedInvocationAndResults entry : this.results) {
            if (!entry.getExpectedInvocation().equals(expected)) continue;
            entry.getResults().add(result, count);
            return;
        }
        Results list = new Results();
        list.add(result, count);
        this.results.add(new ExpectedInvocationAndResults(expected, list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result addActual(Invocation actual) {
        for (ExpectedInvocationAndResults entry : this.results) {
            try {
                if (!entry.getResults().hasResults() || !entry.getExpectedInvocation().matches(actual)) continue;
                Result result = entry.getResults().next();
                actual.validateCaptures();
                Result result2 = result;
                return result2;
            }
            finally {
                actual.clearCaptures();
            }
        }
        return null;
    }

    public boolean verify() {
        for (ExpectedInvocationAndResults entry : this.results) {
            if (entry.getResults().hasValidCallCount()) continue;
            return false;
        }
        return true;
    }

    public List<ErrorMessage> getMessages(Invocation invocation) {
        ArrayList<ErrorMessage> messages = new ArrayList<ErrorMessage>(this.results.size());
        for (ExpectedInvocationAndResults entry : this.results) {
            boolean match;
            boolean unordered = !this.checkOrder;
            boolean validCallCount = entry.getResults().hasValidCallCount();
            boolean bl = match = invocation != null && entry.getExpectedInvocation().matches(invocation);
            if (unordered && validCallCount && !match) continue;
            ErrorMessage message = new ErrorMessage(match, entry.toString(), entry.getResults().getCallCount());
            messages.add(message);
        }
        return messages;
    }

    public boolean allowsExpectedInvocation(ExpectedInvocation expected, boolean checkOrder) {
        if (this.checkOrder != checkOrder) {
            return false;
        }
        if (this.results.isEmpty() || !this.checkOrder) {
            return true;
        }
        ExpectedInvocation lastMethodCall = this.results.get(this.results.size() - 1).getExpectedInvocation();
        return lastMethodCall.equals(expected);
    }
}

