/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.function.PostscriptFactory;

public class PDFCalculator
extends PDFGenericFunction
implements PDFFunction {
    int returnValues;
    byte[] stream;

    public PDFCalculator(byte[] byArray, float[] fArray, float[] fArray2) {
        super(fArray, fArray2);
        this.returnValues = fArray2.length / 2;
        this.stream = byArray;
    }

    public float[] computeStitch(float[] fArray) {
        return this.compute(fArray);
    }

    public float[] compute(float[] fArray) {
        float[] fArray2 = new float[this.returnValues];
        float[] fArray3 = new float[this.returnValues];
        try {
            PostscriptFactory postscriptFactory = new PostscriptFactory(this.stream);
            postscriptFactory.resetStacks(fArray);
            double[] dArray = postscriptFactory.executePostscript();
            if (this.domain.length / 2 == 1) {
                int n = this.range.length / 2;
                for (int i = 0; i < n; ++i) {
                    fArray2[i] = (float)dArray[i];
                    fArray3[i] = PDFCalculator.min(PDFCalculator.max(fArray2[i], this.range[i * 2]), this.range[i * 2 + 1]);
                }
            } else {
                int n = this.range.length / 2;
                for (int i = 0; i < n; ++i) {
                    fArray2[i] = (float)dArray[i];
                    fArray3[i] = PDFCalculator.min(PDFCalculator.max(fArray2[i], this.range[i * 2]), this.range[i * 2 + 1]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fArray3;
    }
}

