/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.FileAccess;
import org.jpedal.PDFtoImageConvertor;
import org.jpedal.PageOffsets;
import org.jpedal.SingleDisplay;
import org.jpedal.SwingPainter;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.swing.SwingMouseListener;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.external.JPedalHelper;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.PdfReader;
import org.jpedal.io.StatusBar;
import org.jpedal.linear.LinearParser;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.rendering.DefaultAcroRenderer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.structuredtext.MarkedContentGenerator;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.SwingPrinter;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.text.TextLines;
import org.jpedal.utils.DPIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.w3c.dom.Document;

public class PdfDecoder
extends JPanel {
    public static final String version = "4.73b26-OS";
    public static final int TEXT = 1;
    public static final int RAWIMAGES = 2;
    public static final int FINALIMAGES = 4;
    protected static final int PAGEDATA = 8;
    public static final int RAWCOMMANDS = 16;
    public static final int CLIPPEDIMAGES = 32;
    public static final int TEXTCOLOR = 64;
    public static final int CMYKIMAGES = 128;
    public static final int XFORMMETADATA = 256;
    public static final int COLOR = 512;
    public static final int RENDERTEXT = 1;
    public static final int RENDERIMAGES = 2;
    public static final int REMOVE_RENDERSHAPES = 16;
    public static final int OCR_PDF = 32;
    public static final int NOTEXTPRINT = 0;
    public static final int TEXTGLYPHPRINT = 1;
    public static final int TEXTSTRINGPRINT = 2;
    public static final int STANDARDTEXTSTRINGPRINT = 3;
    public static final int SUBSTITUTE_FONT_USING_FILE_NAME = 1;
    public static final int SUBSTITUTE_FONT_USING_POSTSCRIPT_NAME = 2;
    public static final int SUBSTITUTE_FONT_USING_FAMILY_NAME = 3;
    public static final int SUBSTITUTE_FONT_USING_FULL_FONT_NAME = 4;
    public static final int SUBSTITUTE_FONT_USING_POSTSCRIPT_NAME_USE_FAMILY_NAME_IF_DUPLICATES = 5;
    public static boolean isRunningOnMac = false;
    public static boolean isRunningOnWindows = false;
    public static boolean isRunningOnAIX = false;
    public static boolean isRunningOnLinux = false;
    public static float javaVersion = 0.0f;
    public static float highlightComposite = 0.35f;
    public static boolean showMouseBox = false;
    public static int dpi = 72;
    public static boolean embedWidthData = false;
    public static JPedalHelper Helper = null;
    DecoderOptions options = new DecoderOptions();
    SwingPainter swingPainter = new SwingPainter(this, this.options);
    public SwingPrinter swingPrinter = new SwingPrinter();
    FileAccess fileAcces = new FileAccess();
    LinearParser linearParser = new LinearParser();
    private DPIFactory scalingdpi = new DPIFactory();
    ExternalHandlers externalHandlers = new ExternalHandlers();
    public boolean useNewGraphicsMode = true;
    protected Display pages = null;
    protected AcroRenderer formRenderer;
    private PageOffsets currentOffset;
    protected boolean renderPage = false;
    protected int displayView = 1;
    private int scrollInterval = 10;
    protected int pageCount = 0;
    boolean isNewRotationSet = false;
    protected boolean isDecoding = false;
    public int pageNumber = 1;
    protected int alignment = 1;
    public int displayRotation = 0;
    protected AffineTransform displayScaling;
    private PdfPageData pageData = new PdfPageData();
    public int insetW = 0;
    public int insetH = 0;
    int x_size = 100;
    int y_size = 100;
    int max_y;
    int max_x;
    public float scaling = 1.0f;
    protected Border myBorder = null;
    public ObjectStore objectStoreRef = new ObjectStore();
    protected DynamicVectorRenderer currentDisplay = new SwingDisplay(1, this.objectStoreRef, false);
    protected boolean useAcceleration = true;
    public PdfObjectReader currentPdfFile;
    private boolean isBackgroundDecoding = false;
    private PdfImageData pdfImages = new PdfImageData();
    private PdfImageData pdfBackgroundImages = new PdfImageData();
    private PdfData pdfData;
    private PdfData pdfBackgroundData;
    private RefreshLayout viewListener = null;
    private Graphics2D g2 = null;
    private String fontsInFile = "";
    private String imagesInFile = "";
    private float multiplyer = 1.0f;
    private int extractionMode = 7;
    protected int renderMode = 7;
    PdfResources res = new PdfResources();
    private StatusBar statusBar = null;
    boolean useHiResImageForDisplay = false;
    String filename;
    private int lastPageDecoded = -1;
    public static boolean showErrorMessages;
    protected int specialMode = -1;
    private boolean isOpen = false;
    public int textPrint = 0;
    private int minimumCacheSize = -1;
    String decodeStatus = "";
    private DecoderResults resultsFromDecode = new DecoderResults();
    private Object customSwingHandle;
    private Object userExpressionEngine;
    private boolean generateGlyphOnRender;
    BufferedImage printImage = null;
    private TextLines textLines = new TextLines();

    public boolean isOpen() {
        return this.isOpen;
    }

    public Document getMarkedContent() {
        return new MarkedContentGenerator().getMarkedContentTree(this.res, this.pageData, this.currentPdfFile);
    }

    public void setPageData(PdfPageData pdfPageData) {
        this.pageData = pdfPageData;
    }

    public int getlastPageDecoded() {
        return this.lastPageDecoded;
    }

    public Iterator getPageInfo(int n) {
        return this.resultsFromDecode.getPageInfo(n);
    }

    public OutlineData getOutlineData() {
        return this.res.getOutlineData();
    }

    public boolean isLoadingLinearizedPDF() {
        return false;
    }

    protected void resetMultiPageForms(int n) {
        this.swingPainter.resetMultiPageForms(n, this, this.formRenderer, this.pages);
    }

    public void resetViewableArea() {
        this.swingPainter.resetViewableArea(this, this.pageData);
    }

    public AffineTransform setViewableArea(Rectangle rectangle) throws PdfException {
        return this.swingPainter.setViewableArea(rectangle, this, this.pageData);
    }

    public int getPageAlignment() {
        return this.alignment;
    }

    public static void init(boolean bl) {
        embedWidthData = bl;
    }

    public PdfDecoder(boolean bl) {
        this.pages = new SingleDisplay(this);
        this.renderPage = bl;
        this.startup();
        if (this.renderPage) {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    private void startup() {
        String string;
        this.formRenderer = new DefaultAcroRenderer();
        this.formRenderer.resetHandler(null, this, 5);
        if (!FontMappings.fontsInitialised) {
            FontMappings.initFonts();
            FontMappings.fontsInitialised = true;
        }
        if ((string = System.getProperty("debug")) != null) {
            LogWriter.setupLogFile(true, 1, "", "v", false);
        }
    }

    public PdfDecoder() {
        this.pages = new SingleDisplay(this);
        this.renderPage = true;
        this.setLayout(null);
        this.startup();
        this.setPreferredSize(new Dimension(100, 100));
    }

    public static void disposeAllStatic() {
        StandardFonts.dispose();
        FontMappings.dispose();
    }

    public final void dispose() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.disposeObjects();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    PdfDecoder.this.disposeObjects();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private final void disposeObjects() {
        FontMappings.fontsInitialised = false;
        this.options.disposeObjects();
        if (this.viewListener != null) {
            this.viewListener.dispose();
        }
        if (this.pdfData != null) {
            this.pdfData.dispose();
        }
        this.pdfData = null;
        if (this.pages != null) {
            this.pages.dispose();
        }
        this.pages = null;
        FontMappings.defaultFont = null;
        if (this.currentDisplay != null) {
            this.currentDisplay.dispose();
        }
        this.currentDisplay = null;
        if (this.currentPdfFile != null) {
            this.currentPdfFile.dispose();
        }
        this.currentPdfFile = null;
        if (this.formRenderer != null) {
            this.formRenderer.dispose();
        }
        this.formRenderer = null;
    }

    public final void closePdfFile() {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        this.waitForDecodingToFinish();
        this.linearParser.closePdfFile();
        this.displayScaling = null;
        this.lastPageDecoded = -1;
        if (this.pages != null) {
            this.pages.stopGeneratingPage();
        }
        this.pages.disableScreen();
        this.swingPrinter.clear();
        if (this.formRenderer != null) {
            this.formRenderer.openFile(this.pageCount);
            this.formRenderer.resetFormData(this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.res.getPdfObject(1));
            this.formRenderer.removeDisplayComponentsFromScreen();
        }
        if (this.viewListener != null) {
            this.pages.flushPageCaches();
            this.removeComponentListener(this.viewListener);
            this.viewListener.dispose();
            this.viewListener = null;
        }
        if (this.currentPdfFile != null) {
            this.currentPdfFile.closePdfFile();
            this.currentPdfFile = null;
        }
        this.pages.disableScreen();
        this.currentDisplay.flush();
        ObjectStore.flushPages();
        this.objectStoreRef.flush();
        this.pageCount = 0;
        this.res.flushObjects();
        this.setDisplayView(1, 2);
        if (SwingUtilities.isEventDispatchThread()) {
            this.validate();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    PdfDecoder.this.validate();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public final PdfData getPdfBackgroundData() {
        return this.pdfBackgroundData;
    }

    public final PdfData getPdfData() throws PdfException {
        if ((this.extractionMode & 1) == 0) {
            throw new PdfException("[PDF] Page data object requested will be empty as text extraction disabled. Enable with PdfDecoder method setExtractionMode(PdfDecoder.TEXT | other values");
        }
        return this.pdfData;
    }

    public final boolean hasOutline() {
        return this.res.hasOutline();
    }

    public final Document getOutlineAsXML() {
        return this.res.getOutlineAsXML(this.currentPdfFile, this.pageCount);
    }

    public final PdfPageData getPdfPageData() {
        return this.pageData;
    }

    public void setPagePrintRange(int n, int n2) throws PdfException {
        this.swingPrinter.setPagePrintRange(n, n2, this.pageCount);
    }

    public void setTextPrint(int n) {
        this.textPrint = n;
    }

    public void setJavaScriptUsed(boolean bl) {
        this.options.setJavaScriptUsed(bl);
    }

    public void useLogicalPrintOffset(int n) {
        this.swingPrinter.useLogicalPrintOffset(n);
    }

    public BufferedImage getPageAsImage(int n) throws PdfException {
        return this.getPageAsImage(n, false);
    }

    private BufferedImage getPageAsImage(int n, boolean bl) throws PdfException {
        BufferedImage bufferedImage = null;
        if (n > this.pageCount || n < 1) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Page " + n + " not in range");
            }
        } else {
            if (this.currentPdfFile == null) {
                throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
            }
            String string = this.currentPdfFile.getReferenceforPage(n);
            if (string != null) {
                PDFtoImageConvertor pDFtoImageConvertor = new PDFtoImageConvertor(this.multiplyer, this.options);
                bufferedImage = pDFtoImageConvertor.convert(this.resultsFromDecode, this.displayRotation, this.res, this.displayView, this.externalHandlers, this.renderMode, this.pageData, this.formRenderer, this.scaling, this.currentPdfFile, n, bl, string);
                this.multiplyer = pDFtoImageConvertor.getMultiplyer();
                if (this.pages != null) {
                    this.formRenderer.getCompData().resetScaledLocation(this.pages.getOldScaling(), this.displayRotation, 0);
                }
            }
            if (!isRunningOnAIX && !bl && bufferedImage != null) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
            }
        }
        return bufferedImage;
    }

    public float getHiResUpscaleFactor() {
        return this.multiplyer;
    }

    public final void flushObjectValues(boolean bl) {
        if (this.pdfData != null) {
            this.pdfData.flushTextList(bl);
        }
        if (this.pdfImages != null && bl) {
            this.pdfImages.clearImageData();
        }
    }

    public final PdfImageData getPdfImageData() {
        return this.pdfImages;
    }

    public final PdfImageData getPdfBackgroundImageData() {
        return this.pdfBackgroundImages;
    }

    public final void setRenderMode(int n) {
        this.renderMode = n;
        this.extractionMode = n;
    }

    public final void setExtractionMode(int n) {
        this.extractionMode = n;
    }

    public final PdfFileInformation getFileInformationData() {
        return this.res.getMetaData(this.currentPdfFile);
    }

    public final void setExtractionMode(int n, int n2, float f) {
        boolean bl;
        if (dpi % 72 != 0 && LogWriter.isOutput()) {
            LogWriter.writeLog("Dpi is not a factor of 72- this may cause problems");
        }
        dpi = n2;
        this.scaling = f;
        this.pageData.setScalingValue(f);
        this.extractionMode = n;
        PdfLayerList pdfLayerList = this.res.getPdfLayerList();
        if (pdfLayerList != null && (bl = pdfLayerList.setZoom(f))) {
            try {
                this.decodePage(-1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public DPIFactory getDPIFactory() {
        return this.scalingdpi;
    }

    public final void setPageParameters(float f, int n) {
        int n2;
        PdfLayerList pdfLayerList;
        this.pageNumber = n;
        if (this.displayView == 6 && f == -100.0f) {
            return;
        }
        if (f > 0.0f) {
            this.scaling = f;
        } else {
            f = this.scaling;
        }
        if (this.pages != null) {
            this.pages.setScaling(f);
        }
        if ((pdfLayerList = this.res.getPdfLayerList()) != null && (n2 = pdfLayerList.setZoom(this.scalingdpi.removeScaling(f))) != 0) {
            try {
                this.decodePage(-1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.pageData.setScalingValue(f);
        n2 = this.pageData.getMediaBoxWidth(n);
        this.max_y = this.pageData.getMediaBoxHeight(n);
        this.max_x = this.pageData.getMediaBoxWidth(n);
        int n3 = this.pageData.getCropBoxWidth(n);
        int n4 = this.pageData.getCropBoxHeight(n);
        this.x_size = (int)((float)n3 * f);
        this.y_size = (int)((float)n4 * f);
        if (!this.isNewRotationSet && this.displayView != 6) {
            this.displayRotation = this.pageData.getRotation(n);
        } else {
            this.isNewRotationSet = false;
        }
        this.currentDisplay.init(n2, this.max_y, this.displayRotation, this.options.getPageColor());
        this.swingPainter.setPageRotation(this.displayRotation, this.pageData);
        this.formRenderer.getCompData().setForceRedraw(true);
    }

    public final void setPageParameters(float f, int n, int n2) {
        this.isNewRotationSet = true;
        this.displayRotation = n2;
        if (this.displayView == 6) {
            this.pages.init(0.0f, 0, this.displayRotation, 0, null, false, null, 0, 0);
        } else {
            this.setPageParameters(f, n);
        }
    }

    public void setStatusBarObject(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public void waitForDecodingToFinish() {
        while (this.isDecoding) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                this.isDecoding = false;
            }
        }
    }

    public DynamicVectorRenderer getDynamicRenderer() {
        return this.currentDisplay;
    }

    public DynamicVectorRenderer getDynamicRenderer(boolean bl) {
        DynamicVectorRenderer dynamicVectorRenderer = this.currentDisplay;
        if (bl) {
            this.currentDisplay = new SwingDisplay(0, this.objectStoreRef, false);
        }
        return dynamicVectorRenderer;
    }

    public void setPDFCursor(Cursor cursor) {
        if (SingleDisplay.allowChangeCursor) {
            this.setCursor(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decodePage(int n) throws Exception {
        block36: {
            Object object = this.externalHandlers.getExternalHandler(20);
            if (object != null) {
                this.currentDisplay = (DynamicVectorRenderer)object;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (n == -1) {
                n = this.lastPageDecoded;
                bl2 = true;
            }
            boolean bl3 = false;
            if (n == this.lastPageDecoded) {
                bl3 = true;
            }
            final int n2 = n;
            if (this.isDecoding) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF]WARNING - this file is being decoded already - use  waitForDecodingToFinish() to check");
                }
            } else {
                boolean bl4 = this.isPageAvailable(n);
                PdfObject pdfObject = this.linearParser.getLinearPageObject();
                if (!bl4) {
                    this.isDecoding = false;
                    return;
                }
                if (bl4 && pdfObject != null) {
                    this.isDecoding = true;
                    this.readAllPageReferences(true, pdfObject, new HashMap(1000), new HashMap(1000), n);
                }
                this.resultsFromDecode.resetTimeout();
                try {
                    Object object2;
                    Object object3;
                    this.isDecoding = true;
                    PdfLayerList pdfLayerList = this.res.getPdfLayerList();
                    if (pdfLayerList != null && pdfLayerList.getChangesMade()) {
                        this.lastPageDecoded = -1;
                        pdfLayerList.setChangesMade(false);
                        this.formRenderer.getCompData().setForceRedraw(true);
                        this.formRenderer.getCompData().setLayerData(pdfLayerList);
                        this.formRenderer.getCompData().resetScaledLocation(this.scaling, this.displayRotation, (int)this.swingPainter.getIndent());
                    }
                    if (this.displayView != 1) {
                        this.isDecoding = false;
                        return;
                    }
                    this.lastPageDecoded = n2;
                    this.decodeStatus = "";
                    this.swingPainter.setCursorBoxOnScreen(null, bl3, this.formRenderer);
                    this.currentDisplay.flush();
                    this.pages.refreshDisplay();
                    if (n2 > this.pageCount || n2 < 1) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("Page out of bounds");
                        }
                        this.isDecoding = false;
                        break block36;
                    }
                    javax.swing.Timer timer = null;
                    if (this.statusBar != null) {
                        object3 = new ProgressListener();
                        timer = new javax.swing.Timer(150, (ActionListener)object3);
                        timer.start();
                    }
                    this.pageNumber = n2;
                    object3 = this.currentPdfFile.getReferenceforPage(n2);
                    if (object3 != null && this.currentPdfFile == null) {
                        throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                    }
                    if (pdfObject == null) {
                        pdfObject = new PageObject((String)object3);
                        this.currentPdfFile.readObject(pdfObject);
                    }
                    PdfStreamDecoder pdfStreamDecoder = null;
                    if (pdfObject != null) {
                        object2 = pdfObject.getKeyArray(1216184967);
                        pdfStreamDecoder = new PdfStreamDecoder(this.currentPdfFile, this.useHiResImageForDisplay, this.res.getPdfLayerList());
                        pdfStreamDecoder.setXMLExtraction(this.options.isXMLExtraction());
                        this.currentDisplay.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                        this.currentDisplay.setPrintPage(n2);
                        this.currentDisplay.setCustomColorHandler((ColorHandler)this.externalHandlers.getExternalHandler(19));
                        pdfStreamDecoder.setParameters(true, this.renderPage, this.renderMode, this.extractionMode);
                        this.externalHandlers.addHandlers(pdfStreamDecoder);
                        pdfStreamDecoder.setObjectValue(-9, this.filename);
                        pdfStreamDecoder.setIntValue(-10, n2);
                        pdfStreamDecoder.setObjectValue(-8, this.objectStoreRef);
                        pdfStreamDecoder.setObjectValue(-3, this.statusBar);
                        pdfStreamDecoder.setObjectValue(-18, this.pageData);
                        pdfStreamDecoder.setObjectValue(23, this.currentDisplay);
                        if (object2 != null) {
                            this.res.setupResources(pdfStreamDecoder, false, pdfObject.getDictionary(2004251818), this.pageNumber, this.currentPdfFile);
                            if (this.g2 != null) {
                                pdfStreamDecoder.setObjectValue(-7, this.g2);
                            }
                            this.currentDisplay.init(this.pageData.getMediaBoxWidth(this.pageNumber), this.pageData.getMediaBoxHeight(this.pageNumber), this.pageData.getRotation(this.pageNumber), this.options.getPageColor());
                            try {
                                if (this.textLines != null) {
                                    this.textLines.setLineAreas(null);
                                }
                                pdfStreamDecoder.decodePageContent(pdfObject);
                                if (this.textLines != null) {
                                    Vector_Rectangle vector_Rectangle = (Vector_Rectangle)pdfStreamDecoder.getObjectValue(-21);
                                    vector_Rectangle.trim();
                                    Rectangle[] rectangleArray = vector_Rectangle.get();
                                    Vector_Int vector_Int = (Vector_Int)pdfStreamDecoder.getObjectValue(22);
                                    vector_Int.trim();
                                    int[] nArray = vector_Int.get();
                                    for (int i = 0; i != rectangleArray.length; ++i) {
                                        this.textLines.addToLineAreas(rectangleArray[i], nArray[i], n2);
                                    }
                                }
                            }
                            catch (Error error) {
                                this.decodeStatus = this.decodeStatus + "Error in decoding page " + error.toString();
                            }
                            this.fontsInFile = (String)pdfStreamDecoder.getObjectValue(373243460);
                            this.imagesInFile = (String)pdfStreamDecoder.getObjectValue(1026635598);
                            this.pdfData = (PdfData)pdfStreamDecoder.getObjectValue(-19);
                            this.pdfImages = (PdfImageData)pdfStreamDecoder.getObjectValue(-20);
                            this.resultsFromDecode.update(pdfStreamDecoder, true);
                        } else if (this.currentDisplay.getType() == 3) {
                            int n3 = this.pageData.getMediaBoxWidth(this.pageNumber);
                            int n4 = this.pageData.getMediaBoxHeight(this.pageNumber);
                            int n5 = this.pageData.getRotation(this.pageNumber);
                            this.currentDisplay.init(n3, n4, n5, this.options.getPageColor());
                        }
                    }
                    if (timer != null) {
                        timer.stop();
                        this.statusBar.setProgress(100);
                    }
                    if (this.renderPage && !bl2 && this.formRenderer != null && !this.formRenderer.ignoreForms() && this.formRenderer.hasFormsOnPage(n2)) {
                        if (!SwingUtilities.isEventDispatchThread() && this.formRenderer.getFormFactory().getType() == 1) {
                            object2 = pdfStreamDecoder;
                            Runnable runnable = new Runnable((PdfStreamDecoder)object2){
                                final /* synthetic */ PdfStreamDecoder val$finalCurrent;
                                {
                                    this.val$finalCurrent = pdfStreamDecoder;
                                }

                                public void run() {
                                    PdfDecoder.this.createFormComponents(n2, this.val$finalCurrent);
                                    PdfDecoder.this.isDecoding = false;
                                    PdfDecoder.this.currentDisplay.flagDecodingFinished();
                                }
                            };
                            bl = true;
                            SwingUtilities.invokeLater(runnable);
                            this.waitForDecodingToFinish();
                        } else {
                            this.createFormComponents(n2, pdfStreamDecoder);
                            this.isDecoding = false;
                        }
                    }
                }
                finally {
                    if (!bl) {
                        this.isDecoding = false;
                        if (this.statusBar != null) {
                            this.statusBar.percentageDone = 100.0f;
                        }
                    }
                }
            }
        }
        if (TTGlyph.redecodePage) {
            TTGlyph.redecodePage = false;
            this.decodePage(n);
        }
        this.currentDisplay.flagDecodingFinished();
    }

    public synchronized boolean isPageAvailable(int n) {
        return this.linearParser.isPageAvailable(n, this.currentPdfFile);
    }

    void createFormComponents(int n, PdfStreamDecoder pdfStreamDecoder) {
        if (this.currentDisplay.getType() == 5) {
            return;
        }
        if (this.currentOffset != null) {
            this.formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, (int)this.swingPainter.getIndent(), 0, 0, 1, this.currentOffset.widestPageNR, this.currentOffset.widestPageR);
        }
        this.formRenderer.createDisplayComponentsForPage(n, pdfStreamDecoder);
    }

    public void printAdditionalObjectsOverPage(int n, int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        this.swingPrinter.printAdditionalObjectsOverPage(n, nArray, colorArray, objectArray);
    }

    public void printAdditionalObjectsOverAllPages(int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        this.swingPrinter.printAdditionalObjectsOverAllPages(nArray, colorArray, objectArray);
    }

    public void useHiResScreenDisplay(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void decodePageInBackground(int n) throws Exception {
        if (this.isDecoding) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[PDF]WARNING - this file is being decoded already in foreground");
                LogWriter.writeLog("[PDF]Multiple access not recommended - use  waitForDecodingToFinish() to check");
            }
        } else if (this.isBackgroundDecoding) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[PDF]WARNING - this file is being decoded already in background");
            }
        } else {
            try {
                this.isBackgroundDecoding = true;
                if (n > this.pageCount) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Page out of bounds");
                    }
                } else {
                    String string = this.currentPdfFile.getReferenceforPage(n);
                    if (string != null) {
                        if (this.currentPdfFile == null) {
                            throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                        }
                        PageObject pageObject = new PageObject(string);
                        this.currentPdfFile.readObject(pageObject);
                        PdfObject pdfObject = ((PdfObject)pageObject).getDictionary(2004251818);
                        if (pageObject != null) {
                            ObjectStore objectStore = new ObjectStore();
                            PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.currentPdfFile);
                            pdfStreamDecoder.setParameters(true, false, 0, this.extractionMode);
                            pdfStreamDecoder.setXMLExtraction(this.options.isXMLExtraction());
                            this.externalHandlers.addHandlers(pdfStreamDecoder);
                            pdfStreamDecoder.setObjectValue(-9, this.filename);
                            pdfStreamDecoder.setObjectValue(-8, objectStore);
                            pdfStreamDecoder.setObjectValue(-18, this.pageData);
                            pdfStreamDecoder.setIntValue(-10, n);
                            this.res.setupResources(pdfStreamDecoder, false, pdfObject, this.pageNumber, this.currentPdfFile);
                            pdfStreamDecoder.decodePageContent(pageObject);
                            this.pdfBackgroundData = (PdfData)pdfStreamDecoder.getObjectValue(-19);
                            this.pdfBackgroundImages = (PdfImageData)pdfStreamDecoder.getObjectValue(-20);
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.isBackgroundDecoding = false;
            }
        }
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    public final boolean isEncrypted() {
        if (this.currentPdfFile != null) {
            PdfFileReader pdfFileReader = this.currentPdfFile.getObjectReader();
            DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
            return decryptionFactory != null && decryptionFactory.getBooleanValue(101);
        }
        return false;
    }

    public final boolean isPasswordSupplied() {
        FileAccess fileAccess = (FileAccess)this.getJPedalObject(0x6F6A6AAF);
        return fileAccess.isPasswordSupplied(this.currentPdfFile);
    }

    public boolean isFileViewable() {
        FileAccess fileAccess = (FileAccess)this.getJPedalObject(0x6F6A6AAF);
        return fileAccess.isFileViewable(this.currentPdfFile);
    }

    public boolean isExtractionAllowed() {
        if (this.currentPdfFile != null) {
            PdfFileReader pdfFileReader = this.currentPdfFile.getObjectReader();
            DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
            return decryptionFactory == null || decryptionFactory.getBooleanValue(103);
        }
        return false;
    }

    private void verifyAccess() {
        block3: {
            if (this.currentPdfFile != null) {
                try {
                    this.openPdfFile();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception " + exception + " opening file");
                }
            }
        }
    }

    public final void setEncryptionPassword(String string) throws PdfException {
        if (this.currentPdfFile == null) {
            throw new PdfException("Must open PdfDecoder file first");
        }
        this.currentPdfFile.getObjectReader().setPassword(string);
        this.verifyAccess();
    }

    public final void openPdfArray(byte[] byArray) throws PdfException {
        if (byArray == null) {
            throw new RuntimeException("Attempting to open null byte stream");
        }
        if (this.isOpen) {
            this.closePdfFile();
        }
        this.isOpen = false;
        this.res.flush();
        try {
            this.currentPdfFile = new PdfReader();
            this.currentPdfFile.openPdfFile(byArray);
            this.openPdfFile();
            this.objectStoreRef.storeFileName("r" + System.currentTimeMillis());
        }
        catch (Exception exception) {
            throw new PdfException("[PDF] OpenPdfArray generated exception " + exception.getMessage());
        }
    }

    public void openPdfFile(String string, Certificate certificate, PrivateKey privateKey) throws PdfException {
        this.fileAcces.setUserEncryption(certificate, privateKey);
        this.openPdfFile(string);
    }

    public final void openPdfFile(String string) throws PdfException {
        if (this.isOpen && this.linearParser.linearizedBackgroundReaderer == null) {
            this.closePdfFile();
        }
        this.isOpen = false;
        this.displayScaling = null;
        this.filename = string;
        this.res.flush();
        this.objectStoreRef.storeFileName(string);
        this.currentPdfFile = this.fileAcces.getNewReader();
        this.currentPdfFile.openPdfFile(string);
        this.openPdfFile();
    }

    public final void openPdfFile(String string, String string2) throws PdfException {
        if (this.isOpen) {
            this.closePdfFile();
        }
        this.isOpen = false;
        this.displayScaling = null;
        this.filename = string;
        this.res.flush();
        this.objectStoreRef.storeFileName(string);
        this.currentPdfFile = new PdfReader(string2);
        this.currentPdfFile.openPdfFile(string);
        this.openPdfFile();
    }

    public final boolean openPdfFileFromURL(String string, boolean bl) throws PdfException {
        InputStream inputStream = null;
        String string2 = null;
        try {
            URL uRL = new URL(string);
            string2 = uRL.getPath().substring(uRL.getPath().lastIndexOf(47) + 1);
            inputStream = uRL.openStream();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.readFile(bl, inputStream, string2);
    }

    public final boolean openPdfFileFromInputStream(InputStream inputStream, boolean bl) throws PdfException {
        String string = "inputstream" + System.currentTimeMillis() + '-' + this.objectStoreRef.getKey() + ".pdf";
        this.objectStoreRef.setFileToDeleteOnFlush(ObjectStore.temp_dir + string);
        this.objectStoreRef.setFileToDeleteOnFlush(string);
        return this.readFile(bl, inputStream, string);
    }

    private boolean readFile(boolean bl, InputStream inputStream, String string) throws PdfException {
        this.displayScaling = null;
        this.res.flush();
        this.currentPdfFile = new PdfReader();
        if (inputStream != null) {
            try {
                File file = string.startsWith("inputstream") ? new File(ObjectStore.temp_dir + string) : ObjectStore.createTempFile(string);
                this.objectStoreRef.storeFileName(file.getName().substring(0, file.getName().lastIndexOf(46)));
                if (bl) {
                    byte[] byArray = this.linearParser.readLinearData(this.currentPdfFile, file, inputStream, this);
                    if (byArray != null) {
                        this.currentPdfFile.openPdfFile(byArray);
                        this.openPdfFile();
                        this.linearParser.linearizedBackgroundReaderer.start();
                        return true;
                    }
                } else {
                    this.currentPdfFile.openPdfFile(inputStream);
                    this.openPdfFile();
                }
                if (bl) {
                    this.openPdfFile(file.getAbsolutePath());
                    this.objectStoreRef.storeFileName(file.getName().substring(0, file.getName().lastIndexOf(46)));
                }
            }
            catch (IOException iOException) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Exception " + iOException + " opening URL ");
                }
                iOException.printStackTrace();
            }
        }
        return false;
    }

    private synchronized void openPdfFile() throws PdfException {
        this.pageNumber = 1;
        this.swingPainter.forceRedraw();
        try {
            this.isDecoding = true;
            this.pages.resetCachedValues();
            if (this.viewListener != null) {
                this.pages.flushPageCaches();
                this.removeComponentListener(this.viewListener);
                this.viewListener.dispose();
                this.viewListener = null;
            }
            this.currentPdfFile.getObjectReader().setCacheSize(this.minimumCacheSize);
            this.swingPrinter.lastPrintedPage = -1;
            this.swingPrinter.currentPrintDecoder = null;
            if (this.formRenderer != null) {
                this.formRenderer.getCompData().setRootDisplayComponent(this);
            }
            this.pageData = new PdfPageData();
            String string = this.currentPdfFile.getObjectReader().getType();
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Pdf version : " + string);
            }
            if (string == null) {
                this.currentPdfFile = null;
                this.isDecoding = false;
                throw new PdfException("No version on first line ");
            }
            PdfObject pdfObject = null;
            int n = -1;
            if (this.linearParser.hasLinearData()) {
                pdfObject = this.linearParser.readHintTable(pdfObject, this.currentPdfFile);
                n = this.linearParser.getPageCount();
            } else {
                pdfObject = this.currentPdfFile.getObjectReader().readReferenceTable(null);
            }
            if (!this.isEncrypted() || this.isPasswordSupplied()) {
                PdfObject pdfObject2;
                int n2;
                if (pdfObject != null) {
                    pdfObject.ignoreRecursion(true);
                    this.res.setValues(pdfObject, this.currentPdfFile);
                    PdfObject pdfObject3 = pdfObject.getDictionary(826094945);
                    if (pdfObject3 != null) {
                        this.currentPdfFile.readNames(pdfObject3, this.options.getJS(), false);
                    }
                }
                if ((n2 = pdfObject.getParameterConstant(608780341)) != 540096309 && (pdfObject2 = pdfObject.getDictionary(825701731)) != null) {
                    pdfObject = new PageObject(pdfObject2.getObjectRefAsString());
                    this.currentPdfFile.readObject(pdfObject);
                    if (pdfObject.getParameterConstant(608780341) == -1) {
                        pdfObject = pdfObject2;
                    }
                }
                if (pdfObject != null) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Pages being read from " + pdfObject + ' ' + pdfObject.getObjectRefAsString());
                    }
                    this.pageNumber = 1;
                    if (this.formRenderer != null) {
                        this.formRenderer.resetAnnotData(this.insetW, this.insetH, this.pageData, 1, this.currentPdfFile, null);
                    }
                    int n3 = this.readAllPageReferences(true, pdfObject, new HashMap(1000), new HashMap(1000), 1);
                    this.pageCount = n > 0 ? n : n3 - 1;
                    this.pageNumber = 0;
                    if (this.pageCount == 0 && LogWriter.isOutput()) {
                        LogWriter.writeLog("No pages found");
                    }
                }
                if (this.formRenderer != null) {
                    this.formRenderer.openFile(this.pageCount);
                    this.formRenderer.resetFormData(this.insetW, this.insetH, this.pageData, this.currentPdfFile, this.res.getPdfObject(1));
                }
            }
            this.currentOffset = null;
            this.pages.disableScreen();
            this.pages.stopGeneratingPage();
            this.displayView = this.pageCount < 2 ? 1 : this.options.getPageMode();
            this.setDisplayView(this.displayView, this.alignment);
            this.isOpen = true;
        }
        catch (PdfException pdfException) {
            this.isDecoding = false;
            this.isOpen = true;
            this.closePdfFile();
            this.isOpen = false;
            this.isDecoding = false;
            throw new PdfException(pdfException.getMessage() + " opening file");
        }
        this.isDecoding = false;
    }

    public Object getJPedalObject(int n) {
        switch (n) {
            case 826881374: {
                return this.res.getPdfLayerList();
            }
            case 2004845231: {
                return this.linearParser.getLinearObject(this.isOpen, this.currentPdfFile);
            }
            case -1276915978: {
                return this.linearParser.linearizedBackgroundReaderer;
            }
            case 0x6F6A6AAF: {
                return this.fileAcces;
            }
        }
        return null;
    }

    public void setPageMode(int n) {
        this.options.setPageMode(n);
    }

    private int readAllPageReferences(boolean bl, PdfObject pdfObject, Map map, Map map2, int n) {
        Object object;
        String string = pdfObject.getObjectRefAsString();
        int n2 = 0;
        int n3 = pdfObject.getParameterConstant(608780341);
        if (n3 == -1) {
            n3 = 825701731;
        }
        int n4 = pdfObject.getInt(1144088180);
        String string2 = pdfObject.getStringKey(1110793845);
        if (n4 == -1) {
            while (string2 != null && n4 == -1) {
                if (string2 != null && (object = map.get(string2)) != null) {
                    n4 = (Integer)object;
                }
                if (n4 != -1) continue;
                string2 = (String)map2.get(string2);
            }
            if (n4 != -1) {
                map.put(string, new Integer(n4));
                map2.put(string, string2);
            }
        } else {
            map.put(string, new Integer(n4));
            map2.put(string, string2);
        }
        if (n4 != -1) {
            n2 = n4;
        }
        this.pageData.setPageRotation(n2, n);
        object = pdfObject.getFloatArray(1313305473);
        float[] fArray = pdfObject.getFloatArray(1076199815);
        if (object != null) {
            this.pageData.setMediaBox((float[])object);
        }
        if (fArray != null) {
            this.pageData.setCropBox(fArray);
        }
        if (n3 == 825701731) {
            this.res.setPdfObject(2, pdfObject.getDictionary(2004251818));
            byte[][] byArray = pdfObject.getKeyArray(456733763);
            int n5 = 0;
            if (byArray != null) {
                n5 = byArray.length;
            }
            if (n5 > 0) {
                for (int i = 0; i < n5; ++i) {
                    PageObject pageObject = new PageObject(new String(byArray[i]));
                    pageObject.ignoreRecursion(bl);
                    pageObject.ignoreStream(true);
                    this.currentPdfFile.readObject(pageObject);
                    n = this.readAllPageReferences(bl, pageObject, map, map2, n);
                }
            }
        } else if (n3 == 540096309) {
            this.currentPdfFile.setLookup(string, n);
            this.pageData.checkSizeSet(n);
            if (this.formRenderer != null) {
                byte[][] byArray = pdfObject.getKeyArray(1044338049);
                if (byArray != null && byArray.length == 1 && byArray[0] == null) {
                    byArray = null;
                }
                if (byArray != null) {
                    this.formRenderer.resetAnnotData(this.insetW, this.insetH, this.pageData, n, this.currentPdfFile, byArray);
                }
            }
            ++n;
        }
        return n;
    }

    public boolean isXMLExtraction() {
        return this.options.isXMLExtraction();
    }

    public void useTextExtraction() {
        this.options.setXMLExtraction(false);
    }

    public void useXMLExtraction() {
        this.options.setXMLExtraction(true);
    }

    public void clearScreen() {
        this.currentDisplay.flush();
        this.pages.refreshDisplay();
    }

    public void setStreamCacheSize(int n) {
        this.minimumCacheSize = n;
    }

    public boolean hasEmbeddedFonts() {
        return this.resultsFromDecode.hasEmbeddedFonts();
    }

    public final boolean PDFContainsEmbeddedFonts() throws Exception {
        boolean bl = false;
        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.currentPdfFile);
        for (int i = 1; i < this.pageCount + 1; ++i) {
            String string = this.currentPdfFile.getReferenceforPage(i);
            if (string == null) continue;
            PageObject pageObject = new PageObject(string);
            pageObject.ignoreStream(true);
            this.currentPdfFile.readObject(pageObject);
            byte[][] byArray = ((PdfObject)pageObject).getKeyArray(1216184967);
            if (byArray == null) continue;
            this.res.setupResources(pdfStreamDecoder, false, ((PdfObject)pageObject).getDictionary(2004251818), this.pageNumber, this.currentPdfFile);
            bl = pdfStreamDecoder.getBooleanValue(-1);
            if (!bl) continue;
            i = this.pageCount;
        }
        return bl;
    }

    public int getPageFromObjectRef(String string) {
        return this.currentPdfFile.convertObjectToPageNumber(string);
    }

    public String getInfo(int n) {
        String string;
        switch (n) {
            case 373243460: {
                if (this.fontsInFile == null) {
                    string = "No fonts defined";
                    break;
                }
                string = this.fontsInFile;
                break;
            }
            case 1026635598: {
                if (this.imagesInFile == null) {
                    string = "No images defined as XObjects";
                    break;
                }
                string = this.imagesInFile;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public AcroRenderer getFormRenderer() {
        return this.formRenderer;
    }

    public boolean isPageSuccessful() {
        return this.swingPrinter.isPageSuccessful();
    }

    public String getPageDecodeReport() {
        return this.decodeStatus;
    }

    public String getPageFailureMessage() {
        return this.swingPrinter.getPageFailureMessage();
    }

    public BufferedImage getSelectedRectangleOnscreen(float f, float f2, float f3, float f4, float f5) {
        BufferedImage bufferedImage = SwingPainter.getSelectedRectangleOnscreen(f, f2, f3, f4, f5, this.pageNumber, this.pageData, this.formRenderer, this.currentDisplay, this.currentPdfFile);
        this.formRenderer.getCompData().resetScaledLocation(this.pages.getOldScaling(), this.displayRotation, 0);
        return bufferedImage;
    }

    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStoreRef = objectStore;
    }

    public PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        return this.options.getGroupingObject(this.lastPageDecoded, this.getPdfData(), this.pageData);
    }

    public PdfGroupingAlgorithms getBackgroundGroupingObject() {
        return this.options.getBackgroundGroupingObject(this.pdfBackgroundData, this.pageData);
    }

    public final String getPDFVersion() {
        if (this.currentPdfFile == null) {
            return "";
        }
        return this.currentPdfFile.getObjectReader().getType();
    }

    public void resetForNonPDFPage(int n) {
        this.displayScaling = null;
        this.currentDisplay.setHiResImageForDisplayMode(false);
        this.fontsInFile = "";
        this.pageCount = n;
        if (this.formRenderer != null) {
            this.formRenderer.removeDisplayComponentsFromScreen();
        }
        this.pageData = new PdfPageData();
    }

    public void setDisplayView(int n, int n2) {
        boolean bl;
        this.alignment = n2;
        if (this.pages != null) {
            this.pages.stopGeneratingPage();
        }
        boolean bl2 = bl = n != 1 || this.displayView != 1;
        if (bl && (this.displayView == 3 || n == 3)) {
            bl = false;
        }
        if (n != 1) {
            bl = true;
        }
        boolean bl3 = n != this.displayView;
        int n3 = this.displayView;
        this.displayView = n;
        switch (n) {
            case 1: {
                if (this.pages != null && !bl3) break;
                this.pages = new SingleDisplay(this.pageNumber, this.pageCount, this.currentDisplay);
            }
        }
        if (this.viewListener != null) {
            this.removeComponentListener(this.viewListener);
            this.viewListener.dispose();
            this.viewListener = null;
        }
        if (this.currentOffset == null) {
            this.currentOffset = new PageOffsets(this.pageCount, this.pageData);
        }
        this.pages.setup(this.useAcceleration, this.currentOffset, this);
        this.pages.init(this.scaling, this.pageCount, this.displayRotation, this.pageNumber, this.currentDisplay, true, this.pageData, this.insetW, this.insetH);
        this.swingPainter.forceRedraw();
        this.pages.refreshDisplay();
        if (this.viewListener == null) {
            this.viewListener = new RefreshLayout();
            this.addComponentListener(this.viewListener);
        }
        if (this.pageNumber > 0) {
            if (bl3 && n == 1) {
                try {
                    this.unsetScaling();
                    this.setPageParameters(this.scaling, this.pageNumber, this.displayRotation);
                    this.invalidate();
                    this.updateUI();
                    this.decodePage(this.pageNumber);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (n != 1 && n != 6) {
                throw new RuntimeException("Only SINGLE_PAGE is available in LGPL release");
            }
        }
    }

    public boolean hasAllImages() {
        return this.resultsFromDecode.getImagesProcessedFully();
    }

    public boolean getPageDecodeStatus(int n) {
        return this.resultsFromDecode.getPageDecodeStatus(n);
    }

    public String getPageDecodeStatusReport(int n) {
        return this.resultsFromDecode.getPageDecodeStatusReport(n);
    }

    public void setPrintAutoRotateAndCenter(boolean bl) {
        this.swingPrinter.isPrintAutoRotateAndCenter = bl;
    }

    public void setPrintCurrentView(boolean bl) {
        this.swingPrinter.printOnlyVisible = bl;
    }

    public void addExternalHandler(Object object, int n) {
        switch (n) {
            case 3: {
                this.formRenderer.setFormFactory((FormFactory)object);
                break;
            }
            case 4: {
                this.customSwingHandle = object;
                break;
            }
            case 5: {
                if (this.formRenderer == null) break;
                this.formRenderer.resetHandler(object, this, 5);
                break;
            }
            case 10: {
                if (this.formRenderer == null) break;
                this.formRenderer.getActionHandler().setMouseHandler((SwingMouseListener)object);
                break;
            }
            case 8: {
                this.pages.setThumbnailPanel((GUIThumbnailPanel)object);
                break;
            }
            default: {
                this.externalHandlers.addExternalHandler(object, n);
            }
        }
    }

    public Object getExternalHandler(int n) {
        switch (n) {
            case 3: {
                return this.formRenderer.getFormFactory();
            }
            case 4: {
                return this.customSwingHandle;
            }
            case 16: {
                return this.pages;
            }
            case 17: {
                return this.currentOffset;
            }
        }
        return this.externalHandlers.getExternalHandler(n);
    }

    public void unsetScaling() {
        this.displayScaling = null;
    }

    public PdfObjectReader getIO() {
        return this.currentPdfFile;
    }

    public String getFileName() {
        return this.filename;
    }

    public boolean isForm() {
        return this.res.isForm();
    }

    public String getReferenceforPage(int n) {
        return this.currentPdfFile.getReferenceforPage(n);
    }

    public void setAllowDifferentPrintPageSizes(boolean bl) {
        this.swingPrinter.allowDifferentPrintPageSizes = bl;
    }

    public TextLines getTextLines() {
        return this.textLines;
    }

    public final void setInset(int n, int n2) {
        this.insetW = n;
        this.insetH = n2;
    }

    public void ensurePointIsVisible(Point point) {
        super.scrollRectToVisible(new Rectangle(point.x, this.y_size - point.y, this.scrollInterval, this.scrollInterval));
    }

    public void setPrintIndent(int n, int n2) {
        this.swingPrinter.setPrintIndent(n, n2);
    }

    public void setUserOffsets(int n, int n2, int n3) {
        this.swingPainter.getDisplayOffsets().setUserOffsets(n, n2, n3, this.externalHandlers, this);
    }

    public Point getUserOffsets(int n) {
        return this.swingPainter.getDisplayOffsets().getUserOffsets(n);
    }

    public final Dimension getMaximumSize() {
        Dimension dimension = null;
        if (this.displayView != 1) {
            dimension = this.pages.getPageSize(this.displayView);
        }
        if (dimension == null) {
            dimension = this.displayRotation == 90 || this.displayRotation == 270 ? new Dimension(this.y_size + this.insetW + this.insetW, this.x_size + this.insetH + this.insetH) : new Dimension(this.x_size + this.insetW + this.insetW, this.y_size + this.insetH + this.insetH);
        }
        if (dimension == null) {
            dimension = this.getMinimumSize();
        }
        return dimension;
    }

    public final Dimension getMinimumSize() {
        return new Dimension(100 + this.insetW, 100 + this.insetH);
    }

    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    public final void updateCursorBoxOnScreen(Rectangle rectangle, Color color) {
        if (this.displayView != 1) {
            return;
        }
        this.swingPainter.updateCursorBoxOnScreen(rectangle, color, this, this.pageNumber);
    }

    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            if (!this.isDecoding) {
                this.swingPainter.drawCursor(graphics, this.alignment);
            }
        }
        catch (Exception exception) {
            this.pages.flushPageCaches();
        }
        catch (Error error) {
            this.pages.flushPageCaches();
            this.pages.stopGeneratingPage();
            super.paint(graphics);
        }
    }

    public void paintComponent(Graphics graphics) {
        final RenderChangeListener renderChangeListener = (RenderChangeListener)this.externalHandlers.getExternalHandler(21);
        if (renderChangeListener != null) {
            renderChangeListener.renderingStarted(this.pageNumber);
        }
        super.paintComponent(graphics);
        if (SwingUtilities.isEventDispatchThread()) {
            this.threadSafePaint(graphics);
            if (renderChangeListener != null) {
                renderChangeListener.renderingEnded(this.pageNumber);
            }
        } else {
            final Graphics graphics2 = graphics;
            final int n = this.pageNumber;
            Runnable runnable = new Runnable(){

                public void run() {
                    PdfDecoder.this.threadSafePaint(graphics2);
                    if (renderChangeListener != null) {
                        renderChangeListener.renderingEnded(n);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    synchronized void threadSafePaint(Graphics graphics) {
        if (this.displayScaling == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!this.isDecoding && this.renderPage) {
            this.swingPainter.paintPage(graphics2D, this, this.pages, this.pageData, this.pageNumber, this.currentDisplay, this.displayView, this.displayRotation, this.insetW, this.insetH, this.textLines, this.myBorder, this.currentOffset, this.externalHandlers);
        } else {
            this.currentDisplay.setG2(graphics2D);
            this.currentDisplay.paintBackground(null);
        }
    }

    public final int getPDFWidth() {
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.y_size + this.insetW + this.insetW;
        }
        return this.x_size + this.insetW + this.insetW;
    }

    public final int getPDFHeight() {
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            return this.x_size + this.insetH + this.insetH;
        }
        return this.y_size + this.insetH + this.insetH;
    }

    public final void setPDFBorder(Border border) {
        this.myBorder = border;
    }

    public void setHardwareAccelerationforScreen(boolean bl) {
        this.useAcceleration = bl;
    }

    public int getScrollInterval() {
        return this.scrollInterval;
    }

    public void setScrollInterval(int n) {
        this.scrollInterval = n;
    }

    public int getDisplayView() {
        return this.displayView;
    }

    public void setPrintPageScalingMode(int n) {
        this.swingPrinter.setPrintPageScalingMode(n);
    }

    public void setUsePDFPaperSize(boolean bl) {
        this.swingPrinter.usePDFPaperSize = bl;
    }

    public float getScaling() {
        return this.scaling;
    }

    public int getInsetH() {
        return this.insetH;
    }

    public int getInsetW() {
        return this.insetW;
    }

    public Rectangle getCursorBoxOnScreen() {
        return this.swingPainter.getCursorBoxOnScreen();
    }

    public int getNumberOfPages() {
        return this.swingPrinter.getNumberOfPages(this.pageCount);
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.swingPrinter.getPageFormat(n, this.pageData, this.pageCount);
    }

    public void setCenterOnScaling(boolean bl) {
        this.swingPrinter.setCenterOnScaling(bl);
    }

    public void setPageFormat(int n, PageFormat pageFormat) {
        this.swingPrinter.putPageFormat(new Integer(n), pageFormat);
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.swingPrinter.putPageFormat("standard", pageFormat);
    }

    public void setPagePrintRange(SetOfIntegerSyntax setOfIntegerSyntax) throws PdfException {
        if (setOfIntegerSyntax == null) {
            throw new PdfException("[PDF] null page range entered");
        }
        this.swingPrinter.setPagePrintRange(setOfIntegerSyntax, this.pageCount);
    }

    public void setPrintPageMode(int n) {
        this.swingPrinter.setPrintPageMode(n);
    }

    public final void stopPrinting() {
        this.swingPrinter.stopPrinting();
    }

    public int getCurrentPrintPage() {
        return this.swingPrinter.getCurrentPrintPage();
    }

    public void resetCurrentPrintPage() {
        this.swingPrinter.currentPrintPage = 0;
        this.formRenderer.getCompData().resetAfterPrinting();
    }

    static {
        try {
            String string = System.getProperty("os.name");
            if (string.equals("Mac OS X")) {
                isRunningOnMac = true;
            } else if (string.startsWith("Windows")) {
                isRunningOnWindows = true;
            } else if (string.startsWith("AIX")) {
                isRunningOnAIX = true;
            } else if (string.equals("Linux")) {
                isRunningOnLinux = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        showErrorMessages = false;
    }

    private class ProgressListener
    implements ActionListener {
        private ProgressListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PdfDecoder.this.statusBar.setProgress((int)((PdfDecoder)PdfDecoder.this).statusBar.percentageDone);
        }
    }

    private class RefreshLayout
    extends ComponentAdapter {
        Timer t2 = null;

        private RefreshLayout() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.startTimer();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.startTimer();
        }

        private void startTimer() {
            if (this.t2 != null) {
                this.t2.cancel();
            }
            PageListener pageListener = new PageListener();
            this.t2 = new Timer();
            this.t2.schedule((TimerTask)pageListener, 500L);
        }

        public void dispose() {
            if (this.t2 != null) {
                this.t2.cancel();
            }
        }

        class PageListener
        extends TimerTask {
            PageListener() {
            }

            public void run() {
                try {
                    if (PdfDecoder.this.pages != null) {
                        PdfDecoder.this.pages.stopGeneratingPage();
                        if (PdfDecoder.this.pageNumber < 1) {
                            PdfDecoder.this.pageNumber = 1;
                        }
                        if (PdfDecoder.this.pages != null) {
                            PdfDecoder.this.pages.decodeOtherPages(PdfDecoder.this.pageNumber, PdfDecoder.this.pageCount);
                        }
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception in run() " + exception.getMessage());
                }
            }
        }
    }
}

