/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.synctex;

import de.vonloesch.synctex.VBoxData;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public class SimpleSynctexParser {
    public static final int SEARCH_FORWARD = 1;
    public static final int SEARCH_REVERSE = 2;
    static final boolean CONSIDERVBOX = true;
    private BufferedReader in;
    int magnification = 1000;
    int xoffset = 0;
    int yoffset = 0;
    int unit = 1;
    Map<Integer, String> fileMap;
    public String sourceFilePath;
    public int sourceLineNr;
    private int smallerLineNr;
    private Stack<VBoxData> vboxes = new Stack();
    private boolean hasRelativeFileNames = false;
    int pdfPage;
    int pdfX;
    int pdfY;
    int pdfX2;
    int pdfY2;
    private double dist;
    int nextPos;

    SimpleSynctexParser() {
        this.fileMap = new TreeMap<Integer, String>();
    }

    public SimpleSynctexParser(BufferedReader r) {
        this();
        this.in = r;
        this.resetBox();
        this.smallerLineNr = 0;
        this.dist = Double.MAX_VALUE;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    private void resetBox() {
        this.pdfX = Integer.MAX_VALUE;
        this.pdfY = Integer.MAX_VALUE;
        this.pdfX2 = 0;
        this.pdfY2 = 0;
    }

    public void setForwardSearchInformation(String name, int line) {
        this.sourceLineNr = line;
        try {
            this.sourceFilePath = new File(name).getCanonicalPath();
        }
        catch (IOException iOException) {
            this.sourceFilePath = name;
        }
    }

    public void setReverseSearchInformation(int page, double posX, double posY) {
        this.pdfPage = page;
        this.pdfX = this.fromPDFCoord(posX);
        this.pdfY = this.fromPDFCoord(posY);
    }

    private boolean isForwardPosition(int[] t) {
        if (t[1] > this.sourceLineNr) {
            return false;
        }
        String fname = this.fileMap.get(t[0]);
        if (this.sourceFilePath.equals(fname)) {
            return true;
        }
        return this.hasRelativeFileNames && this.sourceFilePath.toLowerCase().endsWith(fname.toLowerCase());
    }

    private void updatePosition(int page, int[] pos, int sourceLine) {
        if (sourceLine <= this.sourceLineNr && sourceLine >= this.smallerLineNr) {
            if (sourceLine != this.smallerLineNr) {
                this.pdfPage = page;
                this.resetBox();
                this.smallerLineNr = sourceLine;
            }
            if (page != this.pdfPage) {
                this.resetBox();
                this.pdfPage = page;
            }
            if (pos[0] < this.pdfX) {
                this.pdfX = pos[0];
            }
            if (pos[1] < this.pdfY) {
                this.pdfY = pos[1];
            }
            if (pos[0] > this.pdfX2) {
                this.pdfX2 = pos[0];
            }
            if (pos[1] > this.pdfY2) {
                this.pdfY2 = pos[1];
            }
        }
    }

    double toPDFCoord(int p) {
        return (double)(this.unit * p) / 65781.76 * (1000.0 / (double)this.magnification);
    }

    int fromPDFCoord(double p) {
        return (int)Math.round(p * 65781.76 / (double)this.unit * ((double)this.magnification / 1000.0));
    }

    public double[] getForwardSearchResult() {
        if (this.pdfPage == 0) {
            return null;
        }
        double[] result = new double[]{this.pdfPage, this.toPDFCoord(this.pdfX), this.toPDFCoord(this.pdfY), this.toPDFCoord(this.pdfX2), this.toPDFCoord(this.pdfY2)};
        return result;
    }

    public void startForward() throws IOException {
        String line;
        this.parsePreamble();
        int pageLevel = 0;
        int currentPage = 0;
        while ((line = this.in.readLine()) != null) {
            char first = line.charAt(0);
            if (pageLevel > 0) {
                int[] npos;
                int[] size;
                int[] pos;
                int[] t;
                if (first == '{') {
                    ++pageLevel;
                    currentPage = this.getColonArgInt(line, 0);
                    continue;
                }
                if (first == '}') {
                    assert (--pageLevel >= 0);
                    continue;
                }
                if (first == '[') {
                    t = this.getColonArgTuple(line, 0);
                    if (!this.isForwardPosition(t)) continue;
                    pos = this.getColonArgTuple(line, this.nextPos);
                    size = this.getColonArgTriple(line, this.nextPos);
                    npos = new int[]{pos[0], pos[1] - size[1]};
                    this.updatePosition(currentPage, npos, t[1]);
                    npos[0] = pos[0] + size[0];
                    npos[1] = pos[1] + size[2];
                    this.updatePosition(currentPage, npos, t[1]);
                    continue;
                }
                if (first == ']') continue;
                if (first == '(') {
                    t = this.getColonArgTuple(line, 0);
                    pos = this.getColonArgTuple(line, this.nextPos);
                    size = this.getColonArgTriple(line, this.nextPos);
                    VBoxData v = new VBoxData(pos, size);
                    this.vboxes.push(v);
                    if (!this.isForwardPosition(t)) continue;
                    int[] npos2 = new int[]{pos[0], pos[1] - size[1]};
                    this.updatePosition(currentPage, npos2, t[1]);
                    npos2[0] = pos[0] + size[0];
                    npos2[1] = pos[1] + size[2];
                    this.updatePosition(currentPage, npos2, t[1]);
                    continue;
                }
                if (first == ')') {
                    this.vboxes.pop();
                    continue;
                }
                if (first != 'x' && first != 'k' && first != '$' && first != 'v' && first != 'h' && first != 'g' || !this.isForwardPosition(t = this.getColonArgTuple(line, 0))) continue;
                pos = this.getColonArgTuple(line, this.nextPos);
                this.updatePosition(currentPage, pos, t[1]);
                if (this.vboxes.size() <= 0) continue;
                VBoxData v = this.vboxes.peek();
                npos = new int[]{v.pos[0], v.pos[1] - v.size[1]};
                this.updatePosition(currentPage, npos, t[1]);
                npos[0] = v.pos[0] + v.size[0];
                npos[1] = v.pos[1] + v.size[2];
                this.updatePosition(currentPage, npos, t[1]);
                continue;
            }
            if (pageLevel != 0) continue;
            assert (this.vboxes.size() == 0);
            if (first == '{') {
                currentPage = this.getColonArgInt(line, 0);
                if (!this.hasRelativeFileNames && !this.fileMap.containsValue(this.sourceFilePath)) continue;
                ++pageLevel;
                if (this.pdfPage == 0 || this.pdfPage >= currentPage - 2) continue;
                return;
            }
            if (first != 'I' || !line.startsWith("Input")) continue;
            this.parseInputLine(line);
        }
    }

    private void checkCoord(int[] t, int[] pos) {
        double cx = 1.0 * (double)pos[0];
        double cy = 1.0 * (double)pos[1];
        double d = Math.sqrt((cx - (double)this.pdfX) * (cx - (double)this.pdfX) + (cy - (double)this.pdfY) * (cy - (double)this.pdfY));
        if (d < this.dist) {
            this.sourceFilePath = this.fileMap.get(t[0]);
            this.sourceLineNr = t[1];
            this.dist = d;
        }
    }

    private void checkBox(int[] t, int[] pos, int[] size) {
        int[] npos = new int[]{pos[0], pos[1] - size[2]};
        this.checkCoord(t, npos);
        npos[0] = pos[0];
        npos[1] = pos[1] + size[1];
        this.checkCoord(t, npos);
        npos[0] = pos[0] + size[0];
        npos[1] = pos[1] - size[2];
        this.checkCoord(t, npos);
        npos[0] = pos[0] + size[0];
        npos[1] = pos[1] + size[1];
        this.checkCoord(t, npos);
    }

    public void startReverse() throws IOException {
        String line;
        this.parsePreamble();
        int pageLevel = 0;
        int currentPage = 0;
        while ((line = this.in.readLine()) != null) {
            char first = line.charAt(0);
            if (pageLevel > 0) {
                int[] pos;
                int[] t;
                if (first == '{') {
                    ++pageLevel;
                    currentPage = this.getColonArgInt(line, 0);
                    continue;
                }
                if (first == '}') {
                    assert (--pageLevel >= 0);
                    continue;
                }
                if (first == '[' || first == '(') {
                    t = this.getColonArgTuple(line, 0);
                    pos = this.getColonArgTuple(line, this.nextPos);
                    int[] size = this.getColonArgTriple(line, this.nextPos);
                    this.checkBox(t, pos, size);
                    continue;
                }
                if (first == ']' || first == ')' || first != 'x' && first != 'k' && first != '$' && first != 'v' && first != 'h' && first != 'g') continue;
                t = this.getColonArgTuple(line, 0);
                pos = this.getColonArgTuple(line, this.nextPos);
                this.checkCoord(t, pos);
                continue;
            }
            if (pageLevel != 0) continue;
            assert (this.vboxes.size() == 0);
            if (first == '{') {
                currentPage = this.getColonArgInt(line, 0);
                if (currentPage < this.pdfPage) continue;
                if (currentPage > this.pdfPage) {
                    return;
                }
                ++pageLevel;
                continue;
            }
            if (first != 'I' || !line.startsWith("Input")) continue;
            this.parseInputLine(line);
        }
    }

    /*
     * Unable to fully structure code
     */
    void parsePreamble() throws IOException {
        line = this.in.readLine();
        if (SimpleSynctexParser.$assertionsDisabled || line.startsWith("SyncTeX Version")) ** GOTO lbl21
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if (line.startsWith("Input")) {
                this.parseInputLine(line);
                continue;
            }
            if (line.startsWith("Magnification")) {
                this.magnification = this.getColonArgInt(line, 13);
                continue;
            }
            if (line.startsWith("X Offset")) {
                this.xoffset = this.getColonArgInt(line, 8);
                continue;
            }
            if (line.startsWith("Y Offset")) {
                this.yoffset = this.getColonArgInt(line, 8);
                continue;
            }
            if (line.startsWith("Unit")) {
                this.unit = this.getColonArgInt(line, 4);
                continue;
            }
            if (!line.startsWith("Content")) continue;
            return;
lbl21:
            // 7 sources

            ** while ((line = this.in.readLine()) != null)
        }
lbl22:
        // 1 sources

        if (!SimpleSynctexParser.$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    void parseInputLine(String line) {
        assert (line.startsWith("Input"));
        int fileNr = this.getColonArgInt(line, 5);
        String fileName = line.substring(this.nextPos + 1);
        try {
            File f = new File(fileName);
            if (f.isAbsolute()) {
                fileName = new File(fileName).getCanonicalPath();
            } else {
                this.hasRelativeFileNames = true;
            }
        }
        catch (IOException iOException) {}
        this.fileMap.put(fileNr, fileName);
    }

    int[] getColonArgTriple(String line, int pos) {
        String t = this.getColonArg(line, pos);
        int firstC = t.indexOf(44);
        assert (firstC > 0);
        int[] tuple = new int[3];
        tuple[0] = Integer.parseInt(t.substring(0, firstC));
        int secondC = t.indexOf(44, firstC + 1);
        tuple[1] = Integer.parseInt(t.substring(firstC + 1, secondC));
        tuple[2] = Integer.parseInt(t.substring(secondC + 1));
        return tuple;
    }

    int[] getColonArgTuple(String line, int pos) {
        String t = this.getColonArg(line, pos);
        int firstC = t.indexOf(44);
        assert (firstC > 0);
        int[] tuple = new int[]{Integer.parseInt(t.substring(0, firstC)), Integer.parseInt(t.substring(firstC + 1))};
        return tuple;
    }

    int getColonArgInt(String line, int pos) {
        return Integer.parseInt(this.getColonArg(line, pos));
    }

    String getColonArg(String line, int pos) {
        int endPos = line.indexOf(58, pos + 1);
        if (endPos < 0) {
            endPos = line.length();
        }
        this.nextPos = endPos;
        return line.substring(pos + 1, endPos);
    }
}

