/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.editors;

import de.vonloesch.pdf4eclipse.editors.PDFEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;

public class PDFNavigationLocation
extends NavigationLocation {
    int page;
    Point origin;

    public PDFNavigationLocation(IEditorPart editor) {
        super(editor);
        this.update();
    }

    public void update() {
        if (this.getEditorPart() instanceof PDFEditor) {
            PDFEditor editor = (PDFEditor)this.getEditorPart();
            this.page = editor.currentPage;
            this.origin = editor.getOrigin();
        }
    }

    public void saveState(IMemento memento) {
        memento.putInteger("Page", this.page);
    }

    public void restoreState(IMemento memento) {
        this.page = memento.getInteger("Page");
        this.restoreLocation();
    }

    public void restoreLocation() {
        if (this.getEditorPart() instanceof PDFEditor) {
            PDFEditor editor = (PDFEditor)this.getEditorPart();
            editor = (PDFEditor)this.getEditorPart();
            editor.showPage(this.page);
            editor.setOrigin(this.origin);
        }
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (currentLocation instanceof PDFNavigationLocation) {
            PDFNavigationLocation loc = (PDFNavigationLocation)currentLocation;
            if (loc.page == this.page && this.origin.equals((Object)loc.origin)) {
                return true;
            }
        }
        return false;
    }
}

