/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentPartitioningChangedEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.IDocumentPartitionerExtension3;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension2;
import org.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ILineTrackerExtension;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRepairableDocument;
import org.eclipse.jface.text.IRepairableDocumentExtension;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.events.AboutToBeChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.IModelAboutToBeChangedListener;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.text.CharSequenceReader;
import org.eclipse.wst.sse.core.internal.text.CoreNodeList;
import org.eclipse.wst.sse.core.internal.text.DeleteEqualPositionUpdater;
import org.eclipse.wst.sse.core.internal.text.GenericPositionManager;
import org.eclipse.wst.sse.core.internal.text.IRegionComparible;
import org.eclipse.wst.sse.core.internal.text.ReadOnlyPosition;
import org.eclipse.wst.sse.core.internal.text.StructuredDocumentReParser;
import org.eclipse.wst.sse.core.internal.text.StructuredDocumentRegionIterator;
import org.eclipse.wst.sse.core.internal.text.StructuredDocumentTextStore;
import org.eclipse.wst.sse.core.internal.text.rules.StructuredTextPartitioner;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.core.internal.undo.StructuredTextUndoManager;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.sse.core.internal.util.Utilities;

public class BasicStructuredDocument
implements IStructuredDocument,
IDocumentExtension,
IDocumentExtension3,
IDocumentExtension4,
CharSequence,
IRegionComparible,
IRepairableDocument,
IRepairableDocumentExtension {
    private static boolean USE_LOCAL_THREAD = true;
    private IStructuredDocumentRegion cachedDocumentRegion;
    private EncodingMemento encodingMemento;
    private boolean fAcceptPostNotificationReplaces = true;
    private CurrentDocumentRegionCache fCurrentDocumentRegionCache;
    private DocumentEvent fDocumentEvent;
    private IDocumentListener[] fDocumentListeners;
    private Map fDocumentPartitioners;
    private List fDocumentPartitioningListeners;
    private IStructuredDocumentRegion firstDocumentRegion;
    private RegionParser fParser;
    private GenericPositionManager fPositionManager;
    private List fPostNotificationChanges;
    private IDocumentListener[] fPrenotifiedDocumentListeners;
    private int fReentranceCount = 0;
    private IStructuredTextReParser fReParser;
    private int fStoppedCount = 0;
    private ITextStore fStore;
    private Object[] fStructuredDocumentAboutToChangeListeners;
    private Object[] fStructuredDocumentChangedListeners;
    private Object[] fStructuredDocumentChangingListeners;
    private List fDocumentRewriteSessionListeners;
    private ILineTracker fTracker;
    private IStructuredTextUndoManager fUndoManager;
    private IStructuredDocumentRegion lastDocumentRegion;
    private byte[] listenerLock = new byte[0];
    private NullDocumentEvent NULL_DOCUMENT_EVENT;
    private String fInitialLineDelimiter;
    private static final String READ_ONLY_REGIONS_CATEGORY = "_READ_ONLY_REGIONS_CATEGORY_";
    private DocumentRewriteSession fActiveRewriteSession;
    private long fModificationStamp;
    private long fNextModificationStamp = -1L;
    private long startStreamTime;
    private long startTime;

    public static void setUSE_LOCAL_THREAD(boolean use_local_thread) {
        USE_LOCAL_THREAD = use_local_thread;
    }

    public BasicStructuredDocument() {
        this.fCurrentDocumentRegionCache = new CurrentDocumentRegionCache();
        this.setTextStore(new StructuredDocumentTextStore(50, 300));
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.NULL_DOCUMENT_EVENT = new NullDocumentEvent();
        this.internal_addPositionCategory(READ_ONLY_REGIONS_CATEGORY);
        this.internal_addPositionUpdater((IPositionUpdater)new DeleteEqualPositionUpdater(READ_ONLY_REGIONS_CATEGORY));
    }

    public BasicStructuredDocument(RegionParser parser) {
        this();
        Assert.isNotNull(parser, "Program Error: IStructuredDocument can not be created with null parser");
        this.internal_setParser(parser);
    }

    private void _clearDocumentEvent() {
        this.fDocumentEvent = null;
    }

    private void _fireDocumentAboutToChange(Object[] listeners) {
        if (this.fDocumentEvent == null) {
            this.fDocumentEvent = new NullDocumentEvent();
        }
        if (listeners != null) {
            Object[] holdListeners = listeners;
            int i = 0;
            while (i < holdListeners.length) {
                try {
                    ((IDocumentListener)holdListeners[i]).documentAboutToBeChanged(this.fDocumentEvent);
                }
                catch (Exception exception) {
                    Logger.logException(exception);
                }
                ++i;
            }
        }
    }

    private void notifyDocumentPartitionersAboutToChange(DocumentEvent documentEvent) {
        if (this.fDocumentPartitioners != null) {
            for (IDocumentPartitioner p : this.fDocumentPartitioners.values()) {
                try {
                    p.documentAboutToBeChanged(documentEvent);
                }
                catch (Exception exception) {
                    Logger.logException(exception);
                }
            }
        }
    }

    private void _fireDocumentChanged(Object[] listeners, StructuredDocumentEvent event) {
        if (listeners != null) {
            Object[] holdListeners = listeners;
            int i = 0;
            while (i < holdListeners.length) {
                try {
                    if (this.fDocumentEvent == null) {
                        ((IDocumentListener)holdListeners[i]).documentChanged((DocumentEvent)this.NULL_DOCUMENT_EVENT);
                    } else {
                        ((IDocumentListener)holdListeners[i]).documentChanged(this.fDocumentEvent);
                    }
                }
                catch (Exception exception) {
                    Logger.logException(exception);
                }
                ++i;
            }
        }
    }

    private void notifyDocumentPartitionersDocumentChanged(DocumentEvent documentEvent) {
        if (this.fDocumentPartitioners != null) {
            for (IDocumentPartitioner p : this.fDocumentPartitioners.values()) {
                try {
                    if (p instanceof IDocumentPartitionerExtension) {
                        ((IDocumentPartitionerExtension)p).documentChanged2(documentEvent);
                        continue;
                    }
                    p.documentChanged(documentEvent);
                }
                catch (Exception exception) {
                    Logger.logException(exception);
                }
            }
        }
    }

    private void _fireEvent(Object[] listeners, NoChangeEvent event) {
        if (listeners != null) {
            Object[] holdListeners = listeners;
            int i = 0;
            while (i < holdListeners.length) {
                try {
                    ((IStructuredDocumentListener)holdListeners[i]).noChange(event);
                }
                catch (Exception exception) {
                    Logger.logException(exception);
                }
                ++i;
            }
        }
    }

    private void _fireEvent(Object[] listeners, RegionChangedEvent event) {
        if (listeners != null) {
            Object[] holdListeners = listeners;
            int i = 0;
            while (i < holdListeners.length) {
                try {
                    ((IStructuredDocumentListener)holdListeners[i]).regionChanged(event);
                }
                catch (Exception exception) {
                    Logger.logException(exception);
                }
                ++i;
            }
        }
    }

    private void _fireEvent(Object[] listeners, RegionsReplacedEvent event) {
        if (listeners != null) {
            Object[] holdListeners = listeners;
            int i = 0;
            while (i < holdListeners.length) {
                try {
                    ((IStructuredDocumentListener)holdListeners[i]).regionsReplaced(event);
                }
                catch (Exception exception) {
                    Logger.logException(exception);
                }
                ++i;
            }
        }
    }

    private void _fireEvent(Object[] listeners, StructuredDocumentRegionsReplacedEvent event) {
        if (listeners != null) {
            Object[] holdListeners = listeners;
            int i = 0;
            while (i < holdListeners.length) {
                try {
                    ((IStructuredDocumentListener)holdListeners[i]).nodesReplaced(event);
                }
                catch (Exception exception) {
                    Logger.logException(exception);
                }
                ++i;
            }
        }
    }

    private void _fireStructuredDocumentAboutToChange(Object[] listeners) {
        if (listeners != null) {
            Object[] holdListeners = listeners;
            int i = 0;
            while (i < holdListeners.length) {
                try {
                    if (this.fDocumentEvent == null) {
                        this.fDocumentEvent = new NullDocumentEvent();
                    }
                    AboutToBeChangedEvent aboutToBeChangedEvent = new AboutToBeChangedEvent(this, null, this.fDocumentEvent.getText(), this.fDocumentEvent.getOffset(), this.fDocumentEvent.getLength());
                    ((IModelAboutToBeChangedListener)holdListeners[i]).modelAboutToBeChanged(aboutToBeChangedEvent);
                }
                catch (Exception exception) {
                    Logger.logException(exception);
                }
                ++i;
            }
        }
    }

    protected void acquireLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocumentAboutToChangeListener(IModelAboutToBeChangedListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            if (!Utilities.contains(this.fStructuredDocumentAboutToChangeListeners, listener)) {
                int oldSize = 0;
                if (this.fStructuredDocumentAboutToChangeListeners != null) {
                    oldSize = this.fStructuredDocumentAboutToChangeListeners.length;
                }
                int newSize = oldSize + 1;
                Object[] newListeners = new Object[newSize];
                if (this.fStructuredDocumentAboutToChangeListeners != null) {
                    System.arraycopy(this.fStructuredDocumentAboutToChangeListeners, 0, newListeners, 0, oldSize);
                }
                newListeners[newSize - 1] = listener;
                this.fStructuredDocumentAboutToChangeListeners = newListeners;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocumentChangedListener(IStructuredDocumentListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            if (!Utilities.contains(this.fStructuredDocumentChangedListeners, listener)) {
                int oldSize = 0;
                if (this.fStructuredDocumentChangedListeners != null) {
                    oldSize = this.fStructuredDocumentChangedListeners.length;
                }
                int newSize = oldSize + 1;
                Object[] newListeners = new Object[newSize];
                if (this.fStructuredDocumentChangedListeners != null) {
                    System.arraycopy(this.fStructuredDocumentChangedListeners, 0, newListeners, 0, oldSize);
                }
                newListeners[newSize - 1] = listener;
                this.fStructuredDocumentChangedListeners = newListeners;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocumentChangingListener(IStructuredDocumentListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            if (!Utilities.contains(this.fStructuredDocumentChangingListeners, listener)) {
                int oldSize = 0;
                if (this.fStructuredDocumentChangingListeners != null) {
                    oldSize = this.fStructuredDocumentChangingListeners.length;
                }
                int newSize = oldSize + 1;
                Object[] newListeners = new Object[newSize];
                if (this.fStructuredDocumentChangingListeners != null) {
                    System.arraycopy(this.fStructuredDocumentChangingListeners, 0, newListeners, 0, oldSize);
                }
                newListeners[newSize - 1] = listener;
                this.fStructuredDocumentChangingListeners = newListeners;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentListener(IDocumentListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            if (!Utilities.contains(this.fDocumentListeners, listener)) {
                int oldSize = 0;
                if (this.fDocumentListeners != null) {
                    oldSize = this.fDocumentListeners.length;
                }
                int newSize = oldSize + 1;
                IDocumentListener[] newListeners = null;
                newListeners = new IDocumentListener[newSize];
                if (this.fDocumentListeners != null) {
                    System.arraycopy(this.fDocumentListeners, 0, newListeners, 0, oldSize);
                }
                newListeners[newSize - 1] = listener;
                this.fDocumentListeners = newListeners;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentPartitioningListener(IDocumentPartitioningListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            Assert.isNotNull(listener);
            if (this.fDocumentPartitioningListeners == null) {
                this.fDocumentPartitioningListeners = new ArrayList(1);
            }
            if (!this.fDocumentPartitioningListeners.contains(listener)) {
                this.fDocumentPartitioningListeners.add(listener);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addPosition(Position position) throws BadLocationException {
        this.getPositionManager().addPosition(position);
    }

    public void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
        this.getPositionManager().addPosition(category, position);
    }

    public void addPositionCategory(String category) {
        this.internal_addPositionCategory(category);
    }

    public void addPositionUpdater(IPositionUpdater updater) {
        this.internal_addPositionUpdater(updater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrenotifiedDocumentListener(IDocumentListener documentAdapter) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            if (this.fPrenotifiedDocumentListeners != null) {
                int previousSize = this.fPrenotifiedDocumentListeners.length;
                IDocumentListener[] listeners = new IDocumentListener[previousSize + 1];
                System.arraycopy(this.fPrenotifiedDocumentListeners, 0, listeners, 0, previousSize);
                listeners[previousSize] = documentAdapter;
                this.fPrenotifiedDocumentListeners = listeners;
            } else {
                this.fPrenotifiedDocumentListeners = new IDocumentListener[1];
                this.fPrenotifiedDocumentListeners[0] = documentAdapter;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public char charAt(int arg0) {
        try {
            return this.getChar(0);
        }
        catch (BadLocationException badLocationException) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void clearReadOnly() {
        Position[] positions = null;
        try {
            positions = this.getPositions(READ_ONLY_REGIONS_CATEGORY);
        }
        catch (BadPositionCategoryException e) {
            Logger.logException("program error: should never occur", e);
        }
        int i = 0;
        while (i < positions.length) {
            Position position = positions[i];
            position.delete();
            ++i;
        }
    }

    @Override
    public void clearReadOnly(int startOffset, int length) {
        try {
            Position[] positions = this.getPositions(READ_ONLY_REGIONS_CATEGORY);
            int i = 0;
            while (i < positions.length) {
                Position position = positions[i];
                if (position.overlapsWith(startOffset, length)) {
                    String effectedText = this.get(startOffset, length);
                    this.fireReadOnlyAboutToBeChanged();
                    position.delete();
                    NoChangeEvent noChangeEvent = new NoChangeEvent(this, null, effectedText, startOffset, length);
                    noChangeEvent.reason = 4;
                    this.fireReadOnlyStructuredDocumentEvent(noChangeEvent);
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public int computeIndexInCategory(String category, int offset) throws BadPositionCategoryException, BadLocationException {
        return this.getPositionManager().computeIndexInCategory(category, offset);
    }

    public int computeNumberOfLines(String text) {
        return this.getTracker().computeNumberOfLines(text);
    }

    public ITypedRegion[] computePartitioning(int offset, int length) throws BadLocationException {
        ITypedRegion[] typedRegions = null;
        try {
            typedRegions = this.computePartitioning("org.eclipse.wst.sse.core.default_structured_text_partitioning", offset, length, false);
        }
        catch (BadPartitioningException e) {
            throw new Error(e);
        }
        if (typedRegions == null) {
            typedRegions = new ITypedRegion[]{};
        }
        return typedRegions;
    }

    public ITypedRegion[] computePartitioning(String partitioning, int offset, int length, boolean includeZeroLengthPartitions) throws BadLocationException, BadPartitioningException {
        if (offset < 0 || length < 0 || offset + length > this.getLength()) {
            throw new BadLocationException();
        }
        IDocumentPartitioner partitioner = this.getDocumentPartitioner(partitioning);
        if (partitioner instanceof IDocumentPartitionerExtension2) {
            return ((IDocumentPartitionerExtension2)partitioner).computePartitioning(offset, length, includeZeroLengthPartitions);
        }
        if (partitioner != null) {
            return partitioner.computePartitioning(offset, length);
        }
        if ("org.eclipse.wst.sse.core.default_structured_text_partitioning".equals(partitioning) || "__dftl_partitioning".equals(partitioning)) {
            return new TypedRegion[]{new TypedRegion(offset, length, "__dftl_partition_content_type")};
        }
        throw new BadPartitioningException();
    }

    public boolean containsPosition(String category, int offset, int length) {
        return this.getPositionManager().containsPosition(category, offset, length);
    }

    public boolean containsPositionCategory(String category) {
        return this.getPositionManager().containsPositionCategory(category);
    }

    @Override
    public boolean containsReadOnly(int startOffset, int length) {
        boolean result = false;
        try {
            Position[] positions = this.getPositions(READ_ONLY_REGIONS_CATEGORY);
            int i = 0;
            while (i < positions.length) {
                Position position = positions[i];
                if (position.overlapsWith(startOffset, length)) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            result = false;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void executePostNotificationChanges() {
        if (this.fStoppedCount <= 0) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            changes = this.fPostNotificationChanges;
            this.fPostNotificationChanges = null;
            for (RegisteredReplace replace : changes) {
                replace.fReplace.perform((IDocument)this, replace.fOwner);
            }
lbl8:
            // 2 sources

            ** while (this.fPostNotificationChanges != null)
        }
lbl9:
        // 1 sources

    }

    private void fireDocumentAboutToChanged() {
        if (this.fDocumentEvent == null) {
            this.fDocumentEvent = new NullDocumentEvent();
        }
        this._fireStructuredDocumentAboutToChange(this.fStructuredDocumentAboutToChangeListeners);
        this._fireDocumentAboutToChange(this.fPrenotifiedDocumentListeners);
        this.notifyDocumentPartitionersAboutToChange(this.fDocumentEvent);
        this._fireDocumentAboutToChange(this.fDocumentListeners);
    }

    protected void fireDocumentPartitioningChanged(DocumentPartitioningChangedEvent event) {
        if (this.fDocumentPartitioningListeners == null || this.fDocumentPartitioningListeners.size() == 0) {
            return;
        }
        ArrayList list = new ArrayList(this.fDocumentPartitioningListeners);
        for (IDocumentPartitioningListener l : list) {
            if (l instanceof IDocumentPartitioningListenerExtension2) {
                IDocumentPartitioningListenerExtension2 extension2 = (IDocumentPartitioningListenerExtension2)l;
                extension2.documentPartitioningChanged(event);
                continue;
            }
            if (l instanceof IDocumentPartitioningListenerExtension) {
                IDocumentPartitioningListenerExtension extension = (IDocumentPartitioningListenerExtension)l;
                extension.documentPartitioningChanged((IDocument)this, event.getCoverage());
                continue;
            }
            l.documentPartitioningChanged((IDocument)this);
        }
    }

    private void fireReadOnlyAboutToBeChanged() {
        this._fireStructuredDocumentAboutToChange(this.fStructuredDocumentAboutToChangeListeners);
    }

    private void fireReadOnlyStructuredDocumentEvent(NoChangeEvent event) {
        this._fireEvent(this.fStructuredDocumentChangingListeners, event);
        this._fireEvent(this.fStructuredDocumentChangedListeners, event);
    }

    private void fireStructuredDocumentEvent(NoChangeEvent event) {
        this._fireEvent(this.fStructuredDocumentChangingListeners, event);
        this._fireEvent(this.fStructuredDocumentChangedListeners, event);
        this._fireDocumentChanged(this.fPrenotifiedDocumentListeners, event);
        this.notifyDocumentPartitionersDocumentChanged(event);
        this._fireDocumentChanged(this.fDocumentListeners, event);
        this._clearDocumentEvent();
    }

    private void fireStructuredDocumentEvent(RegionChangedEvent event) {
        this._fireEvent(this.fStructuredDocumentChangingListeners, event);
        this._fireEvent(this.fStructuredDocumentChangedListeners, event);
        this._fireDocumentChanged(this.fPrenotifiedDocumentListeners, event);
        this.notifyDocumentPartitionersDocumentChanged(event);
        this._fireDocumentChanged(this.fDocumentListeners, event);
        this._clearDocumentEvent();
    }

    private void fireStructuredDocumentEvent(RegionsReplacedEvent event) {
        this._fireEvent(this.fStructuredDocumentChangingListeners, event);
        this._fireEvent(this.fStructuredDocumentChangedListeners, event);
        this._fireDocumentChanged(this.fPrenotifiedDocumentListeners, event);
        this.notifyDocumentPartitionersDocumentChanged(event);
        this._fireDocumentChanged(this.fDocumentListeners, event);
        this._clearDocumentEvent();
    }

    private void fireStructuredDocumentEvent(StructuredDocumentRegionsReplacedEvent event) {
        this._fireEvent(this.fStructuredDocumentChangingListeners, event);
        this._fireEvent(this.fStructuredDocumentChangedListeners, event);
        this._fireDocumentChanged(this.fPrenotifiedDocumentListeners, event);
        this.notifyDocumentPartitionersDocumentChanged(event);
        this._fireDocumentChanged(this.fDocumentListeners, event);
        this._clearDocumentEvent();
    }

    public String get() {
        return this.getStore().get(0, this.getLength());
    }

    public String get(int offset, int length) {
        String result = null;
        int myLength = this.getLength();
        if (offset < 0) {
            offset = 0;
        }
        if (length < 0) {
            length = 0;
        }
        if (offset + length > myLength) {
            int lessLength = myLength - offset;
            if (lessLength >= 0 && offset + lessLength == myLength) {
                length = lessLength;
            } else {
                int moreOffset = myLength - length;
                if (moreOffset >= 0 && moreOffset + length == myLength) {
                    offset = moreOffset;
                } else {
                    result = new String();
                }
            }
        }
        if (result == null) {
            result = this.getStore().get(offset, length);
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    IStructuredDocumentRegion getCachedDocumentRegion() {
        IStructuredDocumentRegion result = null;
        result = USE_LOCAL_THREAD ? this.fCurrentDocumentRegionCache.get() : this.cachedDocumentRegion;
        return result;
    }

    public char getChar(int pos) throws BadLocationException {
        char result = '\u0000';
        try {
            result = this.getStore().get(pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new BadLocationException(e.getLocalizedMessage());
        }
        return result;
    }

    public String getContentType(int offset) throws BadLocationException {
        return this.getDocumentPartitioner().getContentType(offset);
    }

    public String getContentType(String partitioning, int offset, boolean preferOpenPartitions) throws BadLocationException, BadPartitioningException {
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException();
        }
        IDocumentPartitioner partitioner = this.getDocumentPartitioner(partitioning);
        if (partitioner instanceof IDocumentPartitionerExtension2) {
            return ((IDocumentPartitionerExtension2)partitioner).getContentType(offset, preferOpenPartitions);
        }
        if (partitioner != null) {
            return partitioner.getContentType(offset);
        }
        if ("org.eclipse.wst.sse.core.default_structured_text_partitioning".equals(partitioning)) {
            return "__dftl_partition_content_type";
        }
        throw new BadPartitioningException();
    }

    public String getDefaultLineDelimiter() {
        String lineDelimiter = null;
        try {
            lineDelimiter = this.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        if (lineDelimiter != null) {
            return lineDelimiter;
        }
        if (this.fInitialLineDelimiter != null) {
            return this.fInitialLineDelimiter;
        }
        String sysLineDelimiter = System.getProperty("line.separator");
        String[] delimiters = this.getLegalLineDelimiters();
        Assert.isTrue(delimiters.length > 0);
        int i = 0;
        while (i < delimiters.length) {
            if (delimiters[i].equals(sysLineDelimiter)) {
                lineDelimiter = sysLineDelimiter;
                break;
            }
            ++i;
        }
        if (lineDelimiter == null) {
            lineDelimiter = delimiters[0];
        }
        return lineDelimiter;
    }

    public IDocumentPartitioner getDocumentPartitioner() {
        return this.getDocumentPartitioner("__dftl_partitioning");
    }

    public IDocumentPartitioner getDocumentPartitioner(String partitioning) {
        IDocumentPartitioner documentPartitioner = null;
        if (this.fDocumentPartitioners != null) {
            documentPartitioner = (IDocumentPartitioner)this.fDocumentPartitioners.get(partitioning);
        }
        return documentPartitioner;
    }

    @Override
    public EncodingMemento getEncodingMemento() {
        return this.encodingMemento;
    }

    @Override
    public IStructuredDocumentRegion getFirstStructuredDocumentRegion() {
        this.setCachedDocumentRegion(this.firstDocumentRegion);
        return this.firstDocumentRegion;
    }

    @Override
    public IStructuredDocumentRegion getLastStructuredDocumentRegion() {
        this.setCachedDocumentRegion(this.lastDocumentRegion);
        return this.lastDocumentRegion;
    }

    public String[] getLegalContentTypes() {
        String[] result = null;
        try {
            result = this.getLegalContentTypes("org.eclipse.wst.sse.core.default_structured_text_partitioning");
        }
        catch (BadPartitioningException e) {
            throw new Error(e);
        }
        return result;
    }

    public String[] getLegalContentTypes(String partitioning) throws BadPartitioningException {
        IDocumentPartitioner partitioner = this.getDocumentPartitioner(partitioning);
        if (partitioner != null) {
            return partitioner.getLegalContentTypes();
        }
        if ("org.eclipse.wst.sse.core.default_structured_text_partitioning".equals(partitioning)) {
            return new String[]{"__dftl_partition_content_type"};
        }
        throw new BadPartitioningException();
    }

    public String[] getLegalLineDelimiters() {
        return this.getTracker().getLegalLineDelimiters();
    }

    public int getLength() {
        return this.getStore().getLength();
    }

    @Override
    public String getLineDelimiter() {
        return this.getDefaultLineDelimiter();
    }

    public String getLineDelimiter(int line) throws BadLocationException {
        return this.getTracker().getLineDelimiter(line);
    }

    public IRegion getLineInformation(int line) throws BadLocationException {
        return this.getTracker().getLineInformation(line);
    }

    public IRegion getLineInformationOfOffset(int offset) throws BadLocationException {
        return this.getTracker().getLineInformationOfOffset(offset);
    }

    public int getLineLength(int line) throws BadLocationException {
        return this.getTracker().getLineLength(line);
    }

    public int getLineOffset(int line) throws BadLocationException {
        return this.getTracker().getLineOffset(line);
    }

    @Override
    public int getLineOfOffset(int offset) {
        int result = -1;
        try {
            result = this.getTracker().getLineNumberOfOffset(offset);
        }
        catch (BadLocationException e) {
            if (Logger.DEBUG_DOCUMENT) {
                Logger.log(1, "Dev. Program Info Only: IStructuredDocument::getLineOfOffset: offset out of range, zero assumed. offset = " + offset, e);
            }
            result = 0;
        }
        return result;
    }

    public int getNumberOfLines() {
        return this.getTracker().getNumberOfLines();
    }

    public int getNumberOfLines(int offset, int length) throws BadLocationException {
        return this.getTracker().getNumberOfLines(offset, length);
    }

    @Override
    public RegionParser getParser() {
        if (this.fParser == null) {
            throw new IllegalStateException("IStructuredDocument::getParser. Parser needs to be set before use");
        }
        return this.fParser;
    }

    public ITypedRegion getPartition(int offset) throws BadLocationException {
        ITypedRegion partition = null;
        try {
            partition = this.getPartition("org.eclipse.wst.sse.core.default_structured_text_partitioning", offset, false);
        }
        catch (BadPartitioningException e) {
            throw new Error(e);
        }
        if (partition == null) {
            throw new Error();
        }
        return partition;
    }

    public ITypedRegion getPartition(String partitioning, int offset, boolean preferOpenPartitions) throws BadLocationException, BadPartitioningException {
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException();
        }
        ITypedRegion result = null;
        IDocumentPartitioner partitioner = this.getDocumentPartitioner(partitioning);
        if (partitioner instanceof IDocumentPartitionerExtension2) {
            result = ((IDocumentPartitionerExtension2)partitioner).getPartition(offset, preferOpenPartitions);
        } else if (partitioner != null) {
            result = partitioner.getPartition(offset);
        } else if ("org.eclipse.wst.sse.core.default_structured_text_partitioning".equals(partitioning)) {
            result = new TypedRegion(0, this.getLength(), "__dftl_partition_content_type");
        } else {
            throw new BadPartitioningException();
        }
        return result;
    }

    public String[] getPartitionings() {
        if (this.fDocumentPartitioners == null) {
            return new String[0];
        }
        String[] partitionings = new String[this.fDocumentPartitioners.size()];
        this.fDocumentPartitioners.keySet().toArray(partitionings);
        return partitionings;
    }

    public String[] getPositionCategories() {
        return this.getPositionManager().getPositionCategories();
    }

    private GenericPositionManager getPositionManager() {
        if (this.fPositionManager == null) {
            this.fPositionManager = new GenericPositionManager(this);
        }
        return this.fPositionManager;
    }

    public Position[] getPositions(String category) throws BadPositionCategoryException {
        return this.getPositionManager().getPositions(category);
    }

    public IPositionUpdater[] getPositionUpdaters() {
        return this.getPositionManager().getPositionUpdaters();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IStructuredDocumentRegion getRegionAtCharacterOffset(int offset) {
        block7: {
            block6: {
                block8: {
                    result = null;
                    potentialCachedRegion = this.getCachedDocumentRegion();
                    if (potentialCachedRegion == null) break block7;
                    if (!potentialCachedRegion.containsOffset(offset)) break block8;
                    result = potentialCachedRegion;
                    break block6;
                }
                direction = offset - potentialCachedRegion.getStart();
                if (direction >= 0) ** GOTO lbl19
                while (!potentialCachedRegion.containsOffset(offset)) {
                    tempNode = potentialCachedRegion.getPrevious();
                    if (tempNode != null) {
                        potentialCachedRegion = tempNode;
                        continue;
                    }
                    break block6;
                }
                break block6;
                while ((tempNode = potentialCachedRegion.getNext()) != null) {
                    potentialCachedRegion = tempNode;
lbl19:
                    // 2 sources

                    if (!potentialCachedRegion.containsOffset(offset)) continue;
                }
            }
            result = potentialCachedRegion;
        }
        if (result != null) {
            this.setCachedDocumentRegion(result);
        } else if (this.getCachedDocumentRegion() != null) {
            throw new IllegalStateException("Program Error: no region could be found to cache, but cache was non null. Indicates corrupted model or region list");
        }
        return result;
    }

    @Override
    public IStructuredDocumentRegionList getRegionList() {
        CoreNodeList result = null;
        result = this.getCachedDocumentRegion() == null ? new CoreNodeList(null) : new CoreNodeList(this.getFirstStructuredDocumentRegion());
        return result;
    }

    @Override
    public IStructuredDocumentRegion[] getStructuredDocumentRegions() {
        return this.getStructuredDocumentRegions(0, this.getLength());
    }

    @Override
    public IStructuredDocumentRegion[] getStructuredDocumentRegions(int start, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("can't have negative length");
        }
        if (length > 0) {
            --length;
        }
        ArrayList<IStructuredDocumentRegion> results = new ArrayList<IStructuredDocumentRegion>();
        try {
            this.acquireLock();
            IStructuredDocumentRegion currentRegion = this.getRegionAtCharacterOffset(start);
            IStructuredDocumentRegion endRegion = this.getRegionAtCharacterOffset(start + length);
            while (currentRegion != endRegion && currentRegion != null) {
                results.add(currentRegion);
                currentRegion = currentRegion.getNext();
            }
            if (endRegion != null) {
                results.add(endRegion);
            }
        }
        finally {
            this.releaseLock();
        }
        return results.toArray(new IStructuredDocumentRegion[results.size()]);
    }

    @Override
    public IStructuredTextReParser getReParser() {
        if (this.fReParser == null) {
            this.fReParser = new StructuredDocumentReParser();
            this.fReParser.setStructuredDocument(this);
        }
        return this.fReParser;
    }

    private ITextStore getStore() {
        return this.fStore;
    }

    @Override
    public String getText() {
        String result = this.get();
        return result;
    }

    private ILineTracker getTracker() {
        return this.fTracker;
    }

    @Override
    public IStructuredTextUndoManager getUndoManager() {
        if (this.fUndoManager == null) {
            this.fUndoManager = new StructuredTextUndoManager();
        }
        return this.fUndoManager;
    }

    /*
     * Unable to fully structure code
     */
    void initializeFirstAndLastDocumentRegion() {
        block1: {
            this.firstDocumentRegion = this.getCachedDocumentRegion();
            aNode = this.firstDocumentRegion;
            if (aNode != null) ** GOTO lbl8
            this.lastDocumentRegion = null;
            break block1;
lbl-1000:
            // 1 sources

            {
                this.lastDocumentRegion = aNode;
                aNode = aNode.getNext();
lbl8:
                // 2 sources

                ** while (aNode != null)
            }
        }
    }

    public void insertPositionUpdater(IPositionUpdater updater, int index) {
        this.getPositionManager().insertPositionUpdater(updater, index);
    }

    private void internal_addPositionCategory(String category) {
        this.getPositionManager().addPositionCategory(category);
    }

    private void internal_addPositionUpdater(IPositionUpdater updater) {
        this.getPositionManager().addPositionUpdater(updater);
    }

    private void internal_setParser(RegionParser newParser) {
        this.fParser = newParser;
    }

    String internalGet(int offset, int length) {
        String result = null;
        result = this.getStore().get(offset, length);
        return result;
    }

    private StructuredDocumentEvent internalReplaceText(Object requester, int start, int replacementLength, String changes, long modificationStamp, boolean ignoreReadOnlySettings) {
        StructuredDocumentEvent result = null;
        this.stopPostNotificationProcessing();
        if (changes == null) {
            changes = "";
        }
        try {
            this.fDocumentEvent = new DocumentEvent((IDocument)this, start, replacementLength, changes);
            this.fireDocumentAboutToChanged();
            try {
                this.acquireLock();
                if (!ignoreReadOnlySettings && this.containsReadOnly(start, replacementLength)) {
                    NoChangeEvent noChangeEvent = new NoChangeEvent(this, requester, changes, start, replacementLength);
                    noChangeEvent.reason = 4;
                    result = noChangeEvent;
                } else {
                    result = this.updateModel(requester, start, replacementLength, changes);
                }
            }
            finally {
                this.releaseLock();
            }
        }
        catch (Throwable throwable) {
            if (result != null && !(result instanceof NoChangeEvent)) {
                this.fModificationStamp = modificationStamp;
                this.fNextModificationStamp = Math.max(this.fModificationStamp, this.fNextModificationStamp);
                this.fDocumentEvent.fModificationStamp = this.fModificationStamp;
            }
            if (result == null) {
                NoChangeEvent noChangeEvent = new NoChangeEvent(this, requester, changes, start, replacementLength);
                noChangeEvent.reason = 8;
                this.fireStructuredDocumentEvent(noChangeEvent);
                Logger.log(4, "Program Error: invalid structured document event");
            } else if (result instanceof RegionChangedEvent) {
                this.fireStructuredDocumentEvent((RegionChangedEvent)result);
            } else if (result instanceof RegionsReplacedEvent) {
                this.fireStructuredDocumentEvent((RegionsReplacedEvent)result);
            } else if (result instanceof StructuredDocumentRegionsReplacedEvent) {
                this.updateDeletedFields((StructuredDocumentRegionsReplacedEvent)result);
                this.fireStructuredDocumentEvent((StructuredDocumentRegionsReplacedEvent)result);
            } else if (result instanceof NoChangeEvent) {
                this.fireStructuredDocumentEvent((NoChangeEvent)result);
            } else {
                NoChangeEvent noChangeEvent = new NoChangeEvent(this, requester, changes, start, replacementLength);
                noChangeEvent.reason = 8;
                this.fireStructuredDocumentEvent(noChangeEvent);
                Logger.log(1, "Program Error: unexpected structured document event: " + (Object)((Object)result));
            }
            this.resumePostNotificationProcessing();
            throw throwable;
        }
        if (result != null && !(result instanceof NoChangeEvent)) {
            this.fModificationStamp = modificationStamp;
            this.fNextModificationStamp = Math.max(this.fModificationStamp, this.fNextModificationStamp);
            this.fDocumentEvent.fModificationStamp = this.fModificationStamp;
        }
        if (result == null) {
            NoChangeEvent noChangeEvent = new NoChangeEvent(this, requester, changes, start, replacementLength);
            noChangeEvent.reason = 8;
            this.fireStructuredDocumentEvent(noChangeEvent);
            Logger.log(4, "Program Error: invalid structured document event");
        } else if (result instanceof RegionChangedEvent) {
            this.fireStructuredDocumentEvent((RegionChangedEvent)result);
        } else if (result instanceof RegionsReplacedEvent) {
            this.fireStructuredDocumentEvent((RegionsReplacedEvent)result);
        } else if (result instanceof StructuredDocumentRegionsReplacedEvent) {
            this.updateDeletedFields((StructuredDocumentRegionsReplacedEvent)result);
            this.fireStructuredDocumentEvent((StructuredDocumentRegionsReplacedEvent)result);
        } else if (result instanceof NoChangeEvent) {
            this.fireStructuredDocumentEvent((NoChangeEvent)result);
        } else {
            NoChangeEvent noChangeEvent = new NoChangeEvent(this, requester, changes, start, replacementLength);
            noChangeEvent.reason = 8;
            this.fireStructuredDocumentEvent(noChangeEvent);
            Logger.log(1, "Program Error: unexpected structured document event: " + (Object)((Object)result));
        }
        this.resumePostNotificationProcessing();
        return result;
    }

    @Override
    public int length() {
        return this.getLength();
    }

    @Override
    public void makeReadOnly(int startOffset, int length) {
        this.makeReadOnly(startOffset, length, false, false);
    }

    public void makeReadOnly(int startOffset, int length, boolean canInsertBefore, boolean canInsertAfter) {
        if (length <= 0) {
            return;
        }
        String affectedText = this.get(startOffset, length);
        this.fireReadOnlyAboutToBeChanged();
        this.addPositionCategory(READ_ONLY_REGIONS_CATEGORY);
        ReadOnlyPosition newPosition = new ReadOnlyPosition(startOffset, length, canInsertBefore);
        try {
            this.addPosition(READ_ONLY_REGIONS_CATEGORY, newPosition);
            NoChangeEvent noChangeEvent = new NoChangeEvent(this, null, affectedText, startOffset, length);
            noChangeEvent.reason = 4;
            this.fireReadOnlyStructuredDocumentEvent(noChangeEvent);
        }
        catch (BadLocationException e) {
            Logger.logException("could not create readonly region at " + startOffset + " to " + length, e);
        }
        catch (BadPositionCategoryException e) {
            Logger.logException(e);
        }
    }

    @Override
    public IStructuredDocument newInstance() {
        IStructuredDocument newInstance = StructuredDocumentFactory.getNewStructuredDocumentInstance(this.getParser().newInstance());
        ((BasicStructuredDocument)newInstance).setReParser(this.getReParser().newInstance());
        if (this.getDocumentPartitioner() instanceof StructuredTextPartitioner) {
            newInstance.setDocumentPartitioner(((StructuredTextPartitioner)this.getDocumentPartitioner()).newInstance());
            newInstance.getDocumentPartitioner().connect((IDocument)newInstance);
        }
        newInstance.setLineDelimiter(this.getLineDelimiter());
        if (this.getEncodingMemento() != null) {
            newInstance.setEncodingMemento((EncodingMemento)this.getEncodingMemento().clone());
        }
        return newInstance;
    }

    @Override
    public boolean regionMatches(int offset, int length, String stringToCompare) {
        boolean result = false;
        ITextStore store = this.getStore();
        result = store instanceof IRegionComparible ? ((IRegionComparible)store).regionMatches(offset, length, stringToCompare) : this.get(offset, length).equals(stringToCompare);
        return result;
    }

    @Override
    public boolean regionMatchesIgnoreCase(int offset, int length, String stringToCompare) {
        boolean result = false;
        ITextStore store = this.getStore();
        result = store instanceof IRegionComparible ? ((IRegionComparible)store).regionMatchesIgnoreCase(offset, length, stringToCompare) : this.get(offset, length).equalsIgnoreCase(stringToCompare);
        return result;
    }

    public void registerPostNotificationReplace(IDocumentListener owner, IDocumentExtension.IReplace replace) {
        if (this.fAcceptPostNotificationReplaces) {
            if (this.fPostNotificationChanges == null) {
                this.fPostNotificationChanges = new ArrayList(1);
            }
            this.fPostNotificationChanges.add(new RegisteredReplace(owner, replace));
        }
    }

    protected void releaseLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocumentAboutToChangeListener(IModelAboutToBeChangedListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            if (this.fStructuredDocumentAboutToChangeListeners != null && listener != null && Utilities.contains(this.fStructuredDocumentAboutToChangeListeners, listener)) {
                int oldSize = this.fStructuredDocumentAboutToChangeListeners.length;
                int newSize = oldSize - 1;
                Object[] newListeners = new Object[newSize];
                int index = 0;
                int i = 0;
                while (i < oldSize) {
                    if (this.fStructuredDocumentAboutToChangeListeners[i] != listener) {
                        newListeners[index++] = this.fStructuredDocumentAboutToChangeListeners[i];
                    }
                    ++i;
                }
                this.fStructuredDocumentAboutToChangeListeners = newListeners;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocumentChangedListener(IStructuredDocumentListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            if (this.fStructuredDocumentChangedListeners != null && listener != null && Utilities.contains(this.fStructuredDocumentChangedListeners, listener)) {
                int oldSize = this.fStructuredDocumentChangedListeners.length;
                int newSize = oldSize - 1;
                Object[] newListeners = new Object[newSize];
                int index = 0;
                int i = 0;
                while (i < oldSize) {
                    if (this.fStructuredDocumentChangedListeners[i] != listener) {
                        newListeners[index++] = this.fStructuredDocumentChangedListeners[i];
                    }
                    ++i;
                }
                this.fStructuredDocumentChangedListeners = newListeners;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocumentChangingListener(IStructuredDocumentListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            if (this.fStructuredDocumentChangingListeners != null && listener != null && Utilities.contains(this.fStructuredDocumentChangingListeners, listener)) {
                int oldSize = this.fStructuredDocumentChangingListeners.length;
                int newSize = oldSize - 1;
                Object[] newListeners = new Object[newSize];
                int index = 0;
                int i = 0;
                while (i < oldSize) {
                    if (this.fStructuredDocumentChangingListeners[i] != listener) {
                        newListeners[index++] = this.fStructuredDocumentChangingListeners[i];
                    }
                    ++i;
                }
                this.fStructuredDocumentChangingListeners = newListeners;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentListener(IDocumentListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            if (this.fDocumentListeners != null && listener != null && Utilities.contains(this.fDocumentListeners, listener)) {
                int oldSize = this.fDocumentListeners.length;
                int newSize = oldSize - 1;
                IDocumentListener[] newListeners = new IDocumentListener[newSize];
                int index = 0;
                int i = 0;
                while (i < oldSize) {
                    if (this.fDocumentListeners[i] != listener) {
                        newListeners[index++] = this.fDocumentListeners[i];
                    }
                    ++i;
                }
                this.fDocumentListeners = newListeners;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentPartitioningListener(IDocumentPartitioningListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            Assert.isNotNull(listener);
            if (this.fDocumentPartitioningListeners != null) {
                this.fDocumentPartitioningListeners.remove(listener);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void removePosition(Position position) {
        this.getPositionManager().removePosition(position);
    }

    public void removePosition(String category, Position position) throws BadPositionCategoryException {
        this.getPositionManager().removePosition(category, position);
    }

    public void removePositionCategory(String category) throws BadPositionCategoryException {
        this.getPositionManager().removePositionCategory(category);
    }

    public void removePositionUpdater(IPositionUpdater updater) {
        this.getPositionManager().removePositionUpdater(updater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrenotifiedDocumentListener(IDocumentListener documentAdapter) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            if (Utilities.contains(this.fPrenotifiedDocumentListeners, documentAdapter)) {
                int previousSize = this.fPrenotifiedDocumentListeners.length;
                if (previousSize > 1) {
                    IDocumentListener[] listeners = new IDocumentListener[previousSize - 1];
                    int previousIndex = 0;
                    int newIndex = 0;
                    while (previousIndex < previousSize) {
                        if (this.fPrenotifiedDocumentListeners[previousIndex] != documentAdapter) {
                            listeners[newIndex++] = this.fPrenotifiedDocumentListeners[previousIndex];
                        }
                        ++previousIndex;
                    }
                    this.fPrenotifiedDocumentListeners = listeners;
                } else {
                    this.fPrenotifiedDocumentListeners = null;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void reparse(Object requester) {
        if (this.fStoppedCount > 0) {
            return;
        }
        this.stopPostNotificationProcessing();
        this.clearReadOnly();
        try {
            this.acquireLock();
            CharSequenceReader subSetTextStoreReader = new CharSequenceReader((CharSequence)this.getStore(), 0, this.getStore().getLength());
            this.resetParser(subSetTextStoreReader, 0);
            this.setCachedDocumentRegion(this.getParser().getDocumentRegions());
            this.initializeFirstAndLastDocumentRegion();
            StructuredDocumentRegionIterator.setParentDocument(this.getCachedDocumentRegion(), (IStructuredDocument)this);
        }
        finally {
            this.releaseLock();
        }
        this.resumePostNotificationProcessing();
    }

    public void replace(int offset, int length, String text) throws BadLocationException {
        this.replaceText(this, offset, length, text);
    }

    @Override
    public StructuredDocumentEvent replaceText(Object requester, int pos, int length, String text) {
        if (length == 0 && (text == null || text.length() == 0)) {
            return this.replaceText(requester, pos, length, text, this.getModificationStamp(), true);
        }
        return this.replaceText(requester, pos, length, text, this.getNextModificationStamp(), true);
    }

    @Override
    public StructuredDocumentEvent replaceText(Object requester, int start, int replacementLength, String changes, boolean ignoreReadOnlySettings) {
        long modificationStamp = replacementLength == 0 && (changes == null || changes.length() == 0) ? this.getModificationStamp() : this.getNextModificationStamp();
        return this.replaceText(requester, start, replacementLength, changes, modificationStamp, ignoreReadOnlySettings);
    }

    private StructuredDocumentEvent replaceText(Object requester, int start, int replacementLength, String changes, long modificationStamp, boolean ignoreReadOnlySettings) {
        StructuredDocumentEvent event = this.internalReplaceText(requester, start, replacementLength, changes, modificationStamp, ignoreReadOnlySettings);
        return event;
    }

    void resetParser(int startOffset, int endOffset) {
        RegionParser parser = this.getParser();
        ITextStore textStore = this.getStore();
        if (textStore instanceof CharSequence) {
            CharSequenceReader subSetTextStoreReader = new CharSequenceReader((CharSequence)textStore, startOffset, endOffset - startOffset);
            parser.reset(subSetTextStoreReader, startOffset);
        } else {
            String newNodeText = this.get(startOffset, endOffset - startOffset);
            parser.reset(newNodeText, startOffset);
        }
    }

    void resetParser(Reader reader, int startOffset) {
        RegionParser parser = this.getParser();
        parser.reset(reader, startOffset);
    }

    public void resumePostNotificationProcessing() {
        --this.fStoppedCount;
        if (this.fStoppedCount == 0 && this.fReentranceCount == 0) {
            this.executePostNotificationChanges();
        }
    }

    public int search(int startPosition, String findString, boolean forwardSearch, boolean caseSensitive, boolean wholeWord) throws BadLocationException {
        Logger.log(1, "WARNING: using unsupported deprecated method 'search'");
        int offset = -1;
        IRegion match = new FindReplaceDocumentAdapter((IDocument)this).find(startPosition, findString, forwardSearch, caseSensitive, wholeWord, false);
        if (match != null) {
            offset = match.getOffset();
        }
        return offset;
    }

    public void set(String string) {
        this.setText(null, string);
    }

    public void setCachedDocumentRegion(IStructuredDocumentRegion structuredRegion) {
        if (USE_LOCAL_THREAD) {
            this.fCurrentDocumentRegionCache.set(structuredRegion);
        } else {
            this.cachedDocumentRegion = structuredRegion;
        }
    }

    public void setDocumentPartitioner(IDocumentPartitioner partitioner) {
        this.setDocumentPartitioner("__dftl_partitioning", partitioner);
    }

    public void setDocumentPartitioner(String partitioning, IDocumentPartitioner partitioner) {
        if (partitioner == null) {
            if (this.fDocumentPartitioners != null) {
                this.fDocumentPartitioners.remove(partitioning);
                if (this.fDocumentPartitioners.size() == 0) {
                    this.fDocumentPartitioners = null;
                }
            }
        } else {
            if (this.fDocumentPartitioners == null) {
                this.fDocumentPartitioners = new HashMap();
            }
            this.fDocumentPartitioners.put(partitioning, partitioner);
        }
        DocumentPartitioningChangedEvent event = new DocumentPartitioningChangedEvent((IDocument)this);
        event.setPartitionChange(partitioning, 0, this.getLength());
        this.fireDocumentPartitioningChanged(event);
    }

    @Override
    public void setEncodingMemento(EncodingMemento encodingMemento) {
        this.encodingMemento = encodingMemento;
    }

    void setFirstDocumentRegion(IStructuredDocumentRegion region) {
        this.firstDocumentRegion = region;
    }

    public void setInitialLineDelimiter(String lineDelimiter) {
        if (Utilities.containsString(this.getLegalLineDelimiters(), lineDelimiter)) {
            this.fInitialLineDelimiter = lineDelimiter;
        } else {
            if (Logger.DEBUG_DOCUMENT) {
                Logger.log(1, "Attempt to set linedelimiter to non-legal delimiter");
            }
            this.fInitialLineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", System.getProperty("line.separator"), new IScopeContext[]{new InstanceScope()});
        }
    }

    void setLastDocumentRegion(IStructuredDocumentRegion region) {
        this.lastDocumentRegion = region;
    }

    @Override
    public void setLineDelimiter(String delimiter) {
        this.setInitialLineDelimiter(delimiter);
    }

    private void setLineTracker(ILineTracker tracker) {
        Assert.isNotNull(tracker);
        this.fTracker = tracker;
    }

    public void setParser(RegionParser newParser) {
        this.internal_setParser(newParser);
    }

    void setPositionManager(GenericPositionManager positionManager) {
        this.fPositionManager = positionManager;
    }

    public void setReParser(IStructuredTextReParser newReParser) {
        this.fReParser = newReParser;
        if (this.fReParser != null) {
            this.fReParser.setStructuredDocument(this);
        }
    }

    @Override
    public StructuredDocumentEvent setText(Object requester, String theString) {
        StructuredDocumentEvent result = null;
        result = this.replaceText(requester, 0, this.getLength(), theString, this.getNextModificationStamp(), true);
        return result;
    }

    private void setTextStore(ITextStore store) {
        Assert.isNotNull(store);
        this.fStore = store;
    }

    @Override
    public void setUndoManager(IStructuredTextUndoManager undoManager) {
        if (this.fUndoManager != null && this.fUndoManager != undoManager) {
            throw new IllegalArgumentException("can not change undo manager once its been set");
        }
        this.fUndoManager = undoManager;
    }

    public void startSequentialRewrite(boolean normalized) {
    }

    public void stopPostNotificationProcessing() {
        ++this.fStoppedCount;
    }

    public void stopSequentialRewrite() {
    }

    @Override
    public CharSequence subSequence(int arg0, int arg1) {
        return this.get(arg0, arg1);
    }

    private void updateDeletedFields(StructuredDocumentRegionsReplacedEvent event) {
        IStructuredDocumentRegionList oldRegions = event.getOldStructuredDocumentRegions();
        int i = 0;
        while (i < oldRegions.getLength()) {
            IStructuredDocumentRegion structuredDocumentRegion = oldRegions.item(i);
            structuredDocumentRegion.setDeleted(true);
            ++i;
        }
    }

    public void updateDocumentData(int start, int lengthToReplace, String changes) {
        this.stopPostNotificationProcessing();
        this.getStore().replace(start, lengthToReplace, changes);
        try {
            this.getTracker().replace(start, lengthToReplace, changes);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        if (this.fPositionManager != null) {
            this.fPositionManager.updatePositions(new DocumentEvent((IDocument)this, start, lengthToReplace, changes));
        }
        ++this.fModificationStamp;
        this.fNextModificationStamp = Math.max(this.fModificationStamp, this.fNextModificationStamp);
        this.resumePostNotificationProcessing();
    }

    private StructuredDocumentEvent updateModel(Object requester, int start, int lengthToReplace, String changes) {
        StructuredDocumentEvent result = null;
        IStructuredTextReParser reParser = this.getReParser();
        reParser.initialize(requester, start, lengthToReplace, changes);
        result = reParser.reparse();
        Assert.isNotNull((Object)result, "no structuredDocument event was created in IStructuredDocument::updateStructuredDocument");
        return result;
    }

    @Override
    public String getPreferredLineDelimiter() {
        return this.getDefaultLineDelimiter();
    }

    @Override
    public void setPreferredLineDelimiter(String probableLineDelimiter) {
        this.setInitialLineDelimiter(probableLineDelimiter);
    }

    public DocumentRewriteSession startRewriteSession(DocumentRewriteSessionType sessionType) throws IllegalStateException {
        return this.internalStartRewriteSession(sessionType);
    }

    protected final DocumentRewriteSession internalStartRewriteSession(DocumentRewriteSessionType sessionType) throws IllegalStateException {
        if (this.getActiveRewriteSession() != null) {
            throw new IllegalStateException("already in a rewrite session");
        }
        StructuredDocumentRewriteSession session = new StructuredDocumentRewriteSession(sessionType);
        DocumentRewriteSessionEvent event = new DocumentRewriteSessionEvent((IDocument)this, (DocumentRewriteSession)session, DocumentRewriteSessionEvent.SESSION_START);
        this.fireDocumentRewriteSessionEvent(event);
        ILineTracker tracker = this.getTracker();
        if (tracker instanceof ILineTrackerExtension) {
            ILineTrackerExtension extension = (ILineTrackerExtension)tracker;
            extension.startRewriteSession((DocumentRewriteSession)session);
        }
        this.startRewriteSessionOnPartitioners(session);
        if (DocumentRewriteSessionType.SEQUENTIAL == sessionType) {
            this.startSequentialRewrite(false);
        } else if (DocumentRewriteSessionType.STRICTLY_SEQUENTIAL == sessionType) {
            this.startSequentialRewrite(true);
        }
        this.fActiveRewriteSession = session;
        return session;
    }

    final void startRewriteSessionOnPartitioners(DocumentRewriteSession session) {
        if (this.fDocumentPartitioners != null) {
            for (Object partitioner : this.fDocumentPartitioners.values()) {
                if (!(partitioner instanceof IDocumentPartitionerExtension3)) continue;
                IDocumentPartitionerExtension3 extension = (IDocumentPartitionerExtension3)partitioner;
                extension.startRewriteSession(session);
            }
        }
    }

    public void stopRewriteSession(DocumentRewriteSession session) {
        this.internalStopRewriteSession(session);
    }

    protected final void internalStopRewriteSession(DocumentRewriteSession session) {
        if (this.fActiveRewriteSession == session) {
            DocumentRewriteSessionType sessionType = session.getSessionType();
            if (DocumentRewriteSessionType.SEQUENTIAL == sessionType || DocumentRewriteSessionType.STRICTLY_SEQUENTIAL == sessionType) {
                this.stopSequentialRewrite();
            }
            this.stopRewriteSessionOnPartitioners(session);
            ILineTracker tracker = this.getTracker();
            if (tracker instanceof ILineTrackerExtension) {
                ILineTrackerExtension extension = (ILineTrackerExtension)tracker;
                extension.stopRewriteSession(session, this.get());
            }
            this.fActiveRewriteSession = null;
            DocumentRewriteSessionEvent event = new DocumentRewriteSessionEvent((IDocument)this, session, DocumentRewriteSessionEvent.SESSION_STOP);
            this.fireDocumentRewriteSessionEvent(event);
        }
    }

    final void stopRewriteSessionOnPartitioners(DocumentRewriteSession session) {
        if (this.fDocumentPartitioners != null) {
            DocumentPartitioningChangedEvent event = new DocumentPartitioningChangedEvent((IDocument)this);
            for (String partitioning : this.fDocumentPartitioners.keySet()) {
                IDocumentPartitioner partitioner = (IDocumentPartitioner)this.fDocumentPartitioners.get(partitioning);
                if (!(partitioner instanceof IDocumentPartitionerExtension3)) continue;
                IDocumentPartitionerExtension3 extension = (IDocumentPartitionerExtension3)partitioner;
                extension.stopRewriteSession(session);
                event.setPartitionChange(partitioning, 0, this.getLength());
            }
            if (!event.isEmpty()) {
                this.fireDocumentPartitioningChanged(event);
            }
        }
    }

    public DocumentRewriteSession getActiveRewriteSession() {
        return this.fActiveRewriteSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentRewriteSessionListener(IDocumentRewriteSessionListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            Assert.isNotNull(listener);
            if (this.fDocumentRewriteSessionListeners == null) {
                this.fDocumentRewriteSessionListeners = new ArrayList(1);
            }
            if (!this.fDocumentRewriteSessionListeners.contains(listener)) {
                this.fDocumentRewriteSessionListeners.add(listener);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentRewriteSessionListener(IDocumentRewriteSessionListener listener) {
        byte[] byArray = this.listenerLock;
        synchronized (this.listenerLock) {
            Assert.isNotNull(listener);
            if (this.fDocumentRewriteSessionListeners != null) {
                this.fDocumentRewriteSessionListeners.remove(listener);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void replace(int offset, int length, String text, long modificationStamp) throws BadLocationException {
        this.replaceText(this, offset, length, text, modificationStamp, true);
    }

    public void set(String text, long modificationStamp) {
        this.replaceText(null, 0, this.getLength(), text, modificationStamp, true);
    }

    public long getModificationStamp() {
        return this.fModificationStamp;
    }

    private long getNextModificationStamp() {
        this.fNextModificationStamp = this.fNextModificationStamp == Long.MAX_VALUE || this.fNextModificationStamp == -1L ? 0L : ++this.fNextModificationStamp;
        return this.fNextModificationStamp;
    }

    private void fireDocumentRewriteSessionEvent(final DocumentRewriteSessionEvent event) {
        if (this.fDocumentRewriteSessionListeners == null || this.fDocumentRewriteSessionListeners.size() == 0) {
            return;
        }
        Object[] listeners = this.fDocumentRewriteSessionListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            final IDocumentRewriteSessionListener l = (IDocumentRewriteSessionListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    l.documentRewriteSessionChanged(event);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++i;
        }
    }

    public boolean isLineInformationRepairNeeded(int offset, int length, String text) throws BadLocationException {
        if (offset < 0 || length < 0 || offset + length > this.getLength()) {
            throw new BadLocationException();
        }
        return this.isLineInformationRepairNeeded(text) || this.isLineInformationRepairNeeded(this.get(offset, length));
    }

    private boolean isLineInformationRepairNeeded(String text) {
        if (text == null) {
            return false;
        }
        int length = text.length();
        if (length == 0) {
            return false;
        }
        int rIndex = text.indexOf(13);
        int nIndex = text.indexOf(10);
        if (rIndex == -1 && nIndex == -1) {
            return false;
        }
        if (rIndex > 0 && rIndex < length - 1 && nIndex > 1 && rIndex < length - 2) {
            return false;
        }
        String defaultLD = null;
        try {
            defaultLD = this.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
        if (defaultLD == null) {
            return false;
        }
        defaultLD = this.getDefaultLineDelimiter();
        if (defaultLD.length() == 1) {
            if (rIndex != -1 && !"\r".equals(defaultLD)) {
                return true;
            }
            if (nIndex != -1 && !"\n".equals(defaultLD)) {
                return true;
            }
        } else if (defaultLD.length() == 2) {
            return rIndex == -1 || nIndex - rIndex != 1;
        }
        return false;
    }

    public void repairLineInformation() {
        this.getTracker().set(this.get());
    }

    private class CurrentDocumentRegionCache {
        private List cachedRegionPositionArray = Collections.synchronizedList(new ArrayList());
        private final boolean DEBUG = false;
        private static final int MAX_SIZE = 50;
        private ThreadLocal threadLocalCachePosition = new ThreadLocal();

        private CurrentDocumentRegionCache() {
        }

        IStructuredDocumentRegion get() {
            IStructuredDocumentRegion region = null;
            int pos = this.getThreadLocalPosition();
            try {
                region = (IStructuredDocumentRegion)this.cachedRegionPositionArray.get(pos);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reinitThreadLocalPosition();
                this.resetToInitialState();
            }
            if (region == null) {
                region = this.resetToInitialState();
            } else if (region.isDeleted()) {
                region = this.resetToInitialState();
            }
            return region;
        }

        private int getThreadLocalPosition() {
            Object threadLocalObject = this.threadLocalCachePosition.get();
            int pos = -1;
            pos = threadLocalObject == null ? this.reinitThreadLocalPosition() : ((Integer)threadLocalObject).intValue();
            return pos;
        }

        private int reinitThreadLocalPosition() {
            if (this.cachedRegionPositionArray.size() > 50) {
                this.cachedRegionPositionArray.clear();
            }
            Integer position = new Integer(this.cachedRegionPositionArray.size());
            this.threadLocalCachePosition.set(position);
            this.cachedRegionPositionArray.add(position, null);
            int pos = position;
            return pos;
        }

        private IStructuredDocumentRegion resetToInitialState() {
            IStructuredDocumentRegion region = BasicStructuredDocument.this.getFirstStructuredDocumentRegion();
            this.set(region);
            return region;
        }

        void set(IStructuredDocumentRegion region) {
            try {
                int pos = this.getThreadLocalPosition();
                this.cachedRegionPositionArray.set(pos, region);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reinitThreadLocalPosition();
                this.resetToInitialState();
            }
        }
    }

    public class NullDocumentEvent
    extends DocumentEvent {
        public NullDocumentEvent() {
            this(basicStructuredDocument, 0, 0, "");
        }

        private NullDocumentEvent(IDocument doc, int offset, int length, String text) {
            super(doc, offset, length, text);
        }
    }

    static class RegisteredReplace {
        IDocumentListener fOwner;
        IDocumentExtension.IReplace fReplace;

        RegisteredReplace(IDocumentListener owner, IDocumentExtension.IReplace replace) {
            this.fOwner = owner;
            this.fReplace = replace;
        }
    }

    static class StructuredDocumentRewriteSession
    extends DocumentRewriteSession {
        protected StructuredDocumentRewriteSession(DocumentRewriteSessionType sessionType) {
            super(sessionType);
        }
    }
}

