/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.executor.properties;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeUtil;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.gui.utils.common.widgets.LineNumberStyledText;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.executor.properties.AbstractEditScriptRunnable;
import de.rcenvironment.core.gui.workflow.executor.properties.Messages;
import de.rcenvironment.core.gui.workflow.executor.properties.WhitespaceShowListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractScriptSection
extends ValidatingWorkflowNodePropertySection {
    public static final String CHECKBOX_KEY = "checkShowWhitespace";
    private static final String KEY_SCRIPT_WHITESPACE_BOX = "ScriptWhitespaceBox";
    protected Button openInEditorButton;
    protected Button checkBoxWhitespace;
    protected WhitespaceShowListener whitespaceListener;
    protected EditScriptRunnable esr = null;
    protected LineNumberStyledText scriptingText;
    private final String scriptName;

    public AbstractScriptSection(String scriptName) {
        this.scriptName = scriptName;
    }

    protected void createCompositeContentAtVeryTop(Composite composite, TabbedPropertySheetWidgetFactory factory) {
    }

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, true));
        Section scriptSection = this.getWidgetFactory().createSection(composite, 256);
        scriptSection.setLayoutData((Object)new GridData(768));
        scriptSection.setText(Messages.configureScript);
        Composite scriptComposite = this.getWidgetFactory().createComposite(composite);
        scriptComposite.setLayout((Layout)new GridLayout(1, false));
        scriptComposite.setLayoutData((Object)new GridData(1808));
        this.createCompositeContentAtVeryTop(scriptComposite, this.getWidgetFactory());
        this.openInEditorButton = this.getWidgetFactory().createButton(scriptComposite, Messages.openInEditor, 8);
        Composite checkBoxComposite = this.getWidgetFactory().createComposite(scriptComposite);
        checkBoxComposite.setLayout((Layout)new RowLayout());
        this.checkBoxWhitespace = new Button(checkBoxComposite, 32);
        Label labelWhitespace = new Label(checkBoxComposite, 0);
        labelWhitespace.setText(Messages.showWhitespace);
        labelWhitespace.setBackground(Display.getDefault().getSystemColor(1));
        this.openInEditorButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AbstractScriptSection.this.esr = new EditScriptRunnable(AbstractScriptSection.this.node);
                AbstractScriptSection.this.esr.run();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 1;
        gridData.heightHint = 1;
        this.scriptingText = new LineNumberStyledText(scriptComposite, 2626);
        this.scriptingText.setLayoutData((Object)gridData);
        this.scriptingText.setData("property.control", (Object)"script");
        this.scriptingText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AbstractScriptSection.this.updateEditor(AbstractScriptSection.this.node);
            }
        });
        this.whitespaceListener = new WhitespaceShowListener((StyledText)this.scriptingText);
        this.scriptingText.addPaintListener((PaintListener)this.whitespaceListener);
        this.checkBoxWhitespace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = AbstractScriptSection.this.checkBoxWhitespace.getSelection();
                if (selected) {
                    AbstractScriptSection.this.whitespaceListener.setEnabled(true);
                    AbstractScriptSection.this.whitespaceListener.drawStyledText();
                    AbstractScriptSection.this.updateEditor(AbstractScriptSection.this.node);
                } else {
                    AbstractScriptSection.this.whitespaceListener.setEnabled(false);
                    AbstractScriptSection.this.whitespaceListener.redrawAll();
                }
                AbstractScriptSection.this.setProperty(AbstractScriptSection.KEY_SCRIPT_WHITESPACE_BOX, WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)AbstractScriptSection.this.node, (String)AbstractScriptSection.KEY_SCRIPT_WHITESPACE_BOX));
            }
        });
        this.checkBoxWhitespace.setData("property.control", (Object)KEY_SCRIPT_WHITESPACE_BOX);
    }

    private void updateEditor(WorkflowNode node) {
        if (this.esr != null && this.scriptingText != null && this.esr.getNode().equals((Object)node)) {
            this.esr.update(this.scriptingText.getText());
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.refresh();
    }

    private void setScriptProperty(WorkflowNode node, String newValue) {
        String oldValue = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)node, (String)"script");
        if (oldValue != null && !oldValue.equals(newValue) || oldValue == null && oldValue != newValue) {
            WorkflowNodePropertySection.SetConfigurationValueCommand command = new WorkflowNodePropertySection.SetConfigurationValueCommand("script", oldValue, newValue);
            this.execute(node, (WorkflowNodeCommand)command);
        }
    }

    protected WorkflowNodePropertySection.Updater createUpdater() {
        return new WorkflowNodePropertySection.DefaultUpdater((WorkflowNodePropertySection)this){

            public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
                super.updateControl(control, propertyName, newValue, oldValue);
                if (propertyName.equals(AbstractScriptSection.KEY_SCRIPT_WHITESPACE_BOX)) {
                    AbstractScriptSection.this.checkBoxWhitespace.getSelection();
                    if (!AbstractScriptSection.this.checkBoxWhitespace.getSelection()) {
                        AbstractScriptSection.this.checkBoxWhitespace.setSelection(false);
                        AbstractScriptSection.this.whitespaceListener.setEnabled(false);
                        AbstractScriptSection.this.whitespaceListener.redrawAll();
                    } else {
                        AbstractScriptSection.this.checkBoxWhitespace.setSelection(true);
                        AbstractScriptSection.this.whitespaceListener.setEnabled(true);
                        AbstractScriptSection.this.whitespaceListener.drawStyledText();
                        AbstractScriptSection.this.updateEditor(AbstractScriptSection.this.node);
                    }
                }
            }
        };
    }

    private class EditScriptRunnable
    extends AbstractEditScriptRunnable {
        private final WorkflowNode node;

        EditScriptRunnable(WorkflowNode node) {
            this.node = node;
        }

        public WorkflowNode getNode() {
            return this.node;
        }

        @Override
        protected void setScript(String script) {
            AbstractScriptSection.this.setScriptProperty(this.node, script);
        }

        @Override
        protected String getScript() {
            return this.node.getComponentDescription().getConfigurationDescription().getConfigurationValue("script");
        }

        @Override
        protected String getScriptName() {
            return AbstractScriptSection.this.scriptName;
        }
    }
}

