/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ConsoleRowUtils;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionController;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionUtils;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.internal.ComponentDisconnectWatcher;
import de.rcenvironment.core.component.workflow.execution.internal.ComponentStatesChangedEntirelyVerifier;
import de.rcenvironment.core.component.workflow.execution.internal.ComponentsConsoleLogFileWriter;
import de.rcenvironment.core.component.workflow.execution.internal.NodeRestartWatcher;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowExecutionRelatedInstancesFactory;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowExecutionStorageBridge;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowStateMachine;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowStateMachineContext;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowStateMachineEvent;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowStateMachineEventType;
import de.rcenvironment.core.datamodel.api.TimelineIntervalType;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkflowExecutionControllerImpl
implements WorkflowExecutionController {
    private static final Log LOG = LogFactory.getLog(WorkflowExecutionControllerImpl.class);
    private static final boolean VERBOSE_LOGGING = DebugSettings.getVerboseLoggingEnabled((String)"WorkflowExecution");
    private static DistributedNotificationService notificationService;
    private static WorkflowExecutionRelatedInstancesFactory wfExeInstancesFactory;
    private WorkflowExecutionContext wfExeCtx;
    private WorkflowExecutionStorageBridge wfExeStorageBridge;
    private WorkflowStateMachine wfStateMachine;
    private ComponentStatesChangedEntirelyVerifier compStatesEntirelyChangedVerifier;
    private ComponentsConsoleLogFileWriter compConsoleLogFileWriter;
    private ComponentDisconnectWatcher compLostWatcher;
    private AsyncOrderedExecutionQueue notifSendingAsyncExecQueue = ConcurrencyUtils.getFactory().createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
    private NodeRestartWatcher nodeRestartWatcher;

    @Deprecated
    public WorkflowExecutionControllerImpl() {
    }

    public WorkflowExecutionControllerImpl(WorkflowExecutionContext wfContext, ServiceRegistryAccess serviceRegistryAccess) {
        this.wfExeCtx = wfContext;
        this.wfExeStorageBridge = wfExeInstancesFactory.createWorkflowExecutionStorageBridge(wfContext);
        this.compConsoleLogFileWriter = wfExeInstancesFactory.createComponentConsoleLogFileWriter(this.wfExeStorageBridge);
        this.compStatesEntirelyChangedVerifier = wfExeInstancesFactory.createComponentStatesEntirelyChangedVerifier(this.wfExeCtx.getWorkflowDescription().getWorkflowNodes().size() - WorkflowExecutionUtils.getDisabledWorkflowNodes(this.wfExeCtx.getWorkflowDescription()).size());
        this.compLostWatcher = wfExeInstancesFactory.createComponentLostWatcher(this.wfExeCtx, this.compStatesEntirelyChangedVerifier);
        this.nodeRestartWatcher = wfExeInstancesFactory.createNodeRestartWatcher(this.wfExeCtx, this.compStatesEntirelyChangedVerifier, serviceRegistryAccess);
        WorkflowStateMachineContext wfStateMachineCtx = new WorkflowStateMachineContext(this.wfExeCtx, this.wfExeStorageBridge, this.compStatesEntirelyChangedVerifier, this.compConsoleLogFileWriter, this.compLostWatcher, this.nodeRestartWatcher, serviceRegistryAccess);
        this.wfStateMachine = wfExeInstancesFactory.createWorkflowStateMachine(wfStateMachineCtx);
        this.compStatesEntirelyChangedVerifier.addListener(this.wfStateMachine);
    }

    public void start() {
        this.wfStateMachine.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.START_REQUESTED));
    }

    public void pause() {
        this.wfStateMachine.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.PAUSE_REQUESTED));
    }

    public void resume() {
        this.wfStateMachine.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.RESUME_REQUESTED));
    }

    public void restart() {
        throw new UnsupportedOperationException("Restarting workflows not yet implemented");
    }

    public void cancel() {
        this.wfStateMachine.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.CANCEL_REQUESTED));
    }

    public void dispose() {
        this.wfStateMachine.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.DISPOSE_REQUESTED));
    }

    @Override
    public void setComponentExecutionAuthTokens(Map<String, String> exeAuthTokens) {
        this.wfStateMachine.setComponentExecutionAuthTokens(exeAuthTokens);
    }

    @Override
    public WorkflowState getState() {
        return (WorkflowState)this.wfStateMachine.getState();
    }

    @Override
    public Long getDataManagementId() {
        return this.wfExeStorageBridge.getWorkflowInstanceDataManamagementId();
    }

    public void onComponentStateChanged(String compExeId, ComponentState newState, Integer executionCount, String executionCountOnResets) {
        this.onComponentStateChanged(compExeId, newState, executionCount, executionCountOnResets, null, null);
    }

    public void onComponentStateChanged(String compExeId, ComponentState newState, Integer executionCount, String executionCountOnResets, String errorId) {
        this.onComponentStateChanged(compExeId, newState, executionCount, executionCountOnResets, errorId, null);
    }

    public synchronized void onComponentStateChanged(final String compExeId, final ComponentState newState, Integer executionCount, final String executionCountOnResets, String errorId, String errorMessage) {
        this.notifSendingAsyncExecQueue.enqueue(new Runnable(){

            @Override
            public void run() {
                notificationService.send("rce.component.state:" + compExeId, (Serializable)((Object)newState.name()));
                notificationService.send("rce.component.noofruns:" + compExeId, (Serializable)((Object)executionCountOnResets));
            }
        });
        this.compStatesEntirelyChangedVerifier.announceComponentState(compExeId, newState);
        if (ComponentConstants.FAILED_COMPONENT_STATES.contains(newState)) {
            WorkflowStateMachineEventType eventType = WorkflowStateMachineEventType.CANCEL_AFTER_FAILED_REQUESTED;
            if (newState == ComponentState.RESULTS_REJECTED) {
                eventType = WorkflowStateMachineEventType.CANCEL_AFTER_RESULTS_REJECTED_REQUESTED;
            }
            this.wfStateMachine.postEvent(new WorkflowStateMachineEvent(eventType, errorId, errorMessage, compExeId));
        }
    }

    public void onInputProcessed(String serializedEndpointDatum) {
        notificationService.send(StringUtils.format((String)"rce.component.input:%s:%s", (Object[])new Object[]{this.wfExeCtx.getNodeId().getLogicalNodeIdString(), this.wfExeCtx.getExecutionIdentifier()}), (Serializable)((Object)serializedEndpointDatum));
    }

    public void processConsoleRows(ConsoleRow[] consoleRows) {
        ConsoleRow[] consoleRowArray = consoleRows;
        int n = consoleRows.length;
        int n2 = 0;
        while (n2 < n) {
            ConsoleRow consoleRow = consoleRowArray[n2];
            notificationService.send(ConsoleRowUtils.composeConsoleNotificationId((LogicalNodeId)this.wfExeCtx.getNodeId(), (String)this.wfExeCtx.getExecutionIdentifier()), (Serializable)consoleRow);
            try {
                this.checkForLifecycleToolRunConsoleRow(consoleRow);
            }
            catch (WorkflowExecutionException e) {
                this.wfStateMachine.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.PROCESS_COMPONENT_TIMELINE_EVENTS_FAILED, e));
            }
            this.compConsoleLogFileWriter.addComponentConsoleRow(consoleRow);
            this.checkForLifecycleInfoEndConsoleRow(consoleRow);
            ++n2;
        }
    }

    public void onComponentHeartbeatReceived(String compExecutionId) {
        if (VERBOSE_LOGGING) {
            LOG.debug((Object)StringUtils.format((String)"Received hearbeat from component (%s) for workflow '%s' (%s)", (Object[])new Object[]{compExecutionId, this.wfExeCtx.getInstanceName(), this.wfExeCtx.getExecutionIdentifier()}));
        }
        this.compLostWatcher.announceComponentHeartbeat(compExecutionId);
    }

    private void checkForLifecycleInfoEndConsoleRow(ConsoleRow row) {
        if (row.getType() == ConsoleRow.Type.LIFE_CYCLE_EVENT && row.getPayload().startsWith(ConsoleRow.WorkflowLifecyleEventType.COMPONENT_TERMINATED.name())) {
            this.compStatesEntirelyChangedVerifier.announceLastConsoleRow(row.getComponentIdentifier());
        }
    }

    private void checkForLifecycleToolRunConsoleRow(ConsoleRow row) throws WorkflowExecutionException {
        if (row.getType() == ConsoleRow.Type.LIFE_CYCLE_EVENT) {
            if (row.getPayload().startsWith(ConsoleRow.WorkflowLifecyleEventType.TOOL_STARTING.name())) {
                this.wfExeStorageBridge.addComponentTimelineInterval(TimelineIntervalType.EXTERNAL_TOOL_RUN_IN_COMPONENT_RUN, row.getTimestamp(), StringUtils.splitAndUnescape((String)row.getPayload())[1]);
            } else if (row.getPayload().startsWith(ConsoleRow.WorkflowLifecyleEventType.TOOL_FINISHED.name())) {
                this.wfExeStorageBridge.setComponentTimelineIntervalFinished(TimelineIntervalType.EXTERNAL_TOOL_RUN_IN_COMPONENT_RUN, row.getTimestamp(), StringUtils.splitAndUnescape((String)row.getPayload())[1]);
            }
        }
    }

    protected void bindDistributedNotificationService(DistributedNotificationService newService) {
        notificationService = newService;
    }

    protected void bindWorkflowExecutionRelatedInstancesFactory(WorkflowExecutionRelatedInstancesFactory newService) {
        wfExeInstancesFactory = newService;
    }
}

