/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.communication.api.LiveNetworkIdResolutionService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.routing.InstanceRestartAndPresenceService;
import de.rcenvironment.core.communication.routing.InstanceSessionNetworkStatus;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.internal.ComponentStatesChangedEntirelyVerifier;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeRestartWatcher
implements Runnable {
    public static final long DEFAULT_TEST_INTERVAL_MSEC = 10000L;
    private final Map<InstanceNodeSessionId, List<String>> instanceSessionIdsAndHostedComponentExecIds = new HashMap<InstanceNodeSessionId, List<String>>();
    private final ComponentStatesChangedEntirelyVerifier compStatesEntirelyChangedVerifier;
    private final InstanceRestartAndPresenceService restartAndPresenceService;
    private final InstanceNodeSessionId localInstanceSessionId;
    private final Log log = LogFactory.getLog(this.getClass());
    private LiveNetworkIdResolutionService idResolutionService;

    public NodeRestartWatcher(ComponentStatesChangedEntirelyVerifier compStatesEntirelyChangedVerifier, WorkflowExecutionContext wfExeCtx, ServiceRegistryAccess serviceRegistryAccess) {
        this.compStatesEntirelyChangedVerifier = compStatesEntirelyChangedVerifier;
        this.idResolutionService = (LiveNetworkIdResolutionService)serviceRegistryAccess.getService(LiveNetworkIdResolutionService.class);
        this.localInstanceSessionId = ((PlatformService)serviceRegistryAccess.getService(PlatformService.class)).getLocalInstanceNodeSessionId();
        this.restartAndPresenceService = (InstanceRestartAndPresenceService)serviceRegistryAccess.getService(InstanceRestartAndPresenceService.class);
    }

    public synchronized void initialize(Collection<ComponentExecutionContext> compExecContexts) throws WorkflowExecutionException {
        for (ComponentExecutionContext componentExecutionContext : compExecContexts) {
            LogicalNodeSessionId resolvedLNId;
            try {
                resolvedLNId = this.idResolutionService.resolveToLogicalNodeSessionId((ResolvableNodeId)componentExecutionContext.getNodeId());
            }
            catch (IdentifierException identifierException) {
                throw new WorkflowExecutionException("No matching node for location of component " + componentExecutionContext.getExecutionIdentifier() + ", which is node " + componentExecutionContext.getNodeId() + " - it has probably become unreachable since the workflow was initiated");
            }
            InstanceNodeSessionId componentHostInstanceSessionId = resolvedLNId.convertToInstanceNodeSessionId();
            if (this.localInstanceSessionId.isSameInstanceNodeSessionAs(componentHostInstanceSessionId)) continue;
            List compExecIdList = this.instanceSessionIdsAndHostedComponentExecIds.computeIfAbsent(componentHostInstanceSessionId, key -> new ArrayList());
            compExecIdList.add(componentExecutionContext.getExecutionIdentifier());
        }
        for (Map.Entry entry : this.instanceSessionIdsAndHostedComponentExecIds.entrySet()) {
            InstanceNodeSessionId instanceSessionId = (InstanceNodeSessionId)entry.getKey();
            InstanceSessionNetworkStatus.State networkState = this.restartAndPresenceService.queryInstanceSessionNetworkStatus(instanceSessionId).getState();
            if (networkState == InstanceSessionNetworkStatus.State.PRESENT_WITH_DIFFERENT_SESSION || networkState == InstanceSessionNetworkStatus.State.ID_COLLISION) {
                throw new WorkflowExecutionException("The instance session " + instanceSessionId + " is unreachable right after selecting it as the location for one or more workflow components " + "- it has probably become unreachable moments ago");
            }
            this.log.debug((Object)("Verified initial instance session reachability of " + instanceSessionId + " hosting components " + Arrays.toString(((List)entry.getValue()).toArray())));
        }
    }

    @Override
    public synchronized void run() {
        HashSet lostComponentExecIds = null;
        for (Map.Entry<InstanceNodeSessionId, List<String>> entry : this.instanceSessionIdsAndHostedComponentExecIds.entrySet()) {
            InstanceNodeSessionId instanceSessionId = entry.getKey();
            InstanceSessionNetworkStatus.State networkState = this.restartAndPresenceService.queryInstanceSessionNetworkStatus(instanceSessionId).getState();
            if (networkState != InstanceSessionNetworkStatus.State.PRESENT_WITH_DIFFERENT_SESSION && networkState != InstanceSessionNetworkStatus.State.ID_COLLISION) continue;
            String reasonText = networkState == InstanceSessionNetworkStatus.State.PRESENT_WITH_DIFFERENT_SESSION ? " has been restarted, which means that these component runs cannot be recovered" : " is affected by a network id collision, which could result in undefined behavior and is therefore not allowed";
            this.log.warn((Object)("The instance " + instanceSessionId + " running the component(s) " + Arrays.toString(entry.getValue().toArray()) + reasonText + "; the workflow will be aborted"));
            if (lostComponentExecIds == null) {
                lostComponentExecIds = new HashSet();
            }
            lostComponentExecIds.addAll(entry.getValue());
        }
        if (lostComponentExecIds != null) {
            if (lostComponentExecIds.isEmpty()) {
                throw new IllegalStateException("Internal consistency error: created a list of lost nodes but it is empty");
            }
            this.compStatesEntirelyChangedVerifier.announceLostComponents(lostComponentExecIds);
        }
    }
}

