/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.impl;

import de.rcenvironment.core.communication.api.ServiceCallContext;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.component.execution.api.ComponentExecutionIdentifier;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionHandle;
import de.rcenvironment.core.component.workflow.execution.impl.ExecutionHandleImpl;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class WorkflowExecutionContextImpl
implements WorkflowExecutionContext {
    private static final long serialVersionUID = 238066231055021678L;
    private String executionIdentifier;
    private String instanceName;
    private WorkflowDescription workflowDescription;
    private WorkflowExecutionHandle workflowHandle;
    private Map<WorkflowNodeIdentifier, ComponentExecutionIdentifier> componentExecutionIdentifiers;
    private LogicalNodeId nodeIdentifierStartedExecution;
    private String additionalInformation;
    private LogicalNodeId storageNetworkDestination;

    public WorkflowExecutionContextImpl(String executionIdentifier, WorkflowDescription workflowDescription) {
        this.executionIdentifier = executionIdentifier;
        this.workflowDescription = workflowDescription;
        this.workflowHandle = new ExecutionHandleImpl(executionIdentifier, workflowDescription.getControllerNode());
        this.componentExecutionIdentifiers = new HashMap<WorkflowNodeIdentifier, ComponentExecutionIdentifier>();
        for (WorkflowNode wfNode : workflowDescription.getWorkflowNodes()) {
            ComponentExecutionIdentifier compExeId = new ComponentExecutionIdentifier(UUID.randomUUID().toString());
            this.componentExecutionIdentifiers.put(wfNode.getIdentifierAsObject(), compExeId);
        }
    }

    public String getExecutionIdentifier() {
        return this.executionIdentifier;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public LogicalNodeId getNodeId() {
        return this.workflowDescription.getControllerNode();
    }

    @Override
    public WorkflowExecutionHandle getWorkflowExecutionHandle() {
        return this.workflowHandle;
    }

    public LogicalNodeId getStorageNodeId() {
        return this.workflowDescription.getControllerNode();
    }

    public NetworkDestination getStorageNetworkDestination() {
        return this.workflowDescription.getControllerNode();
    }

    @Override
    public WorkflowDescription getWorkflowDescription() {
        return this.workflowDescription;
    }

    @Override
    public ComponentExecutionIdentifier getCompExeIdByWfNode(WorkflowNode wfNode) {
        return this.componentExecutionIdentifiers.get(wfNode.getIdentifierAsObject());
    }

    @Override
    public LogicalNodeId getNodeIdStartedExecution() {
        return this.nodeIdentifierStartedExecution;
    }

    @Override
    public String getAdditionalInformationProvidedAtStart() {
        return this.additionalInformation;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setNodeIdentifierStartedExecution(LogicalNodeId nodeIdentifier) {
        this.nodeIdentifierStartedExecution = nodeIdentifier;
    }

    public void setAdditionalInformationProvidedAtStart(String additionalInformationProvidedAtStart) {
        this.additionalInformation = additionalInformationProvidedAtStart;
    }

    public ServiceCallContext getServiceCallContext() {
        return null;
    }
}

