/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.api;

public enum WorkflowState {
    INIT("Init"),
    STARTING("Starting"),
    PREPARING("Preparing"),
    RUNNING("Running"),
    PAUSING("Pausing"),
    PAUSED("Paused"),
    RESUMING("Resuming"),
    FINISHED("Finished"),
    CANCELING("Canceling"),
    CANCELING_AFTER_FAILED("Canceling after failure"),
    CANCELING_AFTER_RESULTS_REJECTED("Canceling after results rejected"),
    CANCELLED("Canceled"),
    FAILED("Failed"),
    RESULTS_REJECTED("Results rejected"),
    DISPOSING("Disposing"),
    DISPOSED("Disposed"),
    UNKNOWN("Unknown"),
    IS_ALIVE("Is alive");

    private String displayName;

    private WorkflowState(String displayName) {
        this.displayName = displayName;
    }

    public static boolean isWorkflowStateValidAndUserReadable(String workflowState) {
        return WorkflowState.isWorkflowStateValid(workflowState) && !workflowState.equals(IS_ALIVE.name());
    }

    public static boolean isWorkflowStateUserReadable(WorkflowState workflowState) {
        return !workflowState.equals((Object)IS_ALIVE);
    }

    public static boolean isWorkflowStateValid(String workflowState) {
        try {
            WorkflowState.valueOf(workflowState);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isResumable() {
        return this.equals((Object)PAUSED);
    }

    public boolean isPausable() {
        return this.equals((Object)RUNNING);
    }

    public boolean isCancellable() {
        return this.equals((Object)RUNNING) || this.equals((Object)PAUSED);
    }
}

