/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.log;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SerializableLogEntry
implements Serializable,
Comparable<SerializableLogEntry> {
    public static final String RCE_SEPARATOR = "#RCEn";
    private static final long serialVersionUID = 1L;
    private final String bundleName;
    private final int level;
    private final String message;
    private final long time;
    private final String exception;
    private InstanceNodeSessionId platformId;

    public SerializableLogEntry(String bundleName, int level, String message, long time, String exception) {
        this.bundleName = bundleName;
        this.level = level;
        this.message = message;
        this.time = time;
        this.exception = exception;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public int getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTime() {
        return this.time;
    }

    public String getException() {
        return this.exception;
    }

    public InstanceNodeSessionId getPlatformIdentifer() {
        return this.platformId;
    }

    public void setPlatformIdentifer(InstanceNodeSessionId newPlatformId) {
        this.platformId = newPlatformId;
    }

    public String toString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss,SSS");
        String levelAsString = null;
        switch (this.level) {
            case 1: {
                levelAsString = "ERROR";
                break;
            }
            case 2: {
                levelAsString = "WARNING";
                break;
            }
            case 3: {
                levelAsString = "INFO";
                break;
            }
            case 4: {
                levelAsString = "DEBUG";
                break;
            }
        }
        return String.valueOf(df.format(this.time)) + " " + levelAsString + " - " + this.message;
    }

    @Override
    public int compareTo(SerializableLogEntry o) {
        int compResult = new Date(this.time).compareTo(new Date(o.getTime()));
        if (compResult == 0 && (compResult = this.platformId.toString().compareTo(o.getPlatformIdentifer().toString())) == 0 && (compResult = this.bundleName.compareTo(o.getBundleName())) == 0 && (compResult = new Integer(this.level).compareTo(new Integer(o.getLevel()))) == 0) {
            compResult = this.message.compareTo(o.getMessage());
        }
        if (compResult == 0 && this.exception != null && o.getException() != null) {
            compResult = this.exception.compareTo(o.getException());
        }
        return compResult;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.bundleName.hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SerializableLogEntry)) {
            return false;
        }
        SerializableLogEntry other = (SerializableLogEntry)obj;
        if (this.bundleName == null ? other.bundleName != null : !this.bundleName.equals(other.bundleName)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.time == other.time;
    }
}

