/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;

public class CodedName
implements NodeName {
    private int nameCode;
    private NamePool pool;

    public CodedName(int nameCode, NamePool pool) {
        this.nameCode = nameCode;
        this.pool = pool;
    }

    public String getPrefix() {
        return this.pool.getPrefix(this.nameCode);
    }

    public String getURI() {
        return this.pool.getURI(this.nameCode);
    }

    public String getLocalPart() {
        return this.pool.getLocalName(this.nameCode);
    }

    public String getDisplayName() {
        return this.pool.getDisplayName(this.nameCode);
    }

    public StructuredQName getStructuredQName() {
        return this.pool.getStructuredQName(this.nameCode);
    }

    public boolean isInSameNamespace(NodeName other) {
        return this.getURI().equals(other.getURI());
    }

    public boolean isInNamespace(String ns) {
        return this.getURI().equals(ns);
    }

    public NamespaceBinding getNamespaceBinding() {
        return this.pool.getNamespaceBinding(this.nameCode);
    }

    public boolean hasFingerprint() {
        return true;
    }

    public int getFingerprint() {
        return this.nameCode & 0xFFFFF;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int allocateNameCode(NamePool namePool) {
        return this.nameCode;
    }

    public int hashCode() {
        return StructuredQName.computeHashCode(this.getURI(), this.getLocalPart());
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeName) {
            NodeName n = (NodeName)obj;
            if (n.hasFingerprint()) {
                return this.getFingerprint() == n.getFingerprint();
            }
            return n.getLocalPart().equals(this.getLocalPart()) && n.isInNamespace(this.getURI());
        }
        return false;
    }
}

