/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.common;

import de.rcenvironment.components.switchcmp.common.Messages;
import de.rcenvironment.components.switchcmp.common.SwitchComponentConstants;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.scripting.ScriptingService;
import de.rcenvironment.core.scripting.ScriptingUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.core.utils.scripting.ScriptLanguage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ScriptValidation {
    private static ScriptEngine engine = null;
    private static final Log LOGGER = LogFactory.getLog(ScriptValidation.class);
    private static final int COLUMNNOTFOUND = -1;

    private ScriptValidation() {
    }

    public static String validateScript(String script, Map<String, Boolean> inputsAndConnectionStatus, Map<String, DataType> inputsAndDataTypes, Object callerInstance) {
        if (engine == null) {
            ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)callerInstance);
            ScriptingService service = (ScriptingService)serviceRegistryAccess.getService(ScriptingService.class);
            engine = service.createScriptEngine(ScriptLanguage.getByName((String)"Jython"));
        }
        return ScriptValidation.validateScript(script, engine, inputsAndConnectionStatus, inputsAndDataTypes);
    }

    public static String validateScript(String script, ScriptEngine scriptEngine, Map<String, Boolean> inputsAndConnectionStatus, Map<String, DataType> inputsAndDataTypes) {
        if (script.trim().isEmpty()) {
            return Messages.noConditionString;
        }
        ArrayList<String> errorMessage = ScriptValidation.collectErrorMessage(script, inputsAndConnectionStatus, inputsAndDataTypes);
        Set<String> errorMessagePython = ScriptValidation.collectPythonErrorMessages(script, scriptEngine, inputsAndDataTypes);
        errorMessage.addAll(errorMessagePython);
        return ScriptValidation.createErrorMessageString(errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> collectPythonErrorMessages(String script, ScriptEngine scriptEngine, Map<String, DataType> inputsAndDataTypes) {
        HashSet<String> errorMessagePython = new HashSet<String>();
        StringBuilder varDefScript = ScriptValidation.buildVariableDefinitionScript(inputsAndDataTypes);
        try {
            Object object = ScriptingUtils.SCRIPT_EVAL_LOCK_OBJECT;
            synchronized (object) {
                String evalScript = String.valueOf(varDefScript.toString()) + "if " + script + ":\n    returnValue=True\nelse:\n    returnValue=False";
                scriptEngine.eval(evalScript);
            }
        }
        catch (ScriptException e) {
            if (e.getColumnNumber() != -1) {
                errorMessagePython.add("Syntax error: mismatched input at position " + (e.getColumnNumber() - 3));
            }
            errorMessagePython.add("Syntax error: unknown position");
        }
        return errorMessagePython;
    }

    /*
     * Unable to fully structure code
     */
    private static ArrayList<String> collectErrorMessage(String script, Map<String, Boolean> inputsAndConnectionStatus, Map<String, DataType> inputsAndDataTypes) {
        block4: {
            errorMessage = new ArrayList<String>();
            errorMessageNotSupported = new HashSet<String>();
            errorMessageNotDefined = new HashSet<String>();
            errorMessageNotConnected = new HashSet<E>();
            operatorList = new ArrayList<String>(Arrays.asList(SwitchComponentConstants.OPERATORS));
            operatorList.addAll(Arrays.asList(SwitchComponentConstants.OPERATORS_FOR_VALIDATION));
            operatorPattern = Pattern.compile(ScriptValidation.createValidationRegex(operatorList));
            operatorMatcher = operatorPattern.matcher(script);
            if (inputsAndConnectionStatus.keySet().isEmpty()) ** GOTO lbl26
            for (String inputName : inputsAndConnectionStatus.keySet()) {
                inputToForwardDataType = inputsAndDataTypes.get(inputName);
                while (operatorMatcher.find()) {
                    if (operatorMatcher.group(0).equals(inputName) && inputToForwardDataType != null && !Arrays.asList(SwitchComponentConstants.CONDITION_SCRIPT_DATA_TYPES).contains(inputToForwardDataType)) {
                        errorMessageNotSupported.add(StringUtils.format((String)"Data type '%s' of input '%s' not supported in script", (Object[])new Object[]{inputToForwardDataType, inputName}));
                    }
                    if (inputsAndConnectionStatus.containsKey(operatorMatcher.group(0)) || operatorList.contains(operatorMatcher.group(0)) || operatorMatcher.group(0).trim().isEmpty() || org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)operatorMatcher.group())) continue;
                    errorMessageNotDefined.add(StringUtils.format((String)"'%s' is not defined", (Object[])new Object[]{operatorMatcher.group(0)}));
                }
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (operatorList.contains(operatorMatcher.group(0)) || operatorMatcher.group(0).trim().isEmpty() || org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)operatorMatcher.group())) continue;
                errorMessageNotDefined.add(StringUtils.format((String)"'%s' is not defined", (Object[])new Object[]{operatorMatcher.group(0)}));
lbl26:
                // 3 sources

                ** while (operatorMatcher.find())
            }
        }
        errorMessage.addAll(errorMessageNotSupported);
        errorMessage.addAll(errorMessageNotDefined);
        errorMessage.addAll(errorMessageNotConnected);
        return errorMessage;
    }

    private static StringBuilder buildVariableDefinitionScript(Map<String, DataType> inputsAndDataTypes) {
        StringBuilder varDefScript = new StringBuilder();
        for (Map.Entry<String, DataType> entry : inputsAndDataTypes.entrySet()) {
            switch (entry.getValue()) {
                case Integer: {
                    String str = String.valueOf(entry.getKey()) + " = 11\n";
                    varDefScript.append(str);
                    break;
                }
                case Float: {
                    String str = String.valueOf(entry.getKey()) + " = 11.1\n";
                    varDefScript.append(str);
                    break;
                }
                case Boolean: {
                    String str = String.valueOf(entry.getKey()) + " = True\n";
                    varDefScript.append(str);
                    break;
                }
            }
        }
        return varDefScript;
    }

    private static String createErrorMessageString(ArrayList<String> errorMessage) {
        if (!errorMessage.isEmpty()) {
            if (errorMessage.size() == 1) {
                return errorMessage.get(0);
            }
            String lastErrorMessage = errorMessage.remove(errorMessage.size() - 1);
            String string = org.apache.commons.lang3.StringUtils.join(errorMessage, (String)"; \n");
            return String.valueOf(string) + "; \n" + lastErrorMessage;
        }
        return "";
    }

    private static String createValidationRegex(List<String> operatorList) {
        StringBuilder op = new StringBuilder();
        op.append("(");
        for (String operator : operatorList) {
            if (operator.equals("<") || operator.equals(">")) {
                op.append(String.valueOf(operator) + "(?!=)");
            } else {
                op.append(operator);
            }
            op.append("|");
        }
        op.append("\\b\\w+\\b");
        op.append(")");
        try {
            Pattern.compile(op.toString());
        }
        catch (PatternSyntaxException e) {
            LOGGER.error((Object)"Invalid Regex!", (Throwable)e);
        }
        return op.toString();
    }
}

