/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.utils;

import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.toolkitbridge.transitional.StatsCounter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;

public final class MessageUtils {
    private static final int INITIAL_SERIALIZATION_BUFFER_SIZE = 512;

    private MessageUtils() {
    }

    public static byte[] serializeObject(Serializable object) throws SerializationException {
        return MessageUtils.serialize(object);
    }

    public static byte[] serializeSafeObject(Serializable object) {
        try {
            return MessageUtils.serialize(object);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Serializable deserializeObject(byte[] data) throws SerializationException {
        return MessageUtils.deserializeObject(data, Serializable.class);
    }

    public static <T> T deserializeObject(byte[] data, Class<T> clazz) throws SerializationException {
        return (T)MessageUtils.deserialize(data);
    }

    private static byte[] serialize(Serializable object) throws SerializationException {
        StatsCounter.countClass((String)"MessageUtils.serialize()", (Object)object);
        ObjectOutputStream oos = null;
        ByteArrayOutputStream baos = null;
        try {
            try {
                baos = new ByteArrayOutputStream(512);
                oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
            }
            catch (IOException ex) {
                throw new SerializationException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(oos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)oos);
        return baos.toByteArray();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deserialize(byte[] data) throws SerializationException {
        Object object;
        if (data == null) {
            throw new SerializationException(new NullPointerException());
        }
        if (data.length == 0) {
            throw new SerializationException("Empty array passed for deserialization");
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(data));
            Object object2 = ois.readObject();
            StatsCounter.countClass((String)"MessageUtils.deserialize()", (Object)object2);
            object = object2;
        }
        catch (ClassNotFoundException ex) {
            try {
                throw new SerializationException(ex);
                catch (IOException ex2) {
                    throw new SerializationException(ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        return object;
    }
}

