/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.rpc.api.CallbackProxyService;
import de.rcenvironment.core.communication.rpc.api.CallbackService;
import de.rcenvironment.core.communication.rpc.api.RemotableCallbackService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.ServiceUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class CleanJob {
    public static final int TTL_MSEC = 600000;
    public static final int UPDATE_INTERVAL_MSEC = 480000;
    public static final String SERVICE = "de.rcenvironment.rce.communication.callback.service";
    public static final String WEAK_MAP = "de.rcenvironment.rce.communication.callback.weak";
    public static final String TTL_MAP = "de.rcenvironment.rce.communication.callback.ttl";
    public static final String PLATFORMS_MAP = "de.rcenvironment.rce.communication.callback.platforms";
    private static CommunicationService communicationService;
    private static Map<String, ScheduledFuture<?>> backgroundCleanJob;

    static {
        backgroundCleanJob = new HashMap();
    }

    @Deprecated
    public CleanJob() {
    }

    protected void activate(BundleContext bundleContext) {
    }

    protected void bindCommunicationService(CommunicationService newCommunicationService) {
        communicationService = newCommunicationService;
    }

    protected void unbindCommunicationService(CommunicationService oldCommunicationService) {
        communicationService = (CommunicationService)ServiceUtils.createFailingServiceProxy(CommunicationService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleJob(Class iface, Map<String, WeakReference<Object>> objects, Map<String, Long> ttls, Map<String, InstanceNodeSessionId> platforms) {
        Class<CleanJob> clazz = CleanJob.class;
        synchronized (CleanJob.class) {
            if (!backgroundCleanJob.containsKey(iface.getCanonicalName())) {
                CleanRunnable runnable = new CleanRunnable(iface, objects, ttls, platforms);
                backgroundCleanJob.put(iface.getCanonicalName(), ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedInterval("Communication Layer: Purge old callback objects/proxies and renew TTL for remaining", (Runnable)runnable, 480000L));
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unscheduleJob(Class iface) {
        Class<CleanJob> clazz = CleanJob.class;
        synchronized (CleanJob.class) {
            boolean cancelled;
            if (backgroundCleanJob.containsKey(iface.getCanonicalName()) && !(cancelled = backgroundCleanJob.get(iface.getCanonicalName()).cancel(true))) {
                LogFactory.getLog(CleanJob.class).warn((Object)("Clean job triggered by " + iface.getCanonicalName() + " could not be cancelled. Probably, it was already done."));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static class CleanRunnable
    implements Runnable {
        private final Class<?> iface;
        private final Map<String, WeakReference<Object>> objects;
        private final Map<String, InstanceNodeSessionId> nodes;
        private final Map<String, Long> ttls;

        protected CleanRunnable(Class<?> iface, Map<String, WeakReference<Object>> objects, Map<String, Long> ttls, Map<String, InstanceNodeSessionId> nodes) {
            this.iface = iface;
            this.objects = objects;
            this.nodes = nodes;
            this.ttls = ttls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<String, WeakReference<Object>> map = this.objects;
            synchronized (map) {
                Iterator<String> iterator = this.objects.keySet().iterator();
                while (iterator.hasNext()) {
                    String id = iterator.next();
                    if (this.objects.get(id).get() == null || new Date(this.ttls.get(id)).before(new Date())) {
                        iterator.remove();
                        this.ttls.remove(id);
                        this.nodes.remove(id);
                        continue;
                    }
                    try {
                        if (this.iface == CallbackProxyService.class) {
                            RemotableCallbackService remoteService = communicationService.getRemotableService(RemotableCallbackService.class, this.nodes.get(id));
                            remoteService.setTTL(id, this.ttls.get(id));
                            continue;
                        }
                        if (this.iface != CallbackService.class) continue;
                        throw new RemoteOperationException("Unexpected callback code path used");
                    }
                    catch (RemoteOperationException | RuntimeException throwable) {
                        LogFactory.getLog(this.getClass()).debug((Object)("Failed to update TTL for id " + id + " via " + this.iface.getSimpleName() + " @ " + this.nodes.get(id)));
                    }
                }
            }
        }
    }
}

