/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.management.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandFlag;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.StringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.channel.MessageChannelService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.management.BenchmarkService;
import de.rcenvironment.core.communication.management.BenchmarkSetup;
import de.rcenvironment.core.communication.nodeproperties.NodePropertiesService;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.incubator.GraphvizUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetCommandPlugin
implements CommandPlugin {
    private static final String CMD_NET = "net";
    private static final String INFO = "info";
    private static final CommandFlag ALL_FLAG = new CommandFlag("-a", "--all", "include unreachable nodes");
    private static final StringParameter BASE_NAME_PARAMETER = new StringParameter(null, "base name", "base name parameter");
    private static final StringParameter BENCHMARK_DESCRIPTION = new StringParameter(null, "taskdef", "<targetNode|*>([<numMessages>],[<requestSize>],[<responseSize>],[<responseDelay(msec)>],[<threadsPerTarget>])");
    private CommunicationService communicationService;
    private BenchmarkService benchmarkService;
    private NodePropertiesService nodePropertiesService;
    private MessageChannelService messageChannelService;
    private final Log log = LogFactory.getLog(this.getClass());
    private File outputDir;

    public MainCommandDescription[] getCommands() {
        MainCommandDescription commands = new MainCommandDescription(CMD_NET, "query the network and topology state", "alias for 'net info'", this::performNetInfo, new SubCommandDescription[]{new SubCommandDescription(INFO, "show a list of reachable RCE nodes", this::performNetInfo), new SubCommandDescription("graph", "generates a Graphviz file of the current network topology", this::performNetGraph, new CommandModifierInfo(new AbstractCommandParameter[]{BASE_NAME_PARAMETER}, new CommandFlag[]{ALL_FLAG}), true), new SubCommandDescription("filter", "show IP filter status", this::performNetFilter), new SubCommandDescription("reload-filter", "reloads the IP filter configuration", this::performRelaodFilter), new SubCommandDescription("bench", "run communication benchmark", this::performNetBench, new CommandModifierInfo(new AbstractCommandParameter[]{BENCHMARK_DESCRIPTION}), true), new SubCommandDescription("np", "show known RCE node properties", this::performNetNp, true)});
        return new MainCommandDescription[]{commands};
    }

    public void bindCommunicationService(CommunicationService newInstance) {
        this.communicationService = newInstance;
    }

    public void bindBenchmarkService(BenchmarkService newInstance) {
        this.benchmarkService = newInstance;
    }

    public void bindNodePropertiesService(NodePropertiesService newInstance) {
        this.nodePropertiesService = newInstance;
    }

    public void bindConfigurationService(ConfigurationService newInstance) {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.outputDir = newInstance.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_OUTPUT);
    }

    public void bindMessageChannelService(MessageChannelService newInstance) {
        this.messageChannelService = newInstance;
    }

    private void performNetGraph(CommandContext context) {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter baseNameParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        boolean hasAllFlag = modifiers.hasCommandFlag("-a");
        if (this.outputDir == null || !this.outputDir.isDirectory()) {
            throw new IllegalStateException("Invalid output dir: " + this.outputDir);
        }
        String formatName = "graphviz";
        if (hasAllFlag) {
            formatName = "graphviz-all";
            context.setDeveloperCommandSetEnabled(true);
        }
        String baseName = "rce_network";
        if (!baseNameParameter.getResult().equals("")) {
            baseName = baseNameParameter.getResult();
        }
        String graphvizData = this.communicationService.getFormattedNetworkInformation(formatName);
        File gvFile = new File(this.outputDir, String.valueOf(baseName) + ".gv");
        File pngFile = new File(this.outputDir, String.valueOf(baseName) + ".png");
        try {
            FileUtils.writeStringToFile((File)gvFile, (String)graphvizData);
            context.println((Object)("Graphviz file written to " + gvFile.getAbsolutePath()));
        }
        catch (IOException e) {
            this.log.error((Object)("Error writing script file " + gvFile.getAbsolutePath()), (Throwable)e);
            return;
        }
        if (GraphvizUtils.renderDotFileToPng((File)gvFile, (File)pngFile, (TextOutputReceiver)context.getOutputReceiver())) {
            context.println((Object)("PNG file written to " + pngFile.getAbsolutePath()));
        } else {
            context.println((Object)("Error running graphviz - PNG file " + pngFile.getAbsolutePath() + " was probably not generated"));
        }
    }

    private void performNetInfo(CommandContext context) {
        context.println((Object)this.communicationService.getFormattedNetworkInformation(INFO));
    }

    private void performNetBench(CommandContext context) throws CommandException {
        BenchmarkSetup setup;
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter benchmarkDescriptionParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        context.setDeveloperCommandSetEnabled(true);
        try {
            String benchmarkDescription = benchmarkDescriptionParameter.getResult();
            setup = this.benchmarkService.parseBenchmarkDescription(benchmarkDescription);
        }
        catch (IllegalArgumentException e) {
            throw CommandException.syntaxError((String)("Error parsing benchmark setup: " + e.toString()), (CommandContext)context);
        }
        context.println((Object)"Benchmark starting");
        this.benchmarkService.executeBenchmark(setup, context.getOutputReceiver());
        context.println((Object)"Benchmark complete");
    }

    private void performNetFilter(CommandContext context) {
        this.messageChannelService.printIPFilterInformation(context.getOutputReceiver());
    }

    private void performRelaodFilter(CommandContext context) {
        this.messageChannelService.loadAndApplyIPFilterConfiguration();
        this.messageChannelService.printIPFilterInformation(context.getOutputReceiver());
    }

    private void performNetNp(CommandContext context) {
        Set<InstanceNodeSessionId> nodes = this.communicationService.getReachableInstanceNodes();
        Map<InstanceNodeSessionId, Map<String, String>> allMetadata = this.nodePropertiesService.getAllNodeProperties(nodes);
        context.println((Object)"Known node properties:");
        for (Map.Entry<InstanceNodeSessionId, Map<String, String>> entry1 : allMetadata.entrySet()) {
            InstanceNodeSessionId nodeId = entry1.getKey();
            context.println((Object)nodeId.toString());
            Map<String, String> map = entry1.getValue();
            for (Map.Entry<String, String> entry2 : map.entrySet()) {
                context.println((Object)StringUtils.format((String)"  %s = %s", (Object[])new Object[]{entry2.getKey(), entry2.getValue()}));
            }
        }
    }
}

