/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.common.impl;

import de.rcenvironment.core.communication.api.LiveNetworkIdResolutionService;
import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.api.NodeNameResolver;
import de.rcenvironment.core.communication.common.CommonIdBase;
import de.rcenvironment.core.communication.common.IdType;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeId;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.NodeIdentifierContextHolder;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.utils.common.ConsistencyChecks;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NodeIdentifierImpl
implements CommonIdBase,
ResolvableNodeId,
InstanceNodeId,
InstanceNodeSessionId,
LogicalNodeId,
LogicalNodeSessionId {
    private static final long serialVersionUID = 5233747521769167502L;
    private static final String REGEXP_GROUP_SESSION_ID_PART = "([0-9a-f]{10})";
    private static final String REGEXP_GROUP_INSTANCE_ID_PART = "([0-9a-f]{32})";
    private static final String REGEXP_GROUP_LOGICAL_NODE_PART = "(0|[0-9a-zA-Z_]{1,33})";
    private static final Pattern INSTANCE_ID_STRING_PARSE_PATTERN = Pattern.compile("([0-9a-f]{32})");
    private static final Pattern INSTANCE_SESSION_ID_STRING_PARSE_PATTERN = Pattern.compile("([0-9a-f]{32})::([0-9a-f]{10})");
    private static final Pattern LOGICAL_NODE_ID_STRING_PARSE_PATTERN = Pattern.compile("([0-9a-f]{32}):(0|[0-9a-zA-Z_]{1,33})");
    private static final Pattern LOGICAL_NODE_SESSION_ID_STRING_PARSE_PATTERN = Pattern.compile("([0-9a-f]{32}):(0|[0-9a-zA-Z_]{1,33}):([0-9a-f]{10})");
    private final IdType idType;
    private final String instanceIdPart;
    private final String sessionIdPart;
    private final String logicalNodePart;
    private final String fullIdString;
    private final transient NodeNameResolver nodeNameResolver;
    private transient byte tempDeserializationTypeMarker;
    private transient String tempDeserializationString;

    protected NodeIdentifierImpl() {
        this.idType = null;
        this.instanceIdPart = null;
        this.sessionIdPart = null;
        this.logicalNodePart = null;
        this.fullIdString = null;
        this.nodeNameResolver = null;
    }

    public NodeIdentifierImpl(String input, NodeNameResolver nodeNameResolver, IdType type) throws IdentifierException {
        Objects.requireNonNull(input, "Cannot parse 'null' string to a node identifier");
        this.idType = type;
        switch (type) {
            case INSTANCE_NODE_ID: {
                Matcher matcher = this.matchRegexpOrFail(INSTANCE_ID_STRING_PARSE_PATTERN, input, this.idType);
                this.instanceIdPart = matcher.group(1);
                this.logicalNodePart = null;
                this.sessionIdPart = null;
                break;
            }
            case INSTANCE_NODE_SESSION_ID: {
                Matcher matcher = this.matchRegexpOrFail(INSTANCE_SESSION_ID_STRING_PARSE_PATTERN, input, this.idType);
                this.instanceIdPart = matcher.group(1);
                this.logicalNodePart = null;
                this.sessionIdPart = matcher.group(2);
                break;
            }
            case LOGICAL_NODE_ID: {
                Matcher matcher = this.matchRegexpOrFail(LOGICAL_NODE_ID_STRING_PARSE_PATTERN, input, this.idType);
                this.instanceIdPart = matcher.group(1);
                this.logicalNodePart = matcher.group(2);
                this.sessionIdPart = null;
                break;
            }
            case LOGICAL_NODE_SESSION_ID: {
                Matcher matcher = this.matchRegexpOrFail(LOGICAL_NODE_SESSION_ID_STRING_PARSE_PATTERN, input, this.idType);
                this.instanceIdPart = matcher.group(1);
                this.logicalNodePart = matcher.group(2);
                this.sessionIdPart = matcher.group(3);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected id type requested for deserialization: " + (Object)((Object)this.idType));
            }
        }
        this.fullIdString = input;
        this.nodeNameResolver = nodeNameResolver;
        this.checkBasicInternalConsistency();
    }

    protected NodeIdentifierImpl(String instanceIdPart, String logicalNodePart, String sessionIdPart, NodeNameResolver nodeNameResolver, IdType type) {
        this.instanceIdPart = instanceIdPart;
        this.sessionIdPart = sessionIdPart;
        this.logicalNodePart = logicalNodePart;
        this.nodeNameResolver = nodeNameResolver;
        this.idType = type;
        switch (this.idType) {
            case INSTANCE_NODE_ID: {
                this.fullIdString = instanceIdPart;
                break;
            }
            case LOGICAL_NODE_ID: {
                this.fullIdString = String.valueOf(instanceIdPart) + ":" + this.logicalNodePart;
                break;
            }
            case INSTANCE_NODE_SESSION_ID: {
                this.fullIdString = String.valueOf(instanceIdPart) + ":" + ":" + sessionIdPart;
                break;
            }
            case LOGICAL_NODE_SESSION_ID: {
                this.fullIdString = String.valueOf(instanceIdPart) + ":" + this.logicalNodePart + ":" + sessionIdPart;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.checkBasicInternalConsistency();
    }

    protected NodeIdentifierImpl(String instanceIdPart, String logicalNodePart, String sessionIdPart, String fullIdString, NodeNameResolver nodeNameResolver, IdType type) {
        this.instanceIdPart = instanceIdPart;
        this.sessionIdPart = sessionIdPart;
        this.logicalNodePart = logicalNodePart;
        this.fullIdString = fullIdString;
        this.nodeNameResolver = nodeNameResolver;
        this.idType = type;
        this.checkBasicInternalConsistency();
    }

    @Override
    public IdType getType() {
        return this.idType;
    }

    public String getFullIdString() {
        return this.fullIdString;
    }

    @Override
    public String getInstanceNodeIdString() {
        return this.instanceIdPart;
    }

    @Override
    public String getSessionIdPart() {
        return this.sessionIdPart;
    }

    @Override
    public String getLogicalNodePart() {
        return this.logicalNodePart;
    }

    @Override
    public String getInstanceNodeSessionIdString() {
        switch (this.idType) {
            case INSTANCE_NODE_SESSION_ID: {
                return this.fullIdString;
            }
            case LOGICAL_NODE_SESSION_ID: {
                return String.valueOf(this.instanceIdPart) + ":" + ":" + this.sessionIdPart;
            }
        }
        throw this.newInvalidIdTypeForThisCallException();
    }

    @Override
    public String getLogicalNodeIdString() {
        if (this.idType != IdType.LOGICAL_NODE_ID) {
            throw this.newInvalidIdTypeForThisCallException();
        }
        return this.fullIdString;
    }

    @Override
    public String getLogicalNodeSessionIdString() {
        if (this.idType != IdType.LOGICAL_NODE_SESSION_ID) {
            throw this.newInvalidIdTypeForThisCallException();
        }
        return this.fullIdString;
    }

    @Override
    public String getLogicalNodeRecognitionPart() {
        if (this.idType != IdType.LOGICAL_NODE_ID && this.idType != IdType.LOGICAL_NODE_SESSION_ID) {
            throw this.newInvalidIdTypeForThisCallException();
        }
        if (this.isTransientLogicalNode() || "0".equals("0")) {
            return null;
        }
        if (!this.logicalNodePart.startsWith("r")) {
            throw new IllegalStateException("internal consistency error");
        }
        return this.logicalNodePart.substring("r".length());
    }

    @Override
    public InstanceNodeId convertToInstanceNodeId() {
        switch (this.idType) {
            case INSTANCE_NODE_ID: {
                return this;
            }
            case INSTANCE_NODE_SESSION_ID: 
            case LOGICAL_NODE_ID: 
            case LOGICAL_NODE_SESSION_ID: {
                return new NodeIdentifierImpl(this.instanceIdPart, null, null, this.nodeNameResolver, IdType.INSTANCE_NODE_ID);
            }
        }
        throw new IllegalArgumentException(this.idType.toString());
    }

    @Override
    public InstanceNodeSessionId convertToInstanceNodeSessionId() {
        switch (this.idType) {
            case LOGICAL_NODE_SESSION_ID: {
                return new NodeIdentifierImpl(this.instanceIdPart, null, this.sessionIdPart, this.nodeNameResolver, IdType.INSTANCE_NODE_SESSION_ID);
            }
        }
        throw this.newInvalidConversionException(this.idType, IdType.INSTANCE_NODE_SESSION_ID);
    }

    @Override
    public LogicalNodeId convertToLogicalNodeId() {
        switch (this.idType) {
            case LOGICAL_NODE_SESSION_ID: {
                return new NodeIdentifierImpl(this.instanceIdPart, this.logicalNodePart, null, this.nodeNameResolver, IdType.LOGICAL_NODE_ID);
            }
        }
        throw this.newInvalidConversionException(this.idType, IdType.LOGICAL_NODE_ID);
    }

    @Override
    public LogicalNodeId convertToDefaultLogicalNodeId() {
        switch (this.idType) {
            case INSTANCE_NODE_ID: 
            case INSTANCE_NODE_SESSION_ID: 
            case LOGICAL_NODE_ID: {
                return new NodeIdentifierImpl(this.instanceIdPart, "0", null, this.nodeNameResolver, IdType.LOGICAL_NODE_ID);
            }
            case LOGICAL_NODE_SESSION_ID: {
                throw new RuntimeException("Invalid conversion attempt to 'default' logical node id: " + this);
            }
        }
        throw this.newInvalidConversionException(this.idType, IdType.LOGICAL_NODE_ID);
    }

    @Override
    public LogicalNodeId expandToLogicalNodeId(String nodeIdPart) {
        if (this.idType != IdType.INSTANCE_NODE_ID) {
            throw this.newInvalidIdTypeForThisCallException();
        }
        return new NodeIdentifierImpl(this.instanceIdPart, nodeIdPart, null, this.nodeNameResolver, IdType.LOGICAL_NODE_ID);
    }

    @Override
    public LogicalNodeSessionId expandToLogicalNodeSessionId(String nodeIdPart) {
        if (this.idType != IdType.INSTANCE_NODE_SESSION_ID) {
            throw this.newInvalidIdTypeForThisCallException();
        }
        return new NodeIdentifierImpl(this.instanceIdPart, nodeIdPart, this.sessionIdPart, this.nodeNameResolver, IdType.LOGICAL_NODE_SESSION_ID);
    }

    @Override
    public LogicalNodeSessionId convertToDefaultLogicalNodeSessionId() {
        switch (this.idType) {
            case INSTANCE_NODE_SESSION_ID: {
                return new NodeIdentifierImpl(this.instanceIdPart, "0", this.sessionIdPart, this.nodeNameResolver, IdType.LOGICAL_NODE_SESSION_ID);
            }
            case LOGICAL_NODE_ID: 
            case LOGICAL_NODE_SESSION_ID: {
                throw new RuntimeException("Invalid conversion attempt to 'default' logical node id: " + this);
            }
        }
        throw this.newInvalidConversionException(this.idType, IdType.LOGICAL_NODE_SESSION_ID);
    }

    @Override
    public LogicalNodeSessionId combineWithInstanceNodeSessionId(InstanceNodeSessionId instanceSessionId) {
        if (this.idType != IdType.LOGICAL_NODE_ID) {
            throw this.newInvalidIdTypeForThisCallException();
        }
        if (!this.getInstanceNodeIdString().equals(instanceSessionId.getInstanceNodeIdString())) {
            ConsistencyChecks.reportFailure((String)("The ids to combine cannot refer to different instances! " + this + " / " + instanceSessionId));
        }
        return new NodeIdentifierImpl(this.instanceIdPart, this.logicalNodePart, instanceSessionId.getSessionIdPart(), this.nodeNameResolver, IdType.LOGICAL_NODE_SESSION_ID);
    }

    @Override
    public boolean isTransientLogicalNode() {
        return this.logicalNodePart != null && this.logicalNodePart.startsWith("t");
    }

    @Override
    public boolean isSameInstanceNodeAs(ResolvableNodeId otherId) {
        if (otherId == null) {
            throw new NullPointerException("The id to compare " + this + " against can not be null");
        }
        NodeIdentifierImpl otherIdImpl = (NodeIdentifierImpl)otherId;
        return this.instanceIdPart.equals(otherIdImpl.instanceIdPart);
    }

    @Override
    public boolean isSameInstanceNodeSessionAs(InstanceNodeSessionId otherId) {
        NodeIdentifierImpl otherIdImpl = (NodeIdentifierImpl)otherId;
        ConsistencyChecks.assertTrue((this.idType == IdType.INSTANCE_NODE_SESSION_ID || this.idType == IdType.LOGICAL_NODE_SESSION_ID ? 1 : 0) != 0, (String)"Tried to compare session identity from a non-session identifier");
        if (otherIdImpl.idType != IdType.INSTANCE_NODE_SESSION_ID) {
            ConsistencyChecks.reportFailure((String)("Unexpected parameter type: " + (Object)((Object)otherIdImpl.idType)));
        }
        return this.instanceIdPart.equals(otherIdImpl.instanceIdPart) && this.sessionIdPart.equals(otherIdImpl.sessionIdPart);
    }

    @Override
    public boolean isSameInstanceNodeSessionAs(LogicalNodeSessionId id) {
        return this.isSameInstanceNodeSessionAs(id.convertToInstanceNodeSessionId());
    }

    @Override
    public String getRawAssociatedDisplayName() {
        return this.nodeNameResolver.getDisplayNameForNodeId(this, false);
    }

    @Override
    public String getAssociatedDisplayName() {
        return this.nodeNameResolver.getDisplayNameForNodeId(this, true);
    }

    public boolean equals(Object other) {
        if (other instanceof NodeIdentifierImpl) {
            return this.fullIdString.equals(((NodeIdentifierImpl)other).fullIdString);
        }
        return false;
    }

    public int hashCode() {
        return this.fullIdString.hashCode();
    }

    public String toString() {
        return StringUtils.format((String)"\"%s\" [%s]", (Object[])new Object[]{this.getAssociatedDisplayName(), this.fullIdString});
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(this.idType.ordinal());
        out.writeUTF(this.fullIdString);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.tempDeserializationTypeMarker = in.readByte();
        this.tempDeserializationString = in.readUTF();
    }

    private Object readResolve() throws ObjectStreamException {
        NodeIdentifierImpl actualImmutableInstance;
        if (this.tempDeserializationString == null) {
            throw new IllegalStateException("Expected transient deserialization data");
        }
        try {
            IdType targetIdType = IdType.values()[this.tempDeserializationTypeMarker];
            NodeIdentifierService service = NodeIdentifierContextHolder.getDeserializationServiceForCurrentThread();
            actualImmutableInstance = (NodeIdentifierImpl)service.parseSelectableTypeIdString(this.tempDeserializationString, targetIdType);
        }
        catch (IdentifierException e) {
            throw new InvalidObjectException("Deserialization failure: " + e);
        }
        this.tempDeserializationString = null;
        return actualImmutableInstance;
    }

    private Matcher matchRegexpOrFail(Pattern pattern, String input, IdType type) throws IdentifierException {
        Matcher matcher = pattern.matcher(input);
        if (!matcher.matches()) {
            throw new IdentifierException("'" + input + "' cannot be parsed to a valid " + (Object)((Object)type));
        }
        return matcher;
    }

    private void checkBasicInternalConsistency() {
        boolean isValid;
        int fullIdLength = this.fullIdString.length();
        switch (this.idType) {
            case INSTANCE_NODE_ID: {
                isValid = this.instanceIdPart != null && this.logicalNodePart == null && this.sessionIdPart == null && fullIdLength == 32;
                break;
            }
            case INSTANCE_NODE_SESSION_ID: {
                isValid = this.instanceIdPart != null && this.logicalNodePart == null && this.sessionIdPart != null && fullIdLength == 44;
                break;
            }
            case LOGICAL_NODE_ID: {
                isValid = this.instanceIdPart != null && this.logicalNodePart != null && this.sessionIdPart == null && fullIdLength >= 33 && fullIdLength <= 67;
                break;
            }
            case LOGICAL_NODE_SESSION_ID: {
                isValid = this.instanceIdPart != null && this.logicalNodePart != null && this.sessionIdPart != null && fullIdLength >= 44 && fullIdLength <= 77;
                break;
            }
            default: {
                isValid = false;
            }
        }
        if (!isValid) {
            throw new IllegalStateException("Internal id consistency error: " + this.toString());
        }
    }

    private RuntimeException newInvalidConversionException(IdType from, IdType to) {
        return new RuntimeException("Converting from " + (Object)((Object)from) + " to " + (Object)((Object)to) + " cannot be done without active resolution; see " + LiveNetworkIdResolutionService.class.getName());
    }

    private IllegalStateException newInvalidIdTypeForThisCallException() {
        return new IllegalStateException("Invalid id type " + (Object)((Object)this.idType) + " for this call; id object: " + this.toString());
    }
}

