/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.timeline;

import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.resources.api.ColorSource;
import de.rcenvironment.core.gui.resources.api.StandardColors;
import de.rcenvironment.core.gui.workflow.view.timeline.AreaChangedListener;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineActivityPart;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineComponentRow;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineView;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineViewConstants;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class TimelineNavigationControl
extends Canvas
implements PaintListener,
MouseMoveListener,
MouseListener {
    private boolean mouseDown = false;
    private final List<AreaChangedListener> areaListeners = new ArrayList<AreaChangedListener>();
    private TimelineComponentRow[] allrows = null;
    private Date workflowStartTime = null;
    private Date workflowEndTime = null;
    private Date visibleStartTime = null;
    private Date visibleEndTime = null;
    private final int sliderLineWidth = 2;
    private POSITION currentChoosedPosition = POSITION.NONE;
    private int startPositionBuffer = 0;
    private final int accuracy = 6;
    private final double timeTextFactor = 5.3;
    private int timeTextWidth;
    private final int defaultTextHeight = 15;

    public TimelineNavigationControl(Composite parent) {
        super(parent, 4);
        this.addPaintListener(this);
        this.addMouseMoveListener(this);
        this.addMouseListener(this);
        FontData fontData = this.getFont().getFontData()[0];
        this.timeTextWidth = (int)(5.3 * (double)fontData.getHeight());
    }

    public Date getVisibleStartTime() {
        return this.visibleStartTime;
    }

    public Date getVisibleEndTime() {
        return this.visibleEndTime;
    }

    public void paintControl(PaintEvent e) {
        if (this.workflowStartTime == null || this.workflowEndTime == null || this.allrows == null || this.allrows.length == 0) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
        int canvasSizeX = this.getSize().x;
        int canvasSizeY = this.getSize().y;
        if (this.allrows != null && this.allrows.length != 0) {
            int rowhigh = (int)((float)canvasSizeY / (float)this.allrows.length);
            int i = 0;
            while (i < this.allrows.length) {
                TimelineComponentRow currentrow = this.allrows[i];
                int j = 0;
                while (j < currentrow.getActivities().length) {
                    TimelineActivityPart currentactivity = currentrow.getActivities()[j];
                    if (currentactivity.getType() != null && currentactivity.getType().getColor() != null) {
                        if (currentactivity.getEndDate() == null) {
                            currentactivity.setEndtime(this.workflowEndTime);
                        }
                        e.gc.setBackground(new Color(null, currentactivity.getType().getPreviewColor()));
                        long startdraw = TimelineView.convertDateToPixel(currentactivity.getDate(), canvasSizeX, this.workflowStartTime, this.workflowEndTime);
                        long enddraw = (long)TimelineView.convertDateToPixel(currentactivity.getEndDate(), canvasSizeX, this.workflowStartTime, this.workflowEndTime) - startdraw;
                        int ystart = i * rowhigh;
                        int yend = (i + 1) * rowhigh - ystart;
                        e.gc.fillRectangle((int)Math.floor(startdraw), ystart, (int)Math.floor(enddraw), yend);
                    }
                    ++j;
                }
                ++i;
            }
            if (this.visibleStartTime == null || this.visibleEndTime == null) {
                return;
            }
            int sliderPositionleft = TimelineView.convertDateToPixel(this.visibleStartTime, canvasSizeX - 2, this.workflowStartTime, this.workflowEndTime) + 2 / 2;
            int sliderPositionRight = TimelineView.convertDateToPixel(this.visibleEndTime, canvasSizeX - 2, this.workflowStartTime, this.workflowEndTime) + 2 / 2;
            if (!this.mouseDown) {
                e.gc.setAlpha(140);
                e.gc.setBackground(ColorManager.getInstance().getSharedColor(TimelineViewConstants.CANVAS_COLOR_SELECTION_AREA));
                e.gc.fillRectangle(sliderPositionleft, -canvasSizeY, sliderPositionRight - sliderPositionleft, 2 * canvasSizeY + 1);
            }
            e.gc.setAlpha(1000);
            e.gc.setForeground(ColorManager.getInstance().getSharedColor((ColorSource)StandardColors.RCE_BLACK));
            e.gc.setLineWidth(2);
            e.gc.drawRectangle(sliderPositionleft, -canvasSizeY, sliderPositionRight - sliderPositionleft, 2 * canvasSizeY + 1);
            SimpleDateFormat dfmt = new SimpleDateFormat("dd.MM.yy");
            int span = 0;
            if (dfmt.format(this.visibleStartTime).equals(dfmt.format(this.visibleEndTime))) {
                dfmt = new SimpleDateFormat("HH:mm:ss");
                span = 7;
            } else {
                dfmt = new SimpleDateFormat("yyyy-MM-dd\nHH:mm:ss");
                span = 15;
            }
            e.gc.drawText(dfmt.format(this.visibleStartTime), sliderPositionleft + 2, canvasSizeY / 2 - span, true);
            e.gc.drawText(dfmt.format(this.visibleEndTime), sliderPositionRight - 2 - this.timeTextWidth, canvasSizeY / 2 - span, true);
        }
    }

    public void setWorflowStartEndTime(Date newWFStartTime, Date newWFEndTime) {
        this.workflowEndTime = newWFEndTime;
        this.workflowStartTime = newWFStartTime;
        this.redraw();
    }

    public void setVisibleArea(Date startVisibleTime, Date endVisibleTime) {
        this.visibleStartTime = startVisibleTime;
        this.visibleEndTime = endVisibleTime;
        this.redraw();
    }

    public void setTimeTableComponentRows(TimelineComponentRow[] rows) {
        this.allrows = rows;
        this.redraw();
    }

    public void mouseMove(MouseEvent e) {
        if (this.visibleStartTime == null || this.visibleEndTime == null) {
            return;
        }
        Cursor cursor = null;
        int sliderPositionleft = TimelineView.convertDateToPixel(this.visibleStartTime, this.getSize().x - 2, this.workflowStartTime, this.workflowEndTime) + 2 / 2;
        int sliderPositionRight = TimelineView.convertDateToPixel(this.visibleEndTime, this.getSize().x - 2, this.workflowStartTime, this.workflowEndTime) + 2 / 2;
        if (e.x > sliderPositionleft - 12 && e.x < sliderPositionleft + 12 || e.x > sliderPositionRight - 12 && e.x < sliderPositionRight + 12 || this.currentChoosedPosition == POSITION.LEFT || this.currentChoosedPosition == POSITION.RIGHT) {
            cursor = new Cursor((Device)this.getDisplay(), 9);
        } else if (e.x > sliderPositionleft && e.x < sliderPositionRight) {
            cursor = new Cursor((Device)this.getDisplay(), 5);
        }
        if (this.currentChoosedPosition == POSITION.NONE) {
            this.setCursor(cursor);
        }
        this.setNewPosition(e.x, this.currentChoosedPosition);
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    private void setNewPosition(int x, POSITION position) {
        if (this.visibleStartTime == null || this.visibleEndTime == null) {
            return;
        }
        int sliderPositionleft = TimelineView.convertDateToPixel(this.visibleStartTime, this.getSize().x - 2, this.workflowStartTime, this.workflowEndTime) + 2 / 2;
        int sliderPositionRight = TimelineView.convertDateToPixel(this.visibleEndTime, this.getSize().x - 2, this.workflowStartTime, this.workflowEndTime) + 2 / 2;
        switch (position) {
            case LEFT: {
                if (x - 2 / 2 >= sliderPositionRight - 2) {
                    return;
                }
                if (x - 2 / 2 < 0) {
                    x = 2 / 2;
                }
                this.visibleStartTime = TimelineView.convertPixelToDate(x - 2 / 2, this.getSize().x - 2, this.workflowStartTime, this.workflowEndTime);
                break;
            }
            case RIGHT: {
                if (x - 2 / 2 <= sliderPositionleft + 2) {
                    return;
                }
                if (x - 2 / 2 > this.getSize().x) {
                    x = this.getSize().x - 1;
                }
                this.visibleEndTime = TimelineView.convertPixelToDate(x - 2 / 2, this.getSize().x - 2, this.workflowStartTime, this.workflowEndTime);
                break;
            }
            case MIDDLE: {
                int newsliderPositionRight = sliderPositionRight + (x - 2 / 2 - this.startPositionBuffer);
                int newsliderPositionleft = sliderPositionleft + (x - 2 / 2 - this.startPositionBuffer);
                if (newsliderPositionRight > this.getSize().x - 2 || newsliderPositionleft < -1) {
                    return;
                }
                this.visibleStartTime = TimelineView.convertPixelToDate(newsliderPositionleft + 2 / 2, this.getSize().x - 2, this.workflowStartTime, this.workflowEndTime);
                this.visibleEndTime = TimelineView.convertPixelToDate(newsliderPositionRight + 2 / 2, this.getSize().x - 2, this.workflowStartTime, this.workflowEndTime);
                this.startPositionBuffer = x;
                break;
            }
            default: {
                return;
            }
        }
        this.redraw();
        this.notifyAreaChangeListener();
    }

    public void mouseDown(MouseEvent e) {
        if (this.visibleStartTime == null || this.visibleEndTime == null) {
            return;
        }
        int sliderPositionleft = TimelineView.convertDateToPixel(this.visibleStartTime, this.getSize().x - 2, this.workflowStartTime, this.workflowEndTime) - 2 / 2;
        int sliderPositionRight = TimelineView.convertDateToPixel(this.visibleEndTime, this.getSize().x - 2, this.workflowStartTime, this.workflowEndTime) - 2 / 2;
        if (e.x > sliderPositionleft - 12 && e.x < sliderPositionleft + 12) {
            this.currentChoosedPosition = POSITION.LEFT;
        } else if (e.x > sliderPositionRight - 12 && e.x < sliderPositionRight + 12) {
            this.currentChoosedPosition = POSITION.RIGHT;
        } else if (e.x > sliderPositionleft && e.x < sliderPositionRight) {
            this.currentChoosedPosition = POSITION.MIDDLE;
            this.startPositionBuffer = e.x;
        } else {
            this.currentChoosedPosition = POSITION.NONE;
        }
        this.mouseDown = true;
    }

    public void mouseUp(MouseEvent e) {
        this.setNewPosition(e.x, this.currentChoosedPosition);
        this.currentChoosedPosition = POSITION.NONE;
        this.mouseDown = false;
        this.redraw();
    }

    public void notifyAreaChangeListener() {
        for (AreaChangedListener hl : this.areaListeners) {
            hl.selectedAreaChanged(this.visibleStartTime, this.visibleEndTime);
        }
    }

    public void addAreaChangeListener(AreaChangedListener newListener) {
        this.areaListeners.add(newListener);
    }

    private static enum POSITION {
        LEFT,
        RIGHT,
        MIDDLE,
        NONE;

    }
}

