/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.console;

import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import de.rcenvironment.core.gui.workflow.view.console.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class CopyToClipboardHelper {
    public static final String COPY_MESSAGE = "CopyMessage";
    public static final String COPY_LINE = "CopyLine";
    private TableViewer tableViewer;

    public CopyToClipboardHelper(TableViewer aTableViewer) {
        this.tableViewer = aTableViewer;
    }

    public void copyToClipboard(String copyEvent) {
        ISelection selection = this.tableViewer.getSelection();
        ArrayList<ConsoleRow> consoleRows = new ArrayList<ConsoleRow>();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (ConsoleRow row : sel) {
                consoleRows.add(row);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (copyEvent.contains(Messages.copyMessage) || copyEvent.equals(COPY_MESSAGE)) {
            for (ConsoleRow row : consoleRows) {
                sb.append(String.valueOf(row.getPayload()) + System.getProperty("line.separator"));
            }
        } else if (copyEvent.contains(Messages.copyLine) || copyEvent.equals(COPY_LINE)) {
            for (ConsoleRow row : consoleRows) {
                sb.append(row + System.getProperty("line.separator"));
            }
        }
        ClipboardHelper.setContent((String)sb.toString());
    }
}

