/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.connections;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.gui.workflow.editor.connections.ConnectionDialogComposite;
import de.rcenvironment.core.gui.workflow.editor.connections.Messages;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ConnectionsSection
extends AbstractPropertySection {
    private static final int MINIMUM_HEIGHT_OF_CONNECTION_COMPOSITE = 300;
    private static final String IS_EXACTLY = "match exactly";
    private static final String STARTS_WITH = "start with";
    private static final String CONTAINS = "contain";
    private WorkflowDescription workflowDescription;
    private ConnectionDialogComposite connectionDialogComposite;
    private WorkflowDescriptionPropertyListener workflowDescriptionPropertyListener;
    private WorkflowEditor editor;
    private TabbedPropertySheetPage sheetPage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (part instanceof WorkflowEditor && this.connectionDialogComposite.getWorkflowDescription() == null) {
            this.editor = (WorkflowEditor)part;
            ConnectionsSection connectionsSection = this;
            synchronized (connectionsSection) {
                this.workflowDescription = this.editor.getWorkflowDescription();
                this.editor.addPropertyListener(new IPropertyListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void propertyChanged(Object obj, int prop) {
                        if (prop == 768) {
                            ConnectionsSection connectionsSection = ConnectionsSection.this;
                            synchronized (connectionsSection) {
                                if (ConnectionsSection.this.workflowDescription != ConnectionsSection.this.editor.getWorkflowDescription()) {
                                    ConnectionsSection.this.workflowDescription = ConnectionsSection.this.editor.getWorkflowDescription();
                                    ConnectionsSection.this.connectionDialogComposite.updateConnectionViewer(ConnectionsSection.this.workflowDescription);
                                }
                            }
                        }
                    }
                });
                this.connectionDialogComposite.initialize(this.workflowDescription, null, null);
                this.connectionDialogComposite.getCanvas().setEditorsCommandStack(this.editor.getEditorsCommandStack());
                this.connectionDialogComposite.setCommandStack(this.editor.getEditorsCommandStack());
            }
        }
        if (this.workflowDescriptionPropertyListener == null) {
            this.workflowDescriptionPropertyListener = new WorkflowDescriptionPropertyListener();
            if (this.workflowDescription != null) {
                this.workflowDescription.addPropertyChangeListener((PropertyChangeListener)this.workflowDescriptionPropertyListener);
            }
        }
    }

    private void setSizeOfConnectionComposite(Composite parent) {
        if (!parent.isDisposed() && !this.connectionDialogComposite.isDisposed()) {
            if (parent.getSize().y < 300) {
                ((GridData)this.connectionDialogComposite.getLayoutData()).heightHint = 300;
            } else {
                ((GridData)this.connectionDialogComposite.getLayoutData()).heightHint = parent.getSize().y - 125;
                this.connectionDialogComposite.update();
            }
        }
    }

    public void aboutToBeShown() {
        this.connectionDialogComposite.markSectionAsInitialized();
    }

    public void refresh() {
        this.setSizeOfConnectionComposite(this.connectionDialogComposite.getParent());
        super.refresh();
    }

    public void dispose() {
        if (this.workflowDescription != null) {
            this.workflowDescription.removePropertyChangeListener((PropertyChangeListener)this.workflowDescriptionPropertyListener);
        }
        super.dispose();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.connectionDialogComposite = new ConnectionDialogComposite(parent, 0);
        this.sheetPage = aTabbedPropertySheetPage;
        GridLayout gridLayout = new GridLayout();
        parent.setLayout((Layout)gridLayout);
        GridData gridDataParentComposite = new GridData();
        gridDataParentComposite.horizontalAlignment = 4;
        gridDataParentComposite.verticalAlignment = 4;
        gridDataParentComposite.grabExcessHorizontalSpace = true;
        gridDataParentComposite.grabExcessVerticalSpace = true;
        parent.setLayoutData((Object)gridDataParentComposite);
        GridLayout gridLayoutComposite = new GridLayout(3, false);
        gridLayoutComposite.horizontalSpacing = 0;
        gridLayoutComposite.marginWidth = 0;
        gridLayoutComposite.marginHeight = 0;
        this.connectionDialogComposite.setLayout((Layout)gridLayoutComposite);
        GridData gridDataConnectionComposite = new GridData();
        gridDataConnectionComposite.horizontalAlignment = 4;
        gridDataConnectionComposite.verticalAlignment = 4;
        gridDataConnectionComposite.grabExcessHorizontalSpace = true;
        gridDataConnectionComposite.grabExcessVerticalSpace = true;
        this.connectionDialogComposite.setLayoutData(gridDataConnectionComposite);
        GridData gridDataTargetFilterText = new GridData();
        gridDataTargetFilterText.grabExcessHorizontalSpace = true;
        gridDataTargetFilterText.horizontalAlignment = 4;
        gridDataTargetFilterText.horizontalSpan = 3;
        GridData gridDataTargetFilterModeGroup = new GridData();
        gridDataTargetFilterModeGroup.grabExcessHorizontalSpace = true;
        gridDataTargetFilterModeGroup.horizontalAlignment = 4;
        Group targetFilterModeGroup = new Group((Composite)this.connectionDialogComposite.getTargetGroup(), 0);
        targetFilterModeGroup.setText("Keep components that ... ");
        targetFilterModeGroup.setLayout((Layout)new GridLayout(3, true));
        targetFilterModeGroup.setLayoutData((Object)gridDataTargetFilterModeGroup);
        Button targetFilterModeButtonIsExactly = new Button((Composite)targetFilterModeGroup, 16);
        targetFilterModeButtonIsExactly.setText(IS_EXACTLY);
        Button targetFilterModeButtonStartsWith = new Button((Composite)targetFilterModeGroup, 16);
        targetFilterModeButtonStartsWith.setText(STARTS_WITH);
        Button targetFilterModeButtonContains = new Button((Composite)targetFilterModeGroup, 16);
        targetFilterModeButtonContains.setText(CONTAINS);
        targetFilterModeButtonContains.setSelection(true);
        final Text targetFilterText = new Text((Composite)targetFilterModeGroup, 2052);
        targetFilterText.setMessage(Messages.filter);
        targetFilterText.setToolTipText(Messages.filterTooltip);
        targetFilterText.setLayoutData((Object)gridDataTargetFilterText);
        TargetFilterModeSelectionListener targetListener = new TargetFilterModeSelectionListener();
        targetFilterModeButtonContains.addSelectionListener((SelectionListener)targetListener);
        targetFilterModeButtonStartsWith.addSelectionListener((SelectionListener)targetListener);
        targetFilterModeButtonIsExactly.addSelectionListener((SelectionListener)targetListener);
        targetFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionsSection.this.connectionDialogComposite.setTargetFilterString(targetFilterText.getText());
                ConnectionsSection.this.connectionDialogComposite.applyTargetFilter();
            }
        });
        GridData gridDataSourceFilterText = new GridData();
        gridDataSourceFilterText.grabExcessHorizontalSpace = true;
        gridDataSourceFilterText.horizontalAlignment = 4;
        gridDataSourceFilterText.horizontalSpan = 3;
        GridData gridDataSourceFilterModeGroup = new GridData();
        gridDataSourceFilterModeGroup.grabExcessHorizontalSpace = true;
        gridDataSourceFilterModeGroup.horizontalAlignment = 4;
        Group sourceFilterModeGroup = new Group((Composite)this.connectionDialogComposite.getSourceGroup(), 0);
        sourceFilterModeGroup.setText("Keep components that ... ");
        sourceFilterModeGroup.setLayout((Layout)new GridLayout(3, true));
        sourceFilterModeGroup.setLayoutData((Object)gridDataSourceFilterModeGroup);
        Button sourceFilterModeButtonIsExactly = new Button((Composite)sourceFilterModeGroup, 16);
        sourceFilterModeButtonIsExactly.setText(IS_EXACTLY);
        Button sourceFilterModeButtonStartsWith = new Button((Composite)sourceFilterModeGroup, 16);
        sourceFilterModeButtonStartsWith.setText(STARTS_WITH);
        Button sourceFilterModeButtonContains = new Button((Composite)sourceFilterModeGroup, 16);
        sourceFilterModeButtonContains.setText(CONTAINS);
        sourceFilterModeButtonContains.setSelection(true);
        final Text sourceFilterText = new Text((Composite)sourceFilterModeGroup, 2052);
        sourceFilterText.setMessage(Messages.filter);
        sourceFilterText.setToolTipText(Messages.filterTooltip);
        sourceFilterText.setLayoutData((Object)gridDataSourceFilterText);
        SourceFilterModeSelectionListener sourceListener = new SourceFilterModeSelectionListener();
        sourceFilterModeButtonContains.addSelectionListener((SelectionListener)sourceListener);
        sourceFilterModeButtonStartsWith.addSelectionListener((SelectionListener)sourceListener);
        sourceFilterModeButtonIsExactly.addSelectionListener((SelectionListener)sourceListener);
        sourceFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionsSection.this.connectionDialogComposite.setSourceFilterString(sourceFilterText.getText());
                ConnectionsSection.this.connectionDialogComposite.applySourceFilter();
            }
        });
        aTabbedPropertySheetPage.getControl().addControlListener((ControlListener)new ConnectionSectionResizeListener());
        this.connectionDialogComposite.setSourceFilterMode(ConnectionDialogComposite.FilterMode.CONTAINS);
        this.connectionDialogComposite.applySourceFilter();
        this.connectionDialogComposite.setTargetFilterMode(ConnectionDialogComposite.FilterMode.CONTAINS);
        this.connectionDialogComposite.applyTargetFilter();
        super.createControls(parent, aTabbedPropertySheetPage);
    }

    private final class ConnectionSectionResizeListener
    implements ControlListener {
        private ConnectionSectionResizeListener() {
        }

        public void controlResized(ControlEvent arg0) {
            ConnectionsSection.this.setSizeOfConnectionComposite((Composite)ConnectionsSection.this.sheetPage.getControl());
        }

        public void controlMoved(ControlEvent arg0) {
        }
    }

    private class SourceFilterModeSelectionListener
    implements SelectionListener {
        private SourceFilterModeSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            Button button = (Button)event.widget;
            if (button.getText().equals(ConnectionsSection.CONTAINS)) {
                ConnectionsSection.this.connectionDialogComposite.setSourceFilterMode(ConnectionDialogComposite.FilterMode.CONTAINS);
                ConnectionsSection.this.connectionDialogComposite.applySourceFilter();
            } else if (button.getText().equals(ConnectionsSection.STARTS_WITH)) {
                ConnectionsSection.this.connectionDialogComposite.setSourceFilterMode(ConnectionDialogComposite.FilterMode.STARTSWITH);
                ConnectionsSection.this.connectionDialogComposite.applySourceFilter();
            } else if (button.getText().equals(ConnectionsSection.IS_EXACTLY)) {
                ConnectionsSection.this.connectionDialogComposite.setSourceFilterMode(ConnectionDialogComposite.FilterMode.ISEXACTLY);
                ConnectionsSection.this.connectionDialogComposite.applySourceFilter();
            }
        }
    }

    private class TargetFilterModeSelectionListener
    implements SelectionListener {
        private TargetFilterModeSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            Button button = (Button)event.widget;
            if (button.getText().equals(ConnectionsSection.CONTAINS)) {
                ConnectionsSection.this.connectionDialogComposite.setTargetFilterMode(ConnectionDialogComposite.FilterMode.CONTAINS);
                ConnectionsSection.this.connectionDialogComposite.applyTargetFilter();
            } else if (button.getText().equals(ConnectionsSection.STARTS_WITH)) {
                ConnectionsSection.this.connectionDialogComposite.setTargetFilterMode(ConnectionDialogComposite.FilterMode.STARTSWITH);
                ConnectionsSection.this.connectionDialogComposite.applyTargetFilter();
            } else if (button.getText().equals(ConnectionsSection.IS_EXACTLY)) {
                ConnectionsSection.this.connectionDialogComposite.setTargetFilterMode(ConnectionDialogComposite.FilterMode.ISEXACTLY);
                ConnectionsSection.this.connectionDialogComposite.applyTargetFilter();
            }
        }
    }

    private final class WorkflowDescriptionPropertyListener
    implements PropertyChangeListener {
        private WorkflowDescriptionPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("de.rcenvironment.wf.n_cn") && !ConnectionsSection.this.connectionDialogComposite.isDisposed()) {
                ConnectionsSection.this.connectionDialogComposite.updateConnectionViewer(ConnectionsSection.this.workflowDescription);
            }
        }
    }
}

