/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.EndpointContentProvider;
import de.rcenvironment.core.gui.workflow.editor.properties.Messages;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class EndpointHandlingHelper {
    private EndpointHandlingHelper() {
    }

    public static Collection<EndpointContentProvider.Endpoint> getEndpoints(WorkflowNode workflowNode, EndpointType type) {
        HashSet<EndpointContentProvider.Endpoint> endpoints = new HashSet<EndpointContentProvider.Endpoint>();
        for (EndpointDescription endpointDesc : EndpointHandlingHelper.getEndpointDefinitions(workflowNode, type).getEndpointDescriptions()) {
            endpoints.add(new EndpointContentProvider.Endpoint(workflowNode, endpointDesc));
        }
        return endpoints;
    }

    private static EndpointDescriptionsManager getEndpointDefinitions(WorkflowNode workflowNode, EndpointType type) {
        if (type == EndpointType.INPUT) {
            return workflowNode.getComponentDescription().getInputDescriptionsManager();
        }
        return workflowNode.getComponentDescription().getOutputDescriptionsManager();
    }

    public static boolean editEndpointDataType(EndpointType endpointType, EndpointDescription oldDesc, DataType newDataType) {
        if (oldDesc.getDataType() != newDataType && !oldDesc.isDataTypeValid(newDataType)) {
            String source = Messages.input;
            String target = Messages.output;
            if (endpointType == EndpointType.OUTPUT) {
                source = target;
                target = Messages.input;
            }
            if (!MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.invalidDataTypeDialogTitle, (String)StringUtils.format((String)Messages.invalidDataTypeDialogMessage, (Object[])new Object[]{source, oldDesc.getName(), target.toLowerCase(), oldDesc.getName(), oldDesc.getDataType(), newDataType}))) {
                return false;
            }
        }
        return true;
    }
}

