/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.execution.api.ComponentExecutionService;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ConsoleRowUtils;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.workflow.api.WorkflowConstants;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowStateNotificationSubscriber;
import de.rcenvironment.core.component.workflow.execution.spi.SingleWorkflowStateChangeListener;
import de.rcenvironment.core.gui.workflow.Messages;
import de.rcenvironment.core.gui.workflow.UncompletedJobsShutdownListener;
import de.rcenvironment.core.notification.DefaultNotificationSubscriber;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;

final class ActiveWorkflowShutdownListener
implements IWorkbenchListener {
    private static final String WORKFLOW_HANDLE_ERROR = "Failed to handle active workflows during shutdown";
    private static final Log LOGGER = LogFactory.getLog(ActiveWorkflowShutdownListener.class);

    ActiveWorkflowShutdownListener() {
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        boolean shutdown = true;
        HashMap<String, WorkflowState> wfStates = new HashMap<String, WorkflowState>();
        HashMap<String, ComponentState> compStates = new HashMap<String, ComponentState>();
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
        final WorkflowExecutionService wfExeService = (WorkflowExecutionService)serviceRegistryAccess.getService(WorkflowExecutionService.class);
        final Set localWfExeInfosSnapshot = wfExeService.getLocalWorkflowExecutionInformations();
        Set<WorkflowExecutionInformation> localActiveWfExeInfosSnapshot = this.getActiveWorkflows(localWfExeInfosSnapshot, wfStates);
        ComponentExecutionService compExeService = (ComponentExecutionService)serviceRegistryAccess.getService(ComponentExecutionService.class);
        Set localCompExeInfosSnapshot = compExeService.getLocalComponentExecutionInformations();
        Set<ComponentExecutionInformation> localActiveCompExeInfosSnapshot = this.getActiveComponents(compExeService, localCompExeInfosSnapshot, compStates);
        boolean wfOrCompActive = localActiveWfExeInfosSnapshot.size() > 0 || localActiveCompExeInfosSnapshot.size() > 0;
        try {
            if (!forced && wfOrCompActive) {
                int lines = 0;
                HashSet<String> activeWfExeIds = new HashSet<String>();
                String message = "\n";
                message = String.valueOf(message) + "\nWorkflows:\n";
                for (WorkflowExecutionInformation wfExeInfo : localActiveWfExeInfosSnapshot) {
                    message = String.valueOf(message) + StringUtils.format((String)"- %s -> %s\n", (Object[])new Object[]{wfExeInfo.getInstanceName(), ((WorkflowState)wfStates.get(wfExeInfo.getExecutionIdentifier())).getDisplayName()});
                    activeWfExeIds.add(wfExeInfo.getExecutionIdentifier());
                    if (++lines <= 10) continue;
                    message = String.valueOf(message) + "...\n";
                    break;
                }
                if (lines == 0) {
                    message = String.valueOf(message) + "-\n";
                }
                int workflowLines = lines;
                message = String.valueOf(message) + "\nComponents:\n";
                for (ComponentExecutionInformation compExeInfo : localActiveCompExeInfosSnapshot) {
                    if (activeWfExeIds.contains(compExeInfo.getWorkflowExecutionIdentifier())) continue;
                    message = String.valueOf(message) + StringUtils.format((String)"- %s (%s) -> %s\n", (Object[])new Object[]{compExeInfo.getInstanceName(), compExeInfo.getWorkflowInstanceName(), ((ComponentState)compStates.get(compExeInfo.getExecutionIdentifier())).getDisplayName()});
                    if (++lines <= 15) continue;
                    message = String.valueOf(message) + "...\n";
                    break;
                }
                if (workflowLines == lines) {
                    message = String.valueOf(message) + "-\n";
                }
                shutdown = MessageDialog.openQuestion((Shell)workbench.getActiveWorkbenchWindow().getShell(), (String)Messages.activeWorkflowsTitle, (String)(String.valueOf(Messages.activeWorkflowsMessage) + message));
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error((Object)WORKFLOW_HANDLE_ERROR, (Throwable)e);
        }
        if (shutdown && wfOrCompActive) {
            final DistributedNotificationService notificationService = (DistributedNotificationService)serviceRegistryAccess.getService(DistributedNotificationService.class);
            Job job = new Job("Cancel and dispose all active workflows"){

                protected IStatus run(IProgressMonitor monitor) {
                    ArrayList<String> cancelledDisposedWfExeIds = new ArrayList<String>();
                    CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(Void.class);
                    for (WorkflowExecutionInformation wfExeInfo : localWfExeInfosSnapshot) {
                        final WorkflowExecutionInformation finalWfExeInfo = wfExeInfo;
                        if (cancelledDisposedWfExeIds.contains(finalWfExeInfo.getExecutionIdentifier())) continue;
                        callablesGroup.add((Callable)new Callable<Void>(){

                            @Override
                            @TaskDescription(value="Call method of workflow component")
                            public Void call() throws Exception {
                                ActiveWorkflowShutdownListener.this.cancelAndDisposeWorkflow(wfExeService, notificationService, finalWfExeInfo);
                                return null;
                            }
                        }, "Cancel/dispose workflow: " + finalWfExeInfo.getExecutionIdentifier());
                        cancelledDisposedWfExeIds.add(finalWfExeInfo.getExecutionIdentifier());
                    }
                    callablesGroup.executeParallel(new AsyncExceptionListener(){

                        public void onAsyncException(Exception e) {
                            LOGGER.error((Object)"Failed to cancel/dispose workflow", (Throwable)e);
                        }
                    });
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family == UncompletedJobsShutdownListener.MUST_BE_COMPLETED_ON_SHUTDOWN_JOB_FAMILY;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        return shutdown;
    }

    private void cancelAndDisposeWorkflow(final WorkflowExecutionService workflowExecutionService, DistributedNotificationService notificationService, final WorkflowExecutionInformation wfExeInfo) {
        final CountDownLatch wfDisposedLatch = new CountDownLatch(2);
        WorkflowStateNotificationSubscriber workflowStateChangeListener = new WorkflowStateNotificationSubscriber(new SingleWorkflowStateChangeListener(){

            public void onWorkflowStateChanged(WorkflowState newState) {
                LOGGER.debug((Object)StringUtils.format((String)"Received state change event for workflow %s: ", (Object[])new Object[]{wfExeInfo.getExecutionIdentifier(), newState.getDisplayName()}));
                switch (newState) {
                    case FINISHED: 
                    case CANCELLED: 
                    case FAILED: 
                    case RESULTS_REJECTED: {
                        try {
                            workflowExecutionService.dispose(wfExeInfo.getWorkflowExecutionHandle());
                        }
                        catch (ExecutionControllerException | RemoteOperationException e) {
                            LOGGER.error((Object)StringUtils.format((String)"Failed to dispose workflow '%s' (%s)", (Object[])new Object[]{wfExeInfo.getInstanceName(), wfExeInfo.getExecutionIdentifier()}), e);
                            wfDisposedLatch.countDown();
                        }
                        break;
                    }
                    case DISPOSED: {
                        wfDisposedLatch.countDown();
                        break;
                    }
                }
            }

            public void onWorkflowNotAliveAnymore(String errorMessage) {
                LOGGER.error((Object)StringUtils.format((String)"Failed to dispose workflow '%s' (%s) - %s", (Object[])new Object[]{wfExeInfo.getInstanceName(), wfExeInfo.getExecutionIdentifier(), errorMessage}));
                wfDisposedLatch.countDown();
            }
        }, wfExeInfo.getExecutionIdentifier());
        try {
            notificationService.subscribe("rce.component.workflow.state:" + wfExeInfo.getExecutionIdentifier(), (NotificationSubscriber)workflowStateChangeListener, (ResolvableNodeId)wfExeInfo.getNodeId());
            notificationService.subscribe(ConsoleRowUtils.composeConsoleNotificationId((LogicalNodeId)wfExeInfo.getNodeId(), (String)wfExeInfo.getExecutionIdentifier()), (NotificationSubscriber)new ConsoleRowSubscriber(wfDisposedLatch), (ResolvableNodeId)wfExeInfo.getNodeId());
            if (!WorkflowConstants.FINAL_WORKFLOW_STATES.contains(wfExeInfo.getWorkflowState())) {
                workflowExecutionService.cancel(wfExeInfo.getWorkflowExecutionHandle());
            } else {
                workflowExecutionService.dispose(wfExeInfo.getWorkflowExecutionHandle());
            }
        }
        catch (ExecutionControllerException | RemoteOperationException e) {
            LOGGER.error((Object)StringUtils.format((String)"Failed to cancel/dispose workflow '%s' (%s): %s", (Object[])new Object[]{wfExeInfo.getExecutionIdentifier(), wfExeInfo.getExecutionIdentifier(), e.getMessage()}));
        }
        try {
            wfDisposedLatch.await();
        }
        catch (InterruptedException e) {
            LOGGER.debug((Object)StringUtils.format((String)"Was interupted when cancelling/disposing workflow '%s' (%s)", (Object[])new Object[]{wfExeInfo.getInstanceName(), wfExeInfo.getExecutionIdentifier()}), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private Set<WorkflowExecutionInformation> getActiveWorkflows(Set<WorkflowExecutionInformation> localWfExeInfos, Map<String, WorkflowState> wfStates) {
        HashSet<WorkflowExecutionInformation> activeWfExeInfos = new HashSet<WorkflowExecutionInformation>();
        Iterator<WorkflowExecutionInformation> iterator = localWfExeInfos.iterator();
        while (iterator.hasNext()) {
            WorkflowExecutionInformation wfExeInfo = iterator.next();
            WorkflowState state = wfExeInfo.getWorkflowState();
            if (!WorkflowConstants.FINAL_WORKFLOW_STATES_WITH_DISPOSED.contains(state)) {
                activeWfExeInfos.add(wfExeInfo);
            }
            if (state == WorkflowState.DISPOSED) {
                iterator.remove();
            }
            wfStates.put(wfExeInfo.getExecutionIdentifier(), state);
        }
        return activeWfExeInfos;
    }

    private Set<ComponentExecutionInformation> getActiveComponents(ComponentExecutionService componentExecutionService, Set<ComponentExecutionInformation> localCompExeInfos, Map<String, ComponentState> compStates) {
        HashSet<ComponentExecutionInformation> activeCompExeInfos = new HashSet<ComponentExecutionInformation>();
        Iterator<ComponentExecutionInformation> iterator = localCompExeInfos.iterator();
        while (iterator.hasNext()) {
            ComponentExecutionInformation compExeInfo = iterator.next();
            try {
                ComponentState state = componentExecutionService.getComponentState(compExeInfo.getExecutionIdentifier(), (ResolvableNodeId)compExeInfo.getNodeId());
                if (!ComponentConstants.FINAL_COMPONENT_STATES_WITH_DISPOSED.contains(state)) {
                    activeCompExeInfos.add(compExeInfo);
                }
                if (state == ComponentState.DISPOSED) {
                    iterator.remove();
                }
                compStates.put(compExeInfo.getExecutionIdentifier(), state);
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                LOGGER.error((Object)StringUtils.format((String)"Failed to get state for component '%s' (%s); cause: %s", (Object[])new Object[]{compExeInfo.getInstanceName(), compExeInfo.getExecutionIdentifier(), e.toString()}));
            }
        }
        return activeCompExeInfos;
    }

    public void postShutdown(IWorkbench workbench) {
    }

    private static class ConsoleRowSubscriber
    extends DefaultNotificationSubscriber {
        private static final long serialVersionUID = 6177970783784847691L;
        private final transient CountDownLatch wfDisposeLatch;

        ConsoleRowSubscriber(CountDownLatch countDownLatch) {
            this.wfDisposeLatch = countDownLatch;
        }

        public Class<?> getInterface() {
            return NotificationSubscriber.class;
        }

        protected void processNotification(Notification notification) {
            Serializable body = notification.getBody();
            if (!(notification.getBody() instanceof ConsoleRow)) {
                LOGGER.error((Object)("Unexpected notification type on ConsoleRow channel: body class is " + body.getClass()));
                return;
            }
            ConsoleRow row = (ConsoleRow)body;
            if (row.getType() == ConsoleRow.Type.LIFE_CYCLE_EVENT) {
                LOGGER.debug((Object)("Received workflow life-cycle event: " + row.getPayload()));
                if (row.getPayload().startsWith(ConsoleRow.WorkflowLifecyleEventType.NEW_STATE.name()) && row.getPayload().endsWith(WorkflowState.DISPOSED.name())) {
                    this.wfDisposeLatch.countDown();
                }
            }
        }
    }
}

