/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view;

import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.gui.palette.PaletteViewStorage;
import de.rcenvironment.core.gui.palette.view.PaletteTreeViewerComparator;
import de.rcenvironment.core.gui.palette.view.PaletteViewActions;
import de.rcenvironment.core.gui.palette.view.PaletteViewContentProvider;
import de.rcenvironment.core.gui.palette.view.PaletteViewLabelProvider;
import de.rcenvironment.core.gui.palette.view.PaletteViewTreeListener;
import de.rcenvironment.core.gui.palette.view.dialogs.ManageCustomGroupsDialog;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.AccessibleComponentNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.CreationToolNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.GroupNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.RootNode;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.editor.LabelFactory;
import de.rcenvironment.core.gui.workflow.editor.PaletteCreationTool;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowNodeLabelConnectionCreateCommand;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.ConnectionCreationTool;
import org.eclipse.gef.tools.PanningSelectionTool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class PaletteView
extends ViewPart
implements IPartListener2,
CommandStackEventListener,
FocusListener,
IContextProvider {
    private static final String WORKFLOW_LABEL_CONTEXT_ID = "de.rcenvironment.workflowLabelContext";
    private static final String PALETTE_CONTEXT_ID = "de.rcenvironment.paletteContext";
    private TreeViewer paletteTreeViewer;
    private PaletteViewContentProvider paletteViewContentProvider;
    private PaletteTreeViewerComparator paletteTreeViewerComparator = new PaletteTreeViewerComparator();
    private PaletteViewActions paletteViewActions;
    private ManageCustomGroupsDialog organizeGroupsDialog = null;
    private CreationToolNode selectionToolNode;
    private CreationToolNode connectionToolNode;
    private boolean showEmptyGroupsChecked = true;
    private ToolIntegrationContextRegistry toolIntegrationRegistry = (ToolIntegrationContextRegistry)ServiceRegistry.createAccessFor((Object)((Object)this)).getService(ToolIntegrationContextRegistry.class);
    private PaletteViewStorage paletteViewStorage;

    public void createPartControl(Composite parent) {
        this.getSite().getPage().addPartListener((IPartListener2)this);
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        this.paletteTreeViewer = new TreeViewer(mainComposite, 2);
        GridData paletteTreeViewerGridData = new GridData(1808);
        this.paletteTreeViewer.getTree().setLayoutData((Object)paletteTreeViewerGridData);
        this.paletteViewContentProvider = new PaletteViewContentProvider(this);
        this.paletteViewActions = new PaletteViewActions(this);
        this.paletteViewStorage = new PaletteViewStorage(this.paletteViewContentProvider);
        this.paletteTreeViewer.setContentProvider((IContentProvider)this.paletteViewContentProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.paletteTreeViewer);
        this.paletteTreeViewer.setLabelProvider((IBaseLabelProvider)new PaletteViewLabelProvider());
        this.paletteTreeViewer.setComparator((ViewerComparator)this.paletteTreeViewerComparator);
        this.paletteTreeViewer.addDoubleClickListener(this.createPaletteViewDoubleClickAdapter());
        this.paletteTreeViewer.getTree().addFocusListener((FocusListener)this);
        this.paletteTreeViewer.setAutoExpandLevel(1);
        this.paletteTreeViewer.getTree().addMenuDetectListener(event -> this.paletteViewActions.updateContextMenu(this.paletteTreeViewer.getTree().getSelection()));
        this.paletteTreeViewer.getTree().addTreeListener((TreeListener)new PaletteViewTreeListener(this.paletteTreeViewer));
        this.paletteTreeViewer.getTree().addSelectionListener(this.createPaletteViewSelectionListener());
        DragSource source = new DragSource((Control)this.paletteTreeViewer.getTree(), 1);
        source.setTransfer(new Transfer[]{TemplateTransfer.getInstance()});
        source.addDragListener((DragSourceListener)new PaletteViewDragSourceListener());
        RootNode root = PaletteTreeNode.createRootNode(this.paletteViewContentProvider);
        this.paletteViewContentProvider.setRootNode(root);
        root.setChildren(this.createEditorToolNodes(root));
        this.paletteTreeViewer.setInput((Object)root);
        this.getSite().setSelectionProvider((ISelectionProvider)this.paletteTreeViewer);
        List<String> expandedGroupList = this.paletteViewStorage.loadFilesFromStorage();
        this.getContentProvider().updateTree(this.getContentProvider().getCurrentToolInstallations(), null);
        this.initExpandedStates(expandedGroupList);
        this.paletteViewActions.createActions();
        this.paletteViewActions.addToolbarItems(toolBarManager);
        this.paletteViewActions.hookContextMenu();
        Optional<WorkflowEditor> editor = this.getWorkflowEditor();
        if (editor.isPresent()) {
            editor.get().getEditorsCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        }
        this.selectSelectionToolNode();
    }

    private PaletteTreeNode[] createEditorToolNodes(PaletteTreeNode root) {
        PanningSelectionTool selectionTool = new PanningSelectionTool();
        Optional<WorkflowEditor> editor = this.getWorkflowEditor();
        if (editor.isPresent()) {
            editor.get().getViewer().getEditDomain().setDefaultTool((Tool)selectionTool);
        }
        this.selectionToolNode = PaletteTreeNode.createBasicToolNode(root, "Select", (Tool)selectionTool, ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ARROW));
        this.selectionToolNode.setShortKey("ALT+S");
        this.connectionToolNode = PaletteTreeNode.createBasicToolNode(root, "Draw Connection", (Tool)new ConnectionCreationTool(), ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CONNECTION_TOOL));
        this.connectionToolNode.setShortKey("ALT+D");
        PaletteCreationTool labelTool = new PaletteCreationTool((CreationFactory)new LabelFactory());
        CreationToolNode labelNode = PaletteTreeNode.createBasicToolNode(root, "Add Label", (Tool)labelTool, ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WORKFLOW_LABEL));
        labelNode.setHelpContextID(WORKFLOW_LABEL_CONTEXT_ID);
        PaletteTreeNode[] nodeList = new PaletteTreeNode[]{this.selectionToolNode, this.connectionToolNode, labelNode};
        return nodeList;
    }

    public void selectSelectionToolNode() {
        this.paletteTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectionToolNode));
        Optional<WorkflowEditor> editor = this.getWorkflowEditor();
        if (editor.isPresent()) {
            editor.get().getViewer().getEditDomain().setActiveTool(this.selectionToolNode.getTool());
        }
        this.setHelp(null);
    }

    public void selectConnectionToolNode() {
        this.paletteTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.connectionToolNode));
        Optional<WorkflowEditor> editor = this.getWorkflowEditor();
        if (editor.isPresent()) {
            editor.get().getViewer().getEditDomain().setActiveTool(this.connectionToolNode.getTool());
        }
        this.setHelp(null);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this);
        this.paletteViewContentProvider.dispose();
        super.dispose();
    }

    private void initExpandedStates(List<String> updatedExpandedGroups) {
        this.paletteTreeViewer.refresh();
        this.paletteTreeViewer.getTree().setVisible(false);
        this.checkAndExpandItems(this.getTreeNodes(), updatedExpandedGroups);
        this.paletteTreeViewer.getTree().setVisible(true);
    }

    private TreeNode[] getTreeNodes() {
        return (TreeNode[])Arrays.stream(this.paletteTreeViewer.getTree().getItems()).map(Widget::getData).filter(TreeNode.class::isInstance).map(TreeNode.class::cast).toArray(TreeNode[]::new);
    }

    private void checkAndExpandItems(TreeNode[] treeNodes, List<String> updatedExpandedGroups) {
        Arrays.stream(treeNodes).filter(GroupNode.class::isInstance).map(GroupNode.class::cast).forEach(node -> {
            this.setExpandedState((GroupNode)node, updatedExpandedGroups.contains(node.getQualifiedGroupName()));
            if (node.hasChildren()) {
                this.checkAndExpandItems(node.getChildren(), updatedExpandedGroups);
            }
        });
    }

    private IDoubleClickListener createPaletteViewDoubleClickAdapter() {
        return e -> {
            IStructuredSelection selection = (IStructuredSelection)e.getSelection();
            if (selection.isEmpty() || ((IStructuredSelection)this.paletteTreeViewer.getSelection()).size() > 1) {
                return;
            }
            PaletteTreeNode node = (PaletteTreeNode)selection.getFirstElement();
            node.handleDoubleclick(this);
        };
    }

    public Optional<WorkflowEditor> getWorkflowEditor() {
        try {
            IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (part instanceof WorkflowEditor) {
                return Optional.of((WorkflowEditor)part);
            }
        }
        catch (NullPointerException nullPointerException) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    private SelectionListener createPaletteViewSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selection = PaletteView.this.paletteTreeViewer.getTree().getSelection();
                if (selection.length == 0) {
                    PaletteView.this.selectSelectionToolNode();
                    return;
                }
                List selectedNodes = Stream.of(selection).map(Widget::getData).filter(PaletteTreeNode.class::isInstance).map(PaletteTreeNode.class::cast).collect(Collectors.toList());
                if (selectedNodes.size() > 1) {
                    List newSelection = selectedNodes.stream().filter(AccessibleComponentNode.class::isInstance).map(AccessibleComponentNode.class::cast).collect(Collectors.toCollection(ArrayList::new));
                    if (newSelection.isEmpty()) {
                        PaletteView.this.paletteTreeViewer.setSelection((ISelection)new StructuredSelection(e.item.getData()));
                    } else {
                        PaletteView.this.paletteTreeViewer.setSelection((ISelection)new StructuredSelection(newSelection));
                    }
                }
                Optional<WorkflowEditor> optional = PaletteView.this.getWorkflowEditor();
                if (selectedNodes.size() == 1) {
                    PaletteView.this.setHelp(((PaletteTreeNode)selectedNodes.get(0)).getHelpContextID().orElse(PaletteView.this.getPaletteHelpID()));
                }
                if (!optional.isPresent()) {
                    return;
                }
                WorkflowEditor editor = optional.get();
                if (selectedNodes.size() == 1) {
                    ((PaletteTreeNode)selectedNodes.get(0)).handleWidgetSelected(editor);
                } else {
                    editor.getViewer().getEditDomain().loadDefaultTool();
                }
            }
        };
    }

    private String getPaletteHelpID() {
        return PALETTE_CONTEXT_ID;
    }

    private void setHelp(String helpID) {
        if (!this.getPaletteTreeViewer().getControl().isDisposed()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getPaletteTreeViewer().getControl(), helpID);
        }
    }

    public List<String> getExpandedGroupNameList() {
        return Stream.of(this.paletteTreeViewer.getExpandedElements()).filter(GroupNode.class::isInstance).map(GroupNode.class::cast).filter(GroupNode::isExpanded).map(PaletteTreeNode::getQualifiedGroupName).collect(Collectors.toList());
    }

    public TreeViewer getPaletteTreeViewer() {
        return this.paletteTreeViewer;
    }

    protected PaletteTreeViewerComparator getPaletteTreeViewerComparator() {
        return this.paletteTreeViewerComparator;
    }

    protected ManageCustomGroupsDialog getOrganizeGroupsDialog() {
        return this.organizeGroupsDialog;
    }

    public void setOrganizeGroupsDialog(ManageCustomGroupsDialog organizeGroupsDialog) {
        this.organizeGroupsDialog = organizeGroupsDialog;
    }

    public void setFocus() {
        this.getPaletteTreeViewer().getControl().setFocus();
    }

    protected void collapseAll() {
        this.paletteTreeViewer.getTree().setVisible(false);
        if (Arrays.stream(this.paletteTreeViewer.getTree().getSelection()).map(Widget::getData).anyMatch(AccessibleComponentNode.class::isInstance)) {
            this.selectSelectionToolNode();
        }
        this.paletteViewContentProvider.setExpandedState(this.getTreeNodes(), false);
        this.paletteTreeViewer.getTree().setVisible(true);
    }

    protected void expandAll() {
        this.paletteTreeViewer.getTree().setVisible(false);
        this.paletteViewContentProvider.setExpandedState(this.getTreeNodes(), true);
        this.paletteTreeViewer.getTree().setVisible(true);
    }

    public void expandToNode(PaletteTreeNode node) {
        ArrayList<PaletteTreeNode> nodesToExpand = new ArrayList<PaletteTreeNode>();
        if (node.isGroup()) {
            nodesToExpand.add(node);
        }
        this.paletteViewContentProvider.addAllParentGroupNodes(node, nodesToExpand);
        nodesToExpand.stream().filter(PaletteTreeNode::isGroup).map(PaletteTreeNode::getGroupNode).forEach(n -> this.setExpandedState((GroupNode)n, true));
        this.paletteTreeViewer.refresh();
    }

    public void setExpandedState(GroupNode node, boolean expanded) {
        if (this.paletteViewContentProvider.isExpandable(node)) {
            this.paletteViewContentProvider.setExpandedState(node, expanded);
        }
    }

    public void partActivated(IWorkbenchPartReference arg0) {
    }

    public void partBroughtToTop(IWorkbenchPartReference arg0) {
        if (arg0.getPart(false) instanceof WorkflowEditor) {
            Object element;
            WorkflowEditor editor = (WorkflowEditor)arg0.getPart(false);
            ITreeSelection selection = this.paletteTreeViewer.getStructuredSelection();
            if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof CreationToolNode) {
                editor.getViewer().getEditDomain().setActiveTool(((CreationToolNode)element).getTool());
            }
            editor.getEditorsCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        }
    }

    public void partClosed(IWorkbenchPartReference arg0) {
        if (arg0.getPart(false).equals((Object)this)) {
            this.paletteViewStorage.storeConfigurationFiles();
            this.selectSelectionToolNode();
        }
    }

    public void partDeactivated(IWorkbenchPartReference arg0) {
    }

    public void partHidden(IWorkbenchPartReference arg0) {
        if (arg0.getPart(false) instanceof WorkflowEditor) {
            WorkflowEditor editor = (WorkflowEditor)arg0.getPart(false);
            editor.getViewer().getEditDomain().setActiveTool(this.selectionToolNode.getTool());
            editor.getEditorsCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
    }

    public void partInputChanged(IWorkbenchPartReference arg0) {
    }

    public void partOpened(IWorkbenchPartReference arg0) {
    }

    public void partVisible(IWorkbenchPartReference arg0) {
    }

    public boolean isShowEmptyGroups() {
        return this.showEmptyGroupsChecked;
    }

    public void setShowEmptyGroups(boolean show) {
        this.showEmptyGroupsChecked = show;
    }

    public void stackChanged(CommandStackEvent evt) {
        if (evt.getDetail() == 1 && evt.getCommand() instanceof WorkflowNodeLabelConnectionCreateCommand) {
            this.selectSelectionToolNode();
        }
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        Optional<WorkflowEditor> editor = this.getWorkflowEditor();
        if (editor.isPresent() && editor.get().getViewer().getEditDomain().getActiveTool() instanceof SelectionTool) {
            this.paletteTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectionToolNode));
        }
    }

    public PaletteViewContentProvider getContentProvider() {
        return this.paletteViewContentProvider;
    }

    public IContext getContext(Object arg0) {
        ITreeSelection selection = this.getPaletteTreeViewer().getStructuredSelection();
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object object = selection.getFirstElement();
        if (object instanceof PaletteTreeNode) {
            PaletteTreeNode node = (PaletteTreeNode)object;
            if (node.getHelpContextID().isPresent()) {
                String helpId = node.getHelpContextID().get();
                if (this.toolIntegrationRegistry.hasTIContextMatchingPrefix(helpId)) {
                    return this.getContextFromHelpSystem("de.rcenvironment.integration.*");
                }
                if (helpId.contains("de.rcenvironment.remoteaccess")) {
                    return this.getContextFromHelpSystem("de.rcenvironment.remoteaccess.*");
                }
                return this.getContextFromHelpSystem(helpId);
            }
            return this.getContextFromHelpSystem(this.getPaletteHelpID());
        }
        return this.getContextFromHelpSystem(this.getPaletteHelpID());
    }

    public int getContextChangeMask() {
        return 1;
    }

    public String getSearchExpression(Object arg0) {
        return null;
    }

    protected IContext getContextFromHelpSystem(String contextId) {
        return HelpSystem.getContext((String)contextId);
    }

    protected Object getSelectionTool() {
        return this.selectionToolNode.getTool();
    }

    private class PaletteViewDragSourceListener
    implements DragSourceListener {
        private PaletteViewDragSourceListener() {
        }

        public void dragFinished(DragSourceEvent evt) {
        }

        public void dragSetData(DragSourceEvent evt) {
            CreationToolNode etNode;
            ITreeSelection selection = PaletteView.this.paletteTreeViewer.getStructuredSelection();
            PaletteTreeNode node = (PaletteTreeNode)selection.getFirstElement();
            if (node.isAccessibleComponent()) {
                PaletteCreationTool tool = node.getAccessibleComponentNode().getTool();
                evt.data = tool.getFactory();
            }
            if (node.isCreationTool() && (etNode = node.getCreationToolNode()).getTool() instanceof PaletteCreationTool) {
                evt.data = ((PaletteCreationTool)etNode.getTool()).getFactory();
            }
        }

        public void dragStart(DragSourceEvent evt) {
            ITreeSelection selection = PaletteView.this.paletteTreeViewer.getStructuredSelection();
            PaletteTreeNode node = (PaletteTreeNode)selection.getFirstElement();
            boolean isWorkfowEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() instanceof WorkflowEditor;
            if (isWorkfowEditor && selection.size() == 1 && (node.isAccessibleComponent() || node.isCreationTool())) {
                evt.image = null;
                evt.doit = node.isCreationTool() ? node.getCreationToolNode().getTool() instanceof PaletteCreationTool : true;
                return;
            }
            evt.doit = false;
        }
    }
}

