/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view;

import de.rcenvironment.core.gui.palette.view.PaletteView;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Arrays;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PaletteToolbarFilterWidget
extends ControlContribution
implements ModifyListener,
KeyListener {
    private static final int FILTER_TEXTFIELD_WIDTH = 100;
    private static final String FILTER_MESSAGE = "Filter components...";
    private PaletteView paletteView;
    private String filterText;
    private ViewerFilter filter;
    private Text filterTextfield;
    private boolean filterSet = false;
    private Object[] expandedElements;

    public PaletteToolbarFilterWidget(PaletteView paletteView) {
        super("de.rcenvironment.core.gui.palette.view.paletteToolbarFilterWidget");
        this.paletteView = paletteView;
    }

    private void createFilter() {
        this.filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object elementObject) {
                PaletteTreeNode element;
                if (!(viewer instanceof StructuredViewer)) {
                    this.throwIllegalTypeException("viewer", viewer.getClass().getCanonicalName(), StructuredViewer.class.getCanonicalName());
                }
                if (!(elementObject instanceof PaletteTreeNode)) {
                    this.throwIllegalTypeException("elementObject", elementObject.getClass().getCanonicalName(), PaletteTreeNode.class.getCanonicalName());
                }
                if ((element = (PaletteTreeNode)elementObject).isCreationTool()) {
                    return true;
                }
                if (element.isGroup() && element.hasChildren()) {
                    return Arrays.stream(element.getChildren()).anyMatch(child -> this.select(viewer, element, child));
                }
                if (element.isAccessibleComponent()) {
                    String compareString = element.getDisplayName();
                    return compareString.toLowerCase().contains(PaletteToolbarFilterWidget.this.filterText.toLowerCase().trim());
                }
                return false;
            }

            private void throwIllegalTypeException(String variableName, String actualClassName, String expectedClassName) {
                throw new IllegalStateException(StringUtils.format((String)"Unexpected type for parameter %s: %s. Expected type: %s", (Object[])new Object[]{variableName, actualClassName, expectedClassName}));
            }
        };
    }

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.marginHeight = 0;
        composite.setLayout((Layout)compositeLayout);
        this.filterTextfield = new Text(composite, 526336);
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 100;
        this.filterTextfield.setLayoutData((Object)layoutData);
        this.filterTextfield.setMessage(FILTER_MESSAGE);
        this.filterTextfield.addModifyListener((ModifyListener)this);
        this.filterTextfield.addKeyListener((KeyListener)this);
        this.createFilter();
        return composite;
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget instanceof Text) {
            Text filterTextField = (Text)e.widget;
            this.filterText = filterTextField.getText();
            if (this.filterText != null && this.filterText.length() > 0) {
                if (!this.filterSet) {
                    this.filterSet = true;
                    this.expandedElements = this.paletteView.getPaletteTreeViewer().getExpandedElements();
                }
                this.paletteView.getPaletteTreeViewer().getTree().setVisible(false);
                this.paletteView.getPaletteTreeViewer().setFilters(new ViewerFilter[]{this.filter});
                this.paletteView.getPaletteTreeViewer().expandAll();
                this.paletteView.getPaletteTreeViewer().refresh();
                this.paletteView.getPaletteTreeViewer().getTree().setVisible(true);
            } else {
                this.paletteView.getPaletteTreeViewer().getTree().setVisible(false);
                this.paletteView.getPaletteTreeViewer().resetFilters();
                this.filterSet = false;
                if (this.expandedElements != null) {
                    this.paletteView.getPaletteTreeViewer().setExpandedElements(this.expandedElements);
                    this.paletteView.getPaletteTreeViewer().refresh();
                }
                this.paletteView.getPaletteTreeViewer().getTree().setVisible(true);
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.character == '\u001b') {
            this.filterTextfield.setText("");
            this.paletteView.getPaletteTreeViewer().getTree().setFocus();
        }
    }
}

