/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.validation.api;

import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ComponentValidationMessageStore {
    private static ComponentValidationMessageStore instance = null;
    private Map<String, List<ComponentValidationMessage>> messageMap = new HashMap<String, List<ComponentValidationMessage>>();

    private ComponentValidationMessageStore() {
    }

    public static ComponentValidationMessageStore getInstance() {
        if (instance == null) {
            instance = new ComponentValidationMessageStore();
        }
        return instance;
    }

    public List<ComponentValidationMessage> getMessagesByComponentId(String componentId) {
        if (!this.messageMap.containsKey(componentId)) {
            this.messageMap.put(componentId, new ArrayList());
        }
        return Collections.unmodifiableList(this.messageMap.get(componentId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValidationMessagesByComponentId(String componentId, List<ComponentValidationMessage> messageList) {
        Map<String, List<ComponentValidationMessage>> map = this.messageMap;
        synchronized (map) {
            this.messageMap.put(componentId, messageList);
        }
    }

    public Map<String, List<ComponentValidationMessage>> getMessageMap() {
        return Collections.unmodifiableMap(this.messageMap);
    }

    public boolean isErrorAndWarningsFree() {
        boolean isEmpty = true;
        for (String componentId : this.messageMap.keySet()) {
            isEmpty = this.messageMap.get(componentId).isEmpty();
            if (!isEmpty) break;
        }
        return isEmpty;
    }

    public void emptyMessageStore() {
        this.messageMap.clear();
    }
}

