/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.component.execution.api.WorkflowGraphHop;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class WorkflowGraphPath
implements Iterable<WorkflowGraphHop>,
Serializable {
    private static final long serialVersionUID = -5971231913876896803L;
    private final Deque<WorkflowGraphHop> deque;

    protected WorkflowGraphPath() {
        this.deque = new ArrayDeque<WorkflowGraphHop>();
    }

    protected WorkflowGraphPath(WorkflowGraphPath other) {
        this.deque = new ArrayDeque<WorkflowGraphHop>(other.deque);
    }

    public static WorkflowGraphPath createEmpty() {
        return new WorkflowGraphPath();
    }

    public static WorkflowGraphPath createCopy(WorkflowGraphPath other) {
        return new WorkflowGraphPath(other);
    }

    public void append(WorkflowGraphHop hop) {
        this.deque.add(hop);
    }

    public WorkflowGraphHop getLast() throws NoSuchElementException {
        return this.deque.getLast();
    }

    @Override
    public Iterator<WorkflowGraphHop> iterator() {
        return this.deque.iterator();
    }

    public int size() {
        return this.deque.size();
    }

    public WorkflowGraphHop poll() {
        return this.deque.poll();
    }

    public WorkflowGraphHop peek() {
        return this.deque.peek();
    }

    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public String toString() {
        return this.deque.stream().map(item -> item.toString()).collect(Collectors.joining(", "));
    }

    public boolean isCircular() {
        if (this.isEmpty()) {
            return false;
        }
        WorkflowGraphHop firstElement = this.peek();
        WorkflowGraphHop lastElement = this.getLast();
        return firstElement.getHopExecutionIdentifier().equals(lastElement.getTargetExecutionIdentifier());
    }
}

