/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.encryption;

import de.rcenvironment.core.utils.encryption.KeyBasedEncryption;
import de.rcenvironment.core.utils.encryption.PassphraseBasedEncryption;
import de.rcenvironment.core.utils.encryption.internal.DefaultEncryption;

public class EncryptionFactory {
    public PassphraseBasedEncryption createPassphraseBasedEncryption(PassphraseBasedEncryptionAlgorithm algorithm) {
        DefaultEncryption encryption;
        switch (algorithm) {
            case AES: {
                encryption = new DefaultEncryption(PassphraseBasedEncryptionAlgorithm.AES);
                break;
            }
            case Blowfish: {
                encryption = new DefaultEncryption(PassphraseBasedEncryptionAlgorithm.Blowfish);
                break;
            }
            default: {
                throw new IllegalArgumentException("desired passphrase-based enryption algorithm not supported: " + algorithm + " -  supported ones are: " + PassphraseBasedEncryptionAlgorithm.AES + ", " + PassphraseBasedEncryptionAlgorithm.Blowfish);
            }
        }
        return encryption;
    }

    public KeyBasedEncryption createKeyBasedEncryption(KeyBasedEncryptionAlgorithm algorithm) {
        DefaultEncryption encryption;
        switch (algorithm) {
            case RSA: {
                encryption = new DefaultEncryption(KeyBasedEncryptionAlgorithm.RSA);
                break;
            }
            default: {
                throw new IllegalArgumentException("desired passphrase-based enryption algorithm not supported: " + algorithm + " -  supported ones are: " + PassphraseBasedEncryptionAlgorithm.AES + ", " + PassphraseBasedEncryptionAlgorithm.Blowfish);
            }
        }
        return encryption;
    }

    public static interface EncryptionAlgorithm {
        public String getName();
    }

    public static enum KeyBasedEncryptionAlgorithm implements EncryptionAlgorithm
    {
        RSA;


        @Override
        public String getName() {
            return this.name();
        }
    }

    public static enum PassphraseBasedEncryptionAlgorithm implements EncryptionAlgorithm
    {
        AES,
        Blowfish;


        @Override
        public String getName() {
            return this.name();
        }
    }
}

