/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.common;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.integration.IntegrationContext;
import de.rcenvironment.core.component.integration.IntegrationContextType;
import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class IntegrationHelper {
    private final ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
    private ToolIntegrationService integrationService = (ToolIntegrationService)this.serviceRegistryAccess.getService(ToolIntegrationService.class);

    public List<String> updateGroupNames(IntegrationContextType contextType) {
        LogicalNodeId localNode = ((PlatformService)this.serviceRegistryAccess.getService(PlatformService.class)).getLocalDefaultLogicalNodeId();
        Collection installations = this.getInitialComponentKnowledge().getAllInstallations();
        installations = ComponentUtils.eliminateComponentInterfaceDuplicates((Collection)installations, (LogicalNodeId)localNode);
        ArrayList<String> groupNames = new ArrayList<String>();
        for (DistributedComponentEntry ci : installations) {
            ComponentInterface componentInterface = ci.getComponentInterface();
            String toolID = componentInterface.getIdentifier();
            if (contextType.equals((Object)IntegrationContextType.WORKFLOW)) {
                if (!toolID.startsWith("de.rcenvironment.integration.workflow") && !toolID.startsWith("workflow")) continue;
                this.addGroupsAndSubgroupsToList(groupNames, componentInterface);
                continue;
            }
            if (!toolID.startsWith("de.rcenvironment.integration.common") && !toolID.startsWith("de.rcenvironment.integration.cpacs") && !toolID.startsWith("common") && !toolID.startsWith("cpacs")) continue;
            this.addGroupsAndSubgroupsToList(groupNames, componentInterface);
        }
        Collections.sort(groupNames, String.CASE_INSENSITIVE_ORDER);
        return groupNames;
    }

    private void addGroupsAndSubgroupsToList(List<String> groupNames, ComponentInterface componentInterface) {
        List<String> groupList = this.getAllSubgroups(componentInterface.getGroupName());
        for (String groupName : groupList) {
            if (groupNames.contains(groupName)) continue;
            groupNames.add(groupName);
        }
    }

    private List<String> getAllSubgroups(String groupPath) {
        ArrayList<String> strList = new ArrayList<String>();
        strList.add(groupPath);
        while (groupPath.contains("/")) {
            int i = groupPath.lastIndexOf("/");
            groupPath = groupPath.substring(0, i);
            strList.add(groupPath);
        }
        return strList;
    }

    public DistributedComponentKnowledge getInitialComponentKnowledge() {
        DistributedComponentKnowledgeService registry = (DistributedComponentKnowledgeService)this.serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class);
        return registry.getCurrentSnapshot();
    }

    public List<String> getAlreadyIntegratedComponentNames() {
        LinkedList<String> toolNames = new LinkedList<String>();
        for (String id : this.integrationService.getIntegratedComponentIds()) {
            toolNames.add(this.integrationService.getToolConfiguration(id).get("toolName").toString());
        }
        return toolNames;
    }

    public Optional<File> tryFindConfigurationFile(IntegrationContext context, File toolFolder) {
        return Arrays.stream(toolFolder.listFiles()).filter(f -> f.getName().equals(context.getConfigurationFilename())).findAny();
    }
}

