/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import de.rcenvironment.core.utils.common.BundleAccessor;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class VersionUtils {
    private static final Class<?> OWN_CLASS = VersionUtils.class;
    private static final BundleAccessor BUNDLE_ACCESSOR = new BundleAccessor(OWN_CLASS);
    private static VersionUtils sharedInstance;
    private final String versionForSshClients;

    private VersionUtils() {
        Version productVersion = VersionUtils.getProductVersion();
        this.versionForSshClients = productVersion != null ? productVersion.toString().replace("qualifier", "dev") : "0.0.0";
    }

    private static synchronized VersionUtils getInstance() {
        if (sharedInstance == null) {
            sharedInstance = new VersionUtils();
        }
        return sharedInstance;
    }

    public static String getVersionForSshClients() {
        return VersionUtils.getInstance().versionForSshClients;
    }

    public static Version getCoreBundleVersion() {
        Bundle ownBundle = BUNDLE_ACCESSOR.getOwnBundleOrLogDebug();
        if (ownBundle == null) {
            return null;
        }
        return ownBundle.getVersion();
    }

    public static Version getPlatformVersion() {
        return VersionUtils.getPlatformVersion(BUNDLE_ACCESSOR, VersionUtils::logError);
    }

    static Version getPlatformVersion(BundleAccessor accessor, Consumer<String> logErrorParam) {
        Set platformVersions = accessor.getPlatformBundles().map(Bundle::getVersion).collect(Collectors.toSet());
        if (platformVersions.isEmpty()) {
            return null;
        }
        if (platformVersions.size() > 1) {
            logErrorParam.accept("Found multiple platform versions: " + platformVersions);
        }
        return (Version)platformVersions.iterator().next();
    }

    public static Version getProductVersion() {
        return VersionUtils.getProductVersion(BUNDLE_ACCESSOR);
    }

    static Version getProductVersion(BundleAccessor accessor) {
        return accessor.getVersionInfoBundle().map(Bundle::getVersion).orElse(null);
    }

    public static String getVersionAsString(Version version) {
        String versionNumber = StringUtils.format("%d.%d.%d", version.getMajor(), version.getMinor(), version.getMicro());
        VersionType versionType = VersionType.fromVersion(version);
        if (versionType.isRelease()) {
            return versionNumber;
        }
        return StringUtils.format("%s_%s", new Object[]{versionNumber, versionType});
    }

    public static String getBuildIdAsString(Version version) {
        if (!VersionType.fromVersion(version).hasBuildId()) {
            return null;
        }
        return version.getQualifier();
    }

    public static boolean isReleaseOrReleaseCandidate() {
        Version version = VersionUtils.getCoreBundleVersion();
        if (version == null) {
            return false;
        }
        VersionType versionType = VersionType.fromVersion(version);
        return versionType.isRelease() || versionType.isReleaseCandidate();
    }

    private static void logError(String message) {
        LogFactory.getLog(OWN_CLASS).error((Object)message);
    }

    private static enum VersionType {
        RELEASE(null, "Release"),
        SNAPSHOT("_SNAPSHOT", "Snapshot"),
        RELEASE_CANDIDATE("_RC", "Release_Candidate"),
        DEVELOPMENT("qualifier", "Development");

        private final String suffix;
        private final String displayName;

        private VersionType(String suffix, String displayName) {
            this.suffix = suffix;
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }

        public boolean isRelease() {
            return this.equals((Object)RELEASE);
        }

        public boolean isReleaseCandidate() {
            return this.equals((Object)RELEASE_CANDIDATE);
        }

        public boolean hasBuildId() {
            return !this.equals((Object)DEVELOPMENT);
        }

        public static VersionType fromVersion(Version version) {
            String qualifier = version.getQualifier();
            if (qualifier.endsWith(VersionType.RELEASE_CANDIDATE.suffix)) {
                return RELEASE_CANDIDATE;
            }
            if (qualifier.endsWith(VersionType.SNAPSHOT.suffix)) {
                return SNAPSHOT;
            }
            if (qualifier.endsWith(VersionType.DEVELOPMENT.suffix)) {
                return DEVELOPMENT;
            }
            return RELEASE;
        }
    }
}

