/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.incubator;

import de.rcenvironment.core.toolkitbridge.transitional.TextStreamWatcherFactory;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.common.textstream.receivers.PrefixingTextOutForwarder;
import de.rcenvironment.core.utils.executor.LocalCommandLineExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GraphvizUtils {
    private GraphvizUtils() {
    }

    public static DotFileBuilder createDotFileBuilder(String graphName) {
        return new DotFileBuilder(graphName);
    }

    public static boolean renderDotFileToPng(File gvFile, File pngFile, TextOutputReceiver outputReceiver) {
        int exitCode;
        block4: {
            LocalCommandLineExecutor executor = new LocalCommandLineExecutor(gvFile.getParentFile());
            executor.setEnv("PATH", System.getenv("PATH"));
            executor.start("dot " + gvFile.getAbsolutePath() + " -Tpng -o " + pngFile.getAbsolutePath());
            PrefixingTextOutForwarder stdoutCapture = new PrefixingTextOutForwarder("StdOut: ", outputReceiver);
            PrefixingTextOutForwarder stderrCapture = new PrefixingTextOutForwarder("StdErr: ", outputReceiver);
            TextStreamWatcher outWatcher = TextStreamWatcherFactory.create((InputStream)executor.getStdout(), (TextOutputReceiver[])new TextOutputReceiver[]{stdoutCapture});
            TextStreamWatcher errWatcher = TextStreamWatcherFactory.create((InputStream)executor.getStderr(), (TextOutputReceiver[])new TextOutputReceiver[]{stderrCapture});
            outWatcher.start();
            errWatcher.start();
            exitCode = executor.waitForTermination();
            if (exitCode != 0) break block4;
            return true;
        }
        try {
            outputReceiver.addOutput("WARNING: Running graphviz returned an exit code of " + exitCode);
        }
        catch (IOException e) {
            outputReceiver.onFatalError((Exception)e);
        }
        catch (InterruptedException e) {
            outputReceiver.onFatalError((Exception)e);
        }
        return false;
    }

    public static class DotFileBuilder {
        private List<String> vertexOrder = new ArrayList<String>();
        private List<String> edgeScriptLines = new ArrayList<String>();
        private Map<String, String> vertexProperties = new HashMap<String, String>();
        private String graphName;

        public DotFileBuilder(String graphName) {
            this.graphName = graphName;
        }

        public void addVertex(String id, String label) {
            this.vertexOrder.add(id);
            this.vertexProperties.put(id, StringUtils.format((String)"label=\"%s\"", (Object[])new Object[]{this.escapeValue(label)}));
        }

        public void addVertexProperty(String id, String key, String value) {
            String oldValue = this.vertexProperties.get(id);
            String newValue = StringUtils.format((String)"%s,%s=\"%s\"", (Object[])new Object[]{oldValue, key, this.escapeValue(value)});
            this.vertexProperties.put(id, newValue);
        }

        public void addEdge(String fromId, String toId, String label) {
            this.edgeScriptLines.add(StringUtils.format((String)"    v_%s->v_%s[label=\"%s\"];\n", (Object[])new Object[]{this.escapeVertexId(fromId), this.escapeVertexId(toId), this.escapeValue(label)}));
        }

        public void addEdge(String fromId, String toId, String label, Map<String, String> properties) {
            String additionalProperties = "";
            if (properties != null) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    additionalProperties = StringUtils.format((String)"%s,%s=\"%s\"", (Object[])new Object[]{additionalProperties, entry.getKey(), this.escapeValue(entry.getValue())});
                }
            }
            this.edgeScriptLines.add(StringUtils.format((String)"    v_%s->v_%s[label=\"%s\"%s];\n", (Object[])new Object[]{this.escapeVertexId(fromId), this.escapeVertexId(toId), this.escapeVertexId(label), additionalProperties}));
        }

        public String getScriptContent() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("digraph ");
            buffer.append(this.graphName);
            buffer.append(" {\n");
            for (String vertexId : this.vertexOrder) {
                buffer.append(StringUtils.format((String)"    v_%s[%s];\n", (Object[])new Object[]{this.escapeVertexId(vertexId), this.vertexProperties.get(vertexId)}));
            }
            for (String edge : this.edgeScriptLines) {
                buffer.append(edge);
            }
            buffer.append("}\n");
            return buffer.toString();
        }

        private String escapeVertexId(String original) {
            if (original == null) {
                throw new NullPointerException();
            }
            String result = original;
            result = result.replaceAll("-", "_");
            return result;
        }

        private String escapeValue(String original) {
            if (original == null) {
                return "<null>";
            }
            String result = original;
            result = result.replaceAll("\"", "\\\\\"");
            return result;
        }
    }
}

