/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.common.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequest;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequestResponse;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionResult;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolDescriptorListUpdate;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.entities.ChannelCreationRequest;
import de.rcenvironment.core.communication.uplink.entities.ChannelCreationResponse;
import de.rcenvironment.core.communication.uplink.entities.FileHeader;
import de.rcenvironment.core.communication.uplink.entities.FileTransferSectionInfo;
import de.rcenvironment.core.communication.uplink.entities.ToolDocumentationRequest;
import de.rcenvironment.core.communication.uplink.entities.ToolDocumentationResponse;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionProviderEventTransferObject;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UplinkProtocolMessageConverter {
    private static final boolean ENABLE_DEBUG_OUTPUT = DebugSettings.getVerboseLoggingEnabled((String)"uplink.conversions");
    private final ObjectMapper jsonMapper = JsonUtils.getDefaultObjectMapper();
    private final boolean debugOutputEnabled;
    private final Log log = LogFactory.getLog(this.getClass());
    private String logIdentity;
    private final TypeReference<HashMap<String, String>> typeReferenceStringKeyValueMap = new TypeReference<HashMap<String, String>>(){};

    public UplinkProtocolMessageConverter(String logIdentity) {
        this.debugOutputEnabled = ENABLE_DEBUG_OUTPUT;
        this.logIdentity = logIdentity;
    }

    public MessageBlock encodeHandshakeData(Map<String, String> dataMap) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.HANDSHAKE, dataMap);
    }

    public Map<String, String> decodeHandshakeData(MessageBlock handshakeData) throws ProtocolException {
        return this.validateAndDecodeJSONMessage(MessageType.HANDSHAKE, this.typeReferenceStringKeyValueMap, handshakeData);
    }

    public MessageBlock encodeErrorGoodbyeMessage(String message) {
        if (StringUtils.isNullorEmpty((String)message)) {
            this.log.warn((Object)"Was requested to encode a null or empty error message; replacing with a placeholder message");
            message = "<no message available>";
        }
        try {
            return new MessageBlock(MessageType.GOODBYE.getCode(), message.getBytes(Charsets.UTF_8));
        }
        catch (ProtocolException protocolException) {
            throw new IllegalStateException("Unexpected internal error: Failed to encode a 'goodbye' error message; message parameter: " + message);
        }
    }

    public MessageBlock encodeToolDescriptorListUpdate(ToolDescriptorListUpdate data) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.TOOL_DESCRIPTOR_LIST_UPDATE, data);
    }

    public ToolDescriptorListUpdate decodeToolDescriptorListUpdate(MessageBlock messageBlock) throws ProtocolException {
        return this.validateAndDecodeJSONMessage(MessageType.TOOL_DESCRIPTOR_LIST_UPDATE, ToolDescriptorListUpdate.class, messageBlock);
    }

    public MessageBlock encodeChannelCreationRequest(ChannelCreationRequest request) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.CHANNEL_INIT, request);
    }

    public ChannelCreationRequest decodeChannelCreationRequest(MessageBlock messageBlock) throws ProtocolException {
        return this.validateAndDecodeJSONMessage(MessageType.CHANNEL_INIT, ChannelCreationRequest.class, messageBlock);
    }

    public MessageBlock encodeChannelCreationResponse(ChannelCreationResponse response) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.CHANNEL_INIT_RESPONSE, response);
    }

    public ChannelCreationResponse decodeChannelCreationResponse(MessageBlock messageBlock) throws ProtocolException {
        return this.validateAndDecodeJSONMessage(MessageType.CHANNEL_INIT_RESPONSE, ChannelCreationResponse.class, messageBlock);
    }

    public MessageBlock encodeToolExecutionRequest(ToolExecutionRequest request) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.TOOL_EXECUTION_REQUEST, request);
    }

    public ToolExecutionRequest decodeToolExecutionRequest(MessageBlock messageBlock) throws ProtocolException {
        return this.validateAndDecodeJSONMessage(MessageType.TOOL_EXECUTION_REQUEST, ToolExecutionRequest.class, messageBlock);
    }

    public MessageBlock encodeToolExecutionRequestResponse(ToolExecutionRequestResponse request) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.TOOL_EXECUTION_REQUEST_RESPONSE, request);
    }

    public ToolExecutionRequestResponse decodeToolExecutionRequestResponse(MessageBlock messageBlock) throws ProtocolException {
        return this.validateAndDecodeJSONMessage(MessageType.TOOL_EXECUTION_REQUEST_RESPONSE, ToolExecutionRequestResponse.class, messageBlock);
    }

    public MessageBlock encodeFileTransferSectionStart(FileTransferSectionInfo data) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.FILE_TRANSFER_SECTION_START, data);
    }

    public FileTransferSectionInfo decodeFileTransferSectionStart(MessageBlock messageBlock) throws ProtocolException {
        FileTransferSectionInfo decodedWrapper = this.validateAndDecodeJSONMessage(MessageType.FILE_TRANSFER_SECTION_START, FileTransferSectionInfo.class, messageBlock);
        if (decodedWrapper != null) {
            return decodedWrapper;
        }
        return new FileTransferSectionInfo(null);
    }

    public MessageBlock encodeToolExecutionEvents(List<ToolExecutionProviderEventTransferObject> batch) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.TOOL_EXECUTION_EVENTS, batch);
    }

    public List<ToolExecutionProviderEventTransferObject> decodeToolExecutionEvents(MessageBlock messageBlock) throws ProtocolException {
        TypeReference<List<ToolExecutionProviderEventTransferObject>> typeRef = new TypeReference<List<ToolExecutionProviderEventTransferObject>>(){};
        return this.validateAndDecodeJSONMessage(MessageType.TOOL_EXECUTION_EVENTS, typeRef, messageBlock);
    }

    public MessageBlock createToolCancellationRequest() throws ProtocolException {
        return new MessageBlock(MessageType.TOOL_CANCELLATION_REQUEST);
    }

    public MessageBlock encodeToolExecutionResult(ToolExecutionResult executionResult) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.TOOL_EXECUTION_FINISHED, executionResult);
    }

    public ToolExecutionResult decodeToolExecutionResult(MessageBlock messageBlock) throws ProtocolException {
        return this.validateAndDecodeJSONMessage(MessageType.TOOL_EXECUTION_FINISHED, ToolExecutionResult.class, messageBlock);
    }

    public MessageBlock encodeFileHeader(FileHeader header) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.FILE_HEADER, header);
    }

    public FileHeader decodeFileHeader(MessageBlock messageBlock) throws ProtocolException {
        return this.validateAndDecodeJSONMessage(MessageType.FILE_HEADER, FileHeader.class, messageBlock);
    }

    public MessageBlock encodeDocumentationRequest(ToolDocumentationRequest request) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.TOOL_DOCUMENTATION_REQUEST, request);
    }

    public ToolDocumentationRequest decodeDocumentationRequest(MessageBlock messageBlock) throws ProtocolException {
        return this.validateAndDecodeJSONMessage(MessageType.TOOL_DOCUMENTATION_REQUEST, ToolDocumentationRequest.class, messageBlock);
    }

    public MessageBlock encodeDocumentationResponse(ToolDocumentationResponse response) throws ProtocolException {
        return this.encodeJSONMessage(MessageType.TOOL_DOCUMENTATION_RESPONSE, response);
    }

    public ToolDocumentationResponse decodeDocumentationResponse(MessageBlock messageBlock) throws ProtocolException {
        return this.validateAndDecodeJSONMessage(MessageType.TOOL_DOCUMENTATION_RESPONSE, ToolDocumentationResponse.class, messageBlock);
    }

    private MessageBlock encodeJSONMessage(MessageType messageType, Object jsonData) throws ProtocolException {
        try {
            byte[] jsonBytes = this.jsonMapper.writeValueAsBytes(jsonData);
            if (this.debugOutputEnabled) {
                this.log.debug((Object)StringUtils.format((String)"[%s] Encoded JSON message of type %s; output: '%s'", (Object[])new Object[]{this.logIdentity, messageType, this.jsonMapper.writeValueAsString(jsonData)}));
            }
            return new MessageBlock(messageType.getCode(), jsonBytes);
        }
        catch (JsonProcessingException | ProtocolException e) {
            throw new ProtocolException(StringUtils.format((String)"Failed to encode JSON message of type %s: %s", (Object[])new Object[]{messageType, e.toString()}));
        }
    }

    private <T> T validateAndDecodeJSONMessage(MessageType expectedMessageType, Class<T> resultClass, MessageBlock messageBlock) throws ProtocolException {
        this.validateMessageType(expectedMessageType, messageBlock);
        try {
            if (this.debugOutputEnabled) {
                this.log.debug((Object)StringUtils.format((String)"[%s] Decoding JSON message of type %s; input: '%s'", (Object[])new Object[]{this.logIdentity, messageBlock.getType(), new String(messageBlock.getData(), Charsets.UTF_8)}));
            }
            return (T)this.jsonMapper.readValue(messageBlock.getData(), resultClass);
        }
        catch (IOException e) {
            throw new ProtocolException(StringUtils.format((String)"Failed to decode JSON message of expected type %s: %s", (Object[])new Object[]{expectedMessageType, e.toString()}));
        }
    }

    private void validateMessageType(MessageType expectedMessageType, MessageBlock messageBlock) throws ProtocolException {
        if (messageBlock.getType() != expectedMessageType) {
            throw new ProtocolException("Internal error: Actual message code does not match the expected value");
        }
    }

    private <T> T validateAndDecodeJSONMessage(MessageType expectedMessageType, TypeReference<T> resultClass, MessageBlock messageBlock) throws ProtocolException {
        this.validateMessageType(expectedMessageType, messageBlock);
        try {
            if (this.debugOutputEnabled) {
                this.log.debug((Object)StringUtils.format((String)"[%s] Decoding JSON message of type %s; input: '%s'", (Object[])new Object[]{this.logIdentity, messageBlock.getType(), new String(messageBlock.getData(), Charsets.UTF_8)}));
            }
            return (T)this.jsonMapper.readValue(messageBlock.getData(), resultClass);
        }
        catch (IOException e) {
            throw new ProtocolException("Failed to decode JSON message of expected type " + (Object)((Object)expectedMessageType) + ": " + e.toString());
        }
    }
}

