/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.cpacs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.component.integration.IntegrationHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;

public class CpacsIntegrationHistoryDataItem
extends IntegrationHistoryDataItem {
    private static final String KEY_CPACS_WITH_VARIABLES_FILE_REFERENCE = "cpacsWithVariables";
    private static final String KEY_TOOL_INPUT_FILE_REFERENCE = "toolInput";
    private static final String KEY_TOOL_INPUT_FILENAME = "toolInputFilename";
    private static final String KEY_TOOL_INPUT_WITHOUT_TOOLSPECIFIC_FILE_REFERENCE = "toolInputWithoutToolspecific";
    private static final String KEY_TOOL_OUTPUT_FILE_REFERENCE = "toolOutput";
    private static final String KEY_TOOL_OUTPUT_FILENAME = "toolOutputFilename";
    private static final long serialVersionUID = 7762053749921116711L;
    private String cpacsWithVariablesFileReference;
    private String tIFileReference;
    private String tOFileReference;
    private String toolInputWithoutToolspecificFileReference;
    private String tIFilename;
    private String tOFilename;

    public CpacsIntegrationHistoryDataItem(String identifier) {
        super(identifier);
    }

    public String serialize(TypedDatumSerializer serializer) throws IOException {
        JsonNode rootNode;
        String commonDataString = super.serialize(serializer);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(commonDataString);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        if (this.cpacsWithVariablesFileReference != null) {
            ((ObjectNode)rootNode).put(KEY_CPACS_WITH_VARIABLES_FILE_REFERENCE, this.cpacsWithVariablesFileReference);
        }
        if (this.tIFileReference != null) {
            ((ObjectNode)rootNode).put(KEY_TOOL_INPUT_FILE_REFERENCE, this.tIFileReference);
        }
        if (this.tIFilename != null) {
            ((ObjectNode)rootNode).put(KEY_TOOL_INPUT_FILENAME, this.tIFilename);
        }
        if (this.tOFileReference != null) {
            ((ObjectNode)rootNode).put(KEY_TOOL_OUTPUT_FILE_REFERENCE, this.tOFileReference);
        }
        if (this.tOFilename != null) {
            ((ObjectNode)rootNode).put(KEY_TOOL_OUTPUT_FILENAME, this.tOFilename);
        }
        if (this.toolInputWithoutToolspecificFileReference != null) {
            ((ObjectNode)rootNode).put(KEY_TOOL_INPUT_WITHOUT_TOOLSPECIFIC_FILE_REFERENCE, this.toolInputWithoutToolspecificFileReference);
        }
        if (this.workingDirectory != null) {
            ((ObjectNode)rootNode).put("workingDirectory", this.workingDirectory);
        }
        return rootNode.toString();
    }

    public static CpacsIntegrationHistoryDataItem fromString(String historyData, TypedDatumSerializer serializer, String identifier) throws IOException {
        CpacsIntegrationHistoryDataItem historyDataItem = new CpacsIntegrationHistoryDataItem(identifier);
        historyDataItem.workingDirectory = IntegrationHistoryDataItem.fromString((String)historyData, (TypedDatumSerializer)serializer, (String)identifier).getWorkingDirectory();
        CommonComponentHistoryDataItem.initializeCommonHistoryDataFromString((CommonComponentHistoryDataItem)historyDataItem, (String)historyData, (TypedDatumSerializer)serializer);
        CpacsIntegrationHistoryDataItem.readXMLFileReferencesFromString(historyData, historyDataItem);
        return historyDataItem;
    }

    private static void readXMLFileReferencesFromString(String historyData, CpacsIntegrationHistoryDataItem historyDataItem) throws IOException {
        JsonNode rootNode;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(historyData);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        if (((ObjectNode)rootNode).get(KEY_CPACS_WITH_VARIABLES_FILE_REFERENCE) != null) {
            historyDataItem.cpacsWithVariablesFileReference = ((ObjectNode)rootNode).get(KEY_CPACS_WITH_VARIABLES_FILE_REFERENCE).textValue();
        }
        if (((ObjectNode)rootNode).get(KEY_TOOL_INPUT_FILE_REFERENCE) != null) {
            historyDataItem.tIFileReference = ((ObjectNode)rootNode).get(KEY_TOOL_INPUT_FILE_REFERENCE).textValue();
        }
        if (((ObjectNode)rootNode).get(KEY_TOOL_INPUT_FILENAME) != null) {
            historyDataItem.tIFilename = ((ObjectNode)rootNode).get(KEY_TOOL_INPUT_FILENAME).textValue();
        }
        if (((ObjectNode)rootNode).get(KEY_TOOL_OUTPUT_FILE_REFERENCE) != null) {
            historyDataItem.tOFileReference = ((ObjectNode)rootNode).get(KEY_TOOL_OUTPUT_FILE_REFERENCE).textValue();
        }
        if (((ObjectNode)rootNode).get(KEY_TOOL_OUTPUT_FILENAME) != null) {
            historyDataItem.tOFilename = ((ObjectNode)rootNode).get(KEY_TOOL_OUTPUT_FILENAME).textValue();
        }
        if (((ObjectNode)rootNode).get(KEY_TOOL_INPUT_WITHOUT_TOOLSPECIFIC_FILE_REFERENCE) != null) {
            historyDataItem.toolInputWithoutToolspecificFileReference = ((ObjectNode)rootNode).get(KEY_TOOL_INPUT_WITHOUT_TOOLSPECIFIC_FILE_REFERENCE).textValue();
        }
    }

    public String getCpacsWithVariablesFileReference() {
        return this.cpacsWithVariablesFileReference;
    }

    public void setCpacsWithVariablesFileReference(String xmlWithVariablesFileReference) {
        this.cpacsWithVariablesFileReference = xmlWithVariablesFileReference;
    }

    public String getToolInputFileReference() {
        return this.tIFileReference;
    }

    public void setToolInputFile(String toolInputFilename, String toolInputFileReference) {
        this.tIFilename = toolInputFilename;
        this.tIFileReference = toolInputFileReference;
    }

    public String getToolOutputFileReference() {
        return this.tOFileReference;
    }

    public void setToolOutputFile(String toolOutputFilename, String toolOutputFileReference) {
        this.tOFilename = toolOutputFilename;
        this.tOFileReference = toolOutputFileReference;
    }

    public void setToolInputWithoutToolspecificFileReference(String toolInputWithoutToolspecificFileReference) {
        this.toolInputWithoutToolspecificFileReference = toolInputWithoutToolspecificFileReference;
    }

    public String getToolInputWithoutToolspecificFileReference() {
        return this.toolInputWithoutToolspecificFileReference;
    }

    public String getToolInputFilename() {
        return this.tIFilename;
    }

    public String getToolOutputFilename() {
        return this.tOFilename;
    }
}

