/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class RingBuffer<T> {
    private final T[] elements;
    private final int capacity;
    private int nextInsertPos;
    private int currentElementCount;

    public RingBuffer(int capacity) {
        this.capacity = capacity;
        this.elements = new Object[this.capacity];
    }

    public synchronized void add(T element) {
        this.elements[this.nextInsertPos] = element;
        this.nextInsertPos = (this.nextInsertPos + 1) % this.capacity;
        this.currentElementCount = Math.min(this.currentElementCount + 1, this.capacity);
    }

    public synchronized Optional<T> getLatestEntry() {
        if (this.currentElementCount < 1) {
            return Optional.empty();
        }
        return Optional.of(this.elements[this.getPreviousIndex(1)]);
    }

    public synchronized List<T> getLastItems(int countOfElements) {
        if (this.currentElementCount > 0) {
            int startIndex;
            if (countOfElements > this.currentElementCount) {
                countOfElements = this.getCurrentElementCount();
            }
            Object[] copyOfElements = new Object[countOfElements];
            int i = startIndex = this.getPreviousIndex(countOfElements);
            int j = 0;
            while (j < countOfElements) {
                copyOfElements[j] = this.elements[i];
                ++i;
                i %= this.capacity;
                ++j;
            }
            return Collections.unmodifiableList(Arrays.asList(copyOfElements));
        }
        return Collections.emptyList();
    }

    public synchronized int getCurrentElementCount() {
        return this.currentElementCount;
    }

    private synchronized int getPreviousIndex(int stepsBack) {
        return (this.capacity + (this.nextInsertPos - stepsBack)) % this.capacity;
    }
}

