/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.workflow.command;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandFlag;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.ListCommandParameter;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.NamedParameter;
import de.rcenvironment.core.command.spi.NamedSingleParameter;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedListParameter;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.StringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.component.api.ComponentIdRules;
import de.rcenvironment.core.component.integration.workflow.WorkflowIntegrationService;
import de.rcenvironment.core.component.integration.workflow.command.ParseResult;
import de.rcenvironment.core.component.integration.workflow.command.WfIntegrateCommandParser;
import de.rcenvironment.core.component.workflow.execution.api.PersistentWorkflowDescriptionLoaderService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapter;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapters;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class WfIntegrateCommandPlugin
implements CommandPlugin {
    private static final String SYNTAX_DESCRIPTION = "ComponentName:OutputName:ExposedName,";
    private static final String DESCRIPTION_TEXT = "elements of the workflow to expose (see User Guide)";
    private static final CommandFlag VERBOSE_FLAG = new CommandFlag("-v", "--verbose", "enable verbose output");
    private static final StringParameter TOOLNAME_PARAMETER = new StringParameter(null, "toolname", "name for the tool");
    private static final StringParameter WORKFLOW_FILE_PARAMETER = new StringParameter(null, "workflow file", "workflow to be integrated");
    private static final StringParameter ELEMENT_PARAMETER = new StringParameter(null, "element", "element to be exposed");
    private static final ListCommandParameter EXPOSE_LIST_PARAMETER = new ListCommandParameter((AbstractCommandParameter)ELEMENT_PARAMETER, "ComponentName:OutputName:ExposedName,", "elements of the workflow to expose (see User Guide)");
    private static final NamedParameter NAMED_EXPOSE_PARAMETER = new NamedSingleParameter("--expose", "elements of the workflow to expose (see User Guide)", (AbstractCommandParameter)EXPOSE_LIST_PARAMETER);
    private static final NamedParameter NAMED_EXPOSE_INPUTS_PARAMETER = new NamedSingleParameter("--expose-inputs", "elements of the workflow to expose (see User Guide)", (AbstractCommandParameter)EXPOSE_LIST_PARAMETER);
    private static final NamedParameter NAMED_EXPOSE_OUTPUTS_PARAMETER = new NamedSingleParameter("--expose-outputs", "elements of the workflow to expose (see User Guide)", (AbstractCommandParameter)EXPOSE_LIST_PARAMETER);
    private WorkflowIntegrationService workflowIntegrationService;
    private PersistentWorkflowDescriptionLoaderService workflowLoaderService;

    public MainCommandDescription[] getCommands() {
        return new MainCommandDescription[]{new MainCommandDescription("wf-integrate", "integrate a workflow file as a component", "integrate a workflow file as a component", this::performWfIntegrate, new CommandModifierInfo(new AbstractCommandParameter[]{TOOLNAME_PARAMETER, WORKFLOW_FILE_PARAMETER}, new CommandFlag[]{VERBOSE_FLAG}, new NamedParameter[]{NAMED_EXPOSE_PARAMETER, NAMED_EXPOSE_INPUTS_PARAMETER, NAMED_EXPOSE_OUTPUTS_PARAMETER}), new SubCommandDescription[0])};
    }

    private void performWfIntegrate(CommandContext context) throws CommandException {
        WorkflowDescription desc;
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        boolean verbose = modifiers.hasCommandFlag("-v");
        ParsedStringParameter toolnameParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
        ParsedStringParameter workflowFileParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(1);
        ParsedListParameter exportListParameter = (ParsedListParameter)modifiers.getCommandParameter("--expose");
        List<String> exportListValues = exportListParameter.getResult().stream().map(parameter -> (String)parameter.getResult()).collect(Collectors.toList());
        ParsedListParameter exportInputsListParameter = (ParsedListParameter)modifiers.getCommandParameter("--expose-inputs");
        List<String> exportInputsListValues = exportInputsListParameter.getResult().stream().map(parameter -> (String)parameter.getResult()).collect(Collectors.toList());
        ParsedListParameter exportOutputsListParameter = (ParsedListParameter)modifiers.getCommandParameter("--expose-outputs");
        List<String> exportOutputsListValues = exportOutputsListParameter.getResult().stream().map(parameter -> (String)parameter.getResult()).collect(Collectors.toList());
        String componentname = toolnameParameter.getResult();
        Optional idValidationError = ComponentIdRules.validateComponentIdRules((String)componentname);
        if (idValidationError.isPresent()) {
            throw CommandException.syntaxError((String)"Invalid component ID", (CommandContext)context);
        }
        try {
            desc = this.workflowLoaderService.loadWorkflowDescriptionFromFile(new File(workflowFileParameter.getResult()), null);
        }
        catch (WorkflowFileException workflowFileException) {
            throw CommandException.executionError((String)StringUtils.format((String)"Workflow file at '%s' could not be parsed", (Object[])new Object[]{workflowFileParameter.getResult()}), (CommandContext)context);
        }
        if (desc.getName() == null) {
            this.addWorkflowName(desc, workflowFileParameter);
        }
        WfIntegrateCommandParser parser = new WfIntegrateCommandParser();
        LinkedList<EndpointAdapter> unpackedParseResults = new LinkedList<EndpointAdapter>();
        LinkedList<String> parseErrors = new LinkedList<String>();
        this.parseListParameter(exportListValues, "--expose", parser, desc, unpackedParseResults, parseErrors);
        this.parseListParameter(exportInputsListValues, "--expose-inputs", parser, desc, unpackedParseResults, parseErrors);
        this.parseListParameter(exportOutputsListValues, "--expose-outputs", parser, desc, unpackedParseResults, parseErrors);
        String parseErrorMessage = parseErrors.stream().collect(Collectors.joining("\n"));
        if (!parseErrorMessage.isEmpty()) {
            throw CommandException.syntaxError((String)StringUtils.format((String)"Could not parse endpoint adapter definitions: \n%s", (Object[])new Object[]{parseErrorMessage}), (CommandContext)context);
        }
        if (verbose) {
            unpackedParseResults.stream().filter(EndpointAdapter::isInputAdapter).map(EndpointAdapter::toString).forEach(definitionString -> context.getOutputReceiver().addOutput(StringUtils.format((String)"Input Adapter : %s", (Object[])new Object[]{definitionString})));
            unpackedParseResults.stream().filter(EndpointAdapter::isOutputAdapter).map(EndpointAdapter::toString).forEach(definitionString -> context.getOutputReceiver().addOutput(StringUtils.format((String)"Output Adapter: %s", (Object[])new Object[]{definitionString})));
        }
        EndpointAdapters.Builder endpointAdapters = new EndpointAdapters.Builder();
        for (EndpointAdapter parseResult : unpackedParseResults) {
            endpointAdapters.addEndpointAdapter(parseResult);
        }
        try {
            this.workflowIntegrationService.integrateWorkflowFileAsComponent(desc, componentname, endpointAdapters.build());
        }
        catch (IOException iOException) {
            throw CommandException.executionError((String)StringUtils.format((String)"Could not integrate workflow '%s' as component '%s'", (Object[])new Object[]{workflowFileParameter.getResult(), componentname}), (CommandContext)context);
        }
    }

    private void addWorkflowName(WorkflowDescription desc, ParsedStringParameter workflowFileParameter) {
        desc.setName(new File(workflowFileParameter.getResult()).getName());
    }

    private void parseListParameter(List<String> values, String type, WfIntegrateCommandParser parser, WorkflowDescription desc, Collection<EndpointAdapter> unpackedParseResults, Collection<String> parseErrors) {
        int i = 0;
        while (i < values.size()) {
            Collection<ParseResult<EndpointAdapter>> exposureParameters = parser.parseEndpointAdapterDefinition(type, values.get(i), desc);
            for (ParseResult<EndpointAdapter> parameter : exposureParameters) {
                if (parameter.isSuccessfulResult()) {
                    unpackedParseResults.add(parameter.getResult());
                    continue;
                }
                parseErrors.add(parameter.getErrorDisplayMessage());
            }
            ++i;
        }
    }

    @Reference
    public void bindWorkflowIntegrationService(WorkflowIntegrationService service) {
        this.workflowIntegrationService = service;
    }

    @Reference
    public void bindWorkflowLoaderService(PersistentWorkflowDescriptionLoaderService service) {
        this.workflowLoaderService = service;
    }
}

