/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.testing;

import de.rcenvironment.core.utils.common.StreamConnectionEndpoint;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.LogFactory;

public class LocalTCPTestConnection
implements Closeable {
    private static final int LOCAL_CONNECTION_INIT_TIMEOUT = 500;
    private final ServerSocket serverSocket;
    private final Socket clientSocket;
    private InputStream clientSideInputStream;
    private OutputStream clientSideOutputStream;
    private InputStream serverSideInputStream;
    private OutputStream serverSideOutputStream;

    public LocalTCPTestConnection() throws IOException {
        AtomicReference serverSideInitError = new AtomicReference();
        CountDownLatch serverSideInitializedLatch = new CountDownLatch(1);
        this.serverSocket = new ServerSocket(0);
        new Thread(() -> {
            try {
                Socket socket = this.serverSocket.accept();
                this.serverSideInputStream = socket.getInputStream();
                this.serverSideOutputStream = socket.getOutputStream();
            }
            catch (IOException e) {
                serverSideInitError.set(e.toString());
            }
            serverSideInitializedLatch.countDown();
        }).start();
        this.clientSocket = new Socket("127.0.0.1", this.serverSocket.getLocalPort());
        this.clientSideInputStream = this.clientSocket.getInputStream();
        this.clientSideOutputStream = this.clientSocket.getOutputStream();
        try {
            serverSideInitializedLatch.await(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (serverSideInitError.get() != null) {
            throw new IOException("Server-side init error: " + (String)serverSideInitError.get());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.clientSocket.close();
        }
        finally {
            this.serverSocket.close();
        }
    }

    public InputStream getClientSideInputStream() {
        return this.clientSideInputStream;
    }

    public OutputStream getClientSideOutputStream() {
        return this.clientSideOutputStream;
    }

    public InputStream getServerSideInputStream() {
        return this.serverSideInputStream;
    }

    public OutputStream getServerSideOutputStream() {
        return this.serverSideOutputStream;
    }

    public StreamConnectionEndpoint getServerSideEndpoint() {
        return new StreamConnectionEndpoint(){

            public OutputStream getOutputStream() {
                return LocalTCPTestConnection.this.serverSideOutputStream;
            }

            public InputStream getInputStream() {
                return LocalTCPTestConnection.this.serverSideInputStream;
            }

            public void close() {
                try {
                    LocalTCPTestConnection.this.serverSocket.close();
                }
                catch (IOException e) {
                    LogFactory.getLog(this.getClass()).debug((Object)("Error while closing the server-side end of a test connection: " + e.toString()));
                }
            }
        };
    }

    public StreamConnectionEndpoint getClientSideEndpoint() {
        return new StreamConnectionEndpoint(){

            public OutputStream getOutputStream() {
                return LocalTCPTestConnection.this.clientSideOutputStream;
            }

            public InputStream getInputStream() {
                return LocalTCPTestConnection.this.clientSideInputStream;
            }

            public void close() {
                try {
                    LocalTCPTestConnection.this.clientSocket.close();
                }
                catch (IOException e) {
                    LogFactory.getLog(this.getClass()).debug((Object)("Error while closing the client-side end of a test connection: " + e.toString()));
                }
            }
        };
    }
}

