/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import de.rcenvironment.core.start.common.validation.spi.InstanceValidator;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.TextStreamWatcher;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.executor.LocalApacheCommandLineExecutor;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={InstanceValidator.class})
public class PythonInstallationValidator
extends DefaultInstanceValidator {
    private static final String PYTHON_VALIDATION_ERROR = "Validation of python path failed.";
    private static final String PYTHON_INSTALLATION_DISPLAYNAME = "PyhonInstallation";
    private static final Long PYTHON_TEST_TIMEOUT = 1L;
    private static Log logger = LogFactory.getLog(PythonInstallationValidator.class);

    public InstanceValidationResult validate() {
        ServiceRegistryAccess registry = ServiceRegistry.createAccessFor((Object)((Object)this));
        ConfigurationService service = (ConfigurationService)registry.getService(ConfigurationService.class);
        ConfigurationSegment pythonConfiguration = service.getConfigurationSegment("thirdPartyIntegration/python");
        String pythonInstallation = pythonConfiguration.getString("binaryPath");
        if (pythonInstallation != null) {
            PythonVersionRegexValidator validator = new PythonVersionRegexValidator();
            PythonValidationResult result = this.executeAndValidate(pythonInstallation, validator);
            if (result.isPythonExecutionSuccessful()) {
                return InstanceValidationResultFactory.createResultForPassed((String)PYTHON_INSTALLATION_DISPLAYNAME);
            }
            return InstanceValidationResultFactory.createResultForFailureWhichAllowsToProceed((String)PYTHON_INSTALLATION_DISPLAYNAME, (String)"The supplied Python path does not reference to a standard Python version");
        }
        return InstanceValidationResultFactory.createResultForPassed((String)PYTHON_INSTALLATION_DISPLAYNAME);
    }

    private PythonValidationResult executeAndValidate(final String pythonInstallation, final PythonVersionRegexValidator validator) {
        String command = "\"" + pythonInstallation + "\"" + " --version";
        try {
            block9: {
                final LocalApacheCommandLineExecutor executor = this.createCommandLineExecutor(new File("/"));
                executor.start(command);
                final TextStreamWatcher stdOutTextStreamWatcher = new TextStreamWatcher(executor.getStdout(), ConcurrencyUtils.getAsyncTaskService(), new TextOutputReceiver[]{new CapturingTextOutReceiver(){

                    public synchronized void addOutput(String line) {
                        super.addOutput(line);
                        validator.validatePythonVersion(line, pythonInstallation);
                    }
                }});
                final TextStreamWatcher stdErrTextStreamWatcher = new TextStreamWatcher(executor.getStderr(), ConcurrencyUtils.getAsyncTaskService(), new TextOutputReceiver[]{new CapturingTextOutReceiver(){

                    public synchronized void addOutput(String line) {
                        super.addOutput(line);
                        validator.validatePythonVersion(line, pythonInstallation);
                    }
                }});
                stdOutTextStreamWatcher.start();
                stdErrTextStreamWatcher.start();
                AsyncTaskService asyncTaskService = ConcurrencyUtils.getAsyncTaskService();
                Future task = asyncTaskService.submit("PythonValidation", new Runnable(){

                    @Override
                    @TaskDescription(value="Waits for python validation to finish")
                    public void run() {
                        try {
                            executor.waitForTermination();
                            stdOutTextStreamWatcher.waitForTermination();
                            stdErrTextStreamWatcher.waitForTermination();
                        }
                        catch (IOException e) {
                            logger.error((Object)PythonInstallationValidator.PYTHON_VALIDATION_ERROR, (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            logger.error((Object)PythonInstallationValidator.PYTHON_VALIDATION_ERROR, (Throwable)e);
                        }
                    }
                });
                try {
                    task.get(PYTHON_TEST_TIMEOUT, TimeUnit.SECONDS);
                }
                catch (TimeoutException timeoutException) {
                    executor.cancel();
                    executor.cancel();
                    break block9;
                }
                catch (ExecutionException e) {
                    try {
                        logger.error((Object)PYTHON_VALIDATION_ERROR, (Throwable)e);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        executor.cancel();
                    }
                }
                executor.cancel();
            }
            PythonValidationResult result = validator.getValidationResult();
            return result;
        }
        catch (IOException | InterruptedException e) {
            logger.error((Object)PYTHON_VALIDATION_ERROR, (Throwable)e);
            return PythonValidationResult.DEFAULT_NONE_PLACEHOLDER;
        }
    }

    protected PythonVersionRegexValidator createPythonVersionRegexValidator() {
        return new PythonVersionRegexValidator();
    }

    protected LocalApacheCommandLineExecutor createCommandLineExecutor(File workDirPath) throws IOException {
        return new LocalApacheCommandLineExecutor(workDirPath);
    }

    protected static final class PythonValidationResult {
        public static final PythonValidationResult DEFAULT_NONE_PLACEHOLDER = new PythonValidationResult("/none", -1, -1, -1, false);
        private final int majorPythonVersion;
        private final int minorPythonVersion;
        private final int microPythonVersion;
        private final boolean successfull;
        private final String pythonPath;

        public PythonValidationResult(String pythonPath, int majorVersion, int minorVersion, int microVersion, boolean successfull) {
            if (pythonPath == null) {
                throw new NullPointerException("The given Python path cannot be null");
            }
            if (pythonPath.isEmpty()) {
                throw new IllegalArgumentException("The given Python path cannot be empty.");
            }
            this.pythonPath = pythonPath;
            this.majorPythonVersion = majorVersion;
            this.minorPythonVersion = minorVersion;
            this.microPythonVersion = microVersion;
            this.successfull = successfull;
        }

        public boolean isPythonExecutionSuccessful() {
            if (this.isPlaceholder()) {
                return false;
            }
            return this.successfull;
        }

        public int getMajorPythonVersion() {
            return this.majorPythonVersion;
        }

        public int getMinorPythonVersion() {
            return this.minorPythonVersion;
        }

        public int getMicroPythonVersion() {
            return this.microPythonVersion;
        }

        public String getPythonPath() {
            return this.pythonPath;
        }

        public boolean isPlaceholder() {
            return this == DEFAULT_NONE_PLACEHOLDER;
        }
    }

    protected static final class PythonVersionRegexValidator {
        private static final Pattern MATCH_PATTERN = Pattern.compile("^Python\\s([0-9]+)\\.{0,}([0-9]+){0,}\\.{0,}([0-9]+){0,}");
        private static final int MINUS_ONE = -1;
        private PythonValidationResult currentResult = PythonValidationResult.DEFAULT_NONE_PLACEHOLDER;

        protected PythonVersionRegexValidator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validatePythonVersion(String line, String pythonPath) {
            PythonVersionRegexValidator pythonVersionRegexValidator;
            if (this.currentResult.isPythonExecutionSuccessful()) {
                return;
            }
            int majorPythonVersion = -1;
            int minorPythonVersion = -1;
            int microPythonVersion = -1;
            Matcher matcher = MATCH_PATTERN.matcher(line);
            if (matcher.find()) {
                String g1 = matcher.group(1);
                String g2 = matcher.group(2);
                String g3 = matcher.group(3);
                if (g1 != null) {
                    majorPythonVersion = Integer.parseInt(g1);
                }
                if (g2 != null) {
                    minorPythonVersion = Integer.parseInt(g2);
                }
                if (g3 != null) {
                    microPythonVersion = Integer.parseInt(g3);
                }
            }
            if (majorPythonVersion == 3 || majorPythonVersion == 2 && minorPythonVersion >= 6) {
                pythonVersionRegexValidator = this;
                synchronized (pythonVersionRegexValidator) {
                    this.currentResult = new PythonValidationResult(pythonPath, majorPythonVersion, minorPythonVersion, microPythonVersion, true);
                    return;
                }
            }
            pythonVersionRegexValidator = this;
            synchronized (pythonVersionRegexValidator) {
                this.currentResult = new PythonValidationResult(pythonPath, majorPythonVersion, minorPythonVersion, microPythonVersion, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PythonValidationResult getValidationResult() {
            PythonVersionRegexValidator pythonVersionRegexValidator = this;
            synchronized (pythonVersionRegexValidator) {
                return this.currentResult;
            }
        }
    }
}

