/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.ExpressionProcessor;
import net.sf.saxon.expr.flwor.OrderByClausePull;
import net.sf.saxon.expr.flwor.OrderByClausePush;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public class OrderByClause
extends Clause {
    SortKeyDefinition[] sortKeys;
    AtomicComparer[] comparators;
    TupleExpression tupleExpression;

    public OrderByClause(SortKeyDefinition[] sortKeys, TupleExpression tupleExpression) {
        this.sortKeys = sortKeys;
        this.tupleExpression = tupleExpression;
    }

    public int getClauseKey() {
        return 5;
    }

    public OrderByClause copy() {
        SortKeyDefinition[] sk2 = new SortKeyDefinition[this.sortKeys.length];
        for (int i = 0; i < this.sortKeys.length; ++i) {
            sk2[i] = this.sortKeys[i].copy();
        }
        OrderByClause obc = new OrderByClause(sk2, (TupleExpression)this.tupleExpression.copy());
        obc.comparators = this.comparators;
        return obc;
    }

    public SortKeyDefinition[] getSortKeyDefinitions() {
        return this.sortKeys;
    }

    public AtomicComparer[] getAtomicComparers() {
        return this.comparators;
    }

    public TuplePull getPullStream(TuplePull base, XPathContext context) {
        return new OrderByClausePull(base, this.tupleExpression, this, context);
    }

    public TuplePush getPushStream(TuplePush destination, XPathContext context) {
        return new OrderByClausePush(destination, this.tupleExpression, this, context);
    }

    public void processSubExpressions(ExpressionProcessor processor) throws XPathException {
        this.tupleExpression = (TupleExpression)processor.processExpression(this.tupleExpression);
        for (int i = 0; i < this.sortKeys.length; ++i) {
            this.sortKeys[i].processSubExpressions(processor);
        }
    }

    public void typeCheck(ExpressionVisitor visitor) throws XPathException {
        int i;
        boolean allKeysFixed = true;
        for (i = 0; i < this.sortKeys.length; ++i) {
            if (this.sortKeys[i].isFixed()) continue;
            allKeysFixed = false;
            break;
        }
        if (allKeysFixed) {
            this.comparators = new AtomicComparer[this.sortKeys.length];
        }
        for (i = 0; i < this.sortKeys.length; ++i) {
            Expression sortKey = this.sortKeys[i].getSortKey();
            RoleLocator role = new RoleLocator(6, "", i);
            role.setErrorCode("XPTY0004");
            sortKey = TypeChecker.staticTypeCheck(sortKey, SequenceType.OPTIONAL_ATOMIC, false, role, visitor);
            this.sortKeys[i].setSortKey(sortKey, false);
            if (!this.sortKeys[i].isFixed()) continue;
            AtomicComparer comp = this.sortKeys[i].makeComparator(visitor.getStaticContext().makeEarlyEvaluationContext());
            this.sortKeys[i].setFinalComparator(comp);
            if (!allKeysFixed) continue;
            this.comparators[i] = comp;
        }
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("order-by");
        for (SortKeyDefinition k : this.sortKeys) {
            out.startSubsidiaryElement("key");
            k.getSortKey().explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        fsb.append("order by ... ");
        return fsb.toString();
    }

    public AtomicValue evaluateSortKey(int n, XPathContext c) throws XPathException {
        return (AtomicValue)this.sortKeys[n].getSortKey().evaluateItem(c);
    }
}

