/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.embedded.ssh.api.ScpContext;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;

public class ScpContextImpl
implements ScpContext {
    private String authorizedUsername;
    private String virtualScpRootPath;
    private File localRootPath;

    public ScpContextImpl(String username, String virtualRootPath) throws IOException {
        this.authorizedUsername = username;
        this.virtualScpRootPath = virtualRootPath;
        this.localRootPath = TempFileServiceAccess.getInstance().createManagedTempDir("scp");
    }

    @Override
    public String getAuthorizedUsername() {
        return this.authorizedUsername;
    }

    public void setAuthorizedUsername(String accountName) {
        this.authorizedUsername = accountName;
    }

    @Override
    public String getVirtualScpRootPath() {
        return this.virtualScpRootPath;
    }

    public void setVirtualScpRootPath(String virtualScpRootPath) {
        this.virtualScpRootPath = virtualScpRootPath;
    }

    @Override
    public File getLocalRootPath() {
        return this.localRootPath;
    }

    public void setLocalRootPath(File localScpRootPath) {
        this.localRootPath = localScpRootPath;
    }

    @Override
    public void dispose() throws IOException {
        TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.localRootPath);
    }

    public String toString() {
        return StringUtils.format((String)"User='%s', SCP root path='%s', local root dir='%s'", (Object[])new Object[]{this.authorizedUsername, this.virtualScpRootPath, this.localRootPath});
    }
}

