/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.internal;

import de.rcenvironment.core.communication.uplink.network.internal.CommonUplinkLowLevelProtocolWrapper;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionLowLevelEventHandler;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionRefusedException;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolErrorType;
import de.rcenvironment.core.utils.common.StreamConnectionEndpoint;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class ClientSideUplinkLowLevelProtocolWrapper
extends CommonUplinkLowLevelProtocolWrapper {
    private boolean connectionClosedWithError;

    public ClientSideUplinkLowLevelProtocolWrapper(StreamConnectionEndpoint connectionEndpoint, UplinkConnectionLowLevelEventHandler eventHandler, String logIdentity) {
        super(connectionEndpoint, eventHandler, logIdentity);
    }

    @Override
    protected void runHandshakeSequence() throws UplinkConnectionRefusedException {
        MessageBlock responseMessageBlock;
        MessageBlock handshakeData;
        try {
            handshakeData = this.generateHandshakeData();
        }
        catch (ProtocolException e) {
            this.log.error((Object)("Unexpected error during handshake data generation: " + e.toString()));
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.INTERNAL_CLIENT_ERROR, "Error generating the local data to send to the server", false);
        }
        try {
            this.sendHandshakeInit();
            this.sendHandshakeData(handshakeData);
        }
        catch (IOException iOException) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "Error sending the initial data to the server", false);
        }
        try {
            this.expectHandshakeInit();
        }
        catch (IOException iOException) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "Error receiving the server's initial response; most likely, the connection has been closed by the server. Make sure that you connecting to an Uplink server, and that the server's version is generally compatible.", false);
        }
        catch (TimeoutException timeoutException) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "No initial response received from the server within the expected time. This may be caused by a firewall blocking the connection attempt, or because you accidentally connected to a different kind of server.", false);
        }
        try {
            responseMessageBlock = this.expectHandshakeData();
        }
        catch (IOException e) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "Error reading the connection response from the server: " + e.toString(), false);
        }
        catch (UplinkConnectionRefusedException e) {
            throw e;
        }
        catch (TimeoutException timeoutException) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.UNKNOWN_ERROR_ALLOW_RECONNECT, "Received an initial response from the server, but reached the timeout while waiting for further data - assuming an internal server error", false);
        }
        try {
            this.processHandshakeResponse(responseMessageBlock);
        }
        catch (IOException e) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.INVALID_HANDSHAKE_DATA, "Failed to process the response received from the server: " + e.toString(), false);
        }
        try {
            this.sendHandshakeConfirmation();
        }
        catch (IOException e) {
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.LOW_LEVEL_CONNECTION_ERROR, "Failed to send the final confirmation to the server after a successful message exchange: " + e.toString(), false);
        }
    }

    private MessageBlock generateHandshakeData() throws ProtocolException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try {
            this.eventHandler.provideOrProcessHandshakeData(null, dataMap);
        }
        catch (UplinkConnectionRefusedException uplinkConnectionRefusedException) {
            throw new IllegalStateException("Unexpected internal error: The client should never fail to produce its handshake data");
        }
        return this.messageConverter.encodeHandshakeData(dataMap);
    }

    private void processHandshakeResponse(MessageBlock responseMessageBlock) throws IOException {
        Map<String, String> handshakeResponseData = this.messageConverter.decodeHandshakeData(responseMessageBlock);
        try {
            this.eventHandler.provideOrProcessHandshakeData(handshakeResponseData, null);
        }
        catch (UplinkConnectionRefusedException e) {
            throw new IOException("Unexpected error while processing the relay's handshake response: " + e.getMessage());
        }
    }

    private synchronized boolean registerAsFirstCriticalError() {
        boolean result = !this.connectionClosedWithError;
        this.connectionClosedWithError = true;
        return result;
    }
}

