/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.util.Preferences;

public class CrossAnnotation
extends Annotation {
    static final int CROSS_SIZE = 5;

    public CrossAnnotation(String name, Trace trace) {
        super(name, trace);
    }

    public CrossAnnotation(String name, Axis xAxis, Axis yAxis) {
        super(name, xAxis, yAxis);
    }

    @Override
    public void setCurrentSnappedSample(ISample currentSnappedSample, boolean keepLabelPosition) {
        this.currentSnappedSample = currentSnappedSample;
        this.repaint();
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        if (this.trace != null && this.currentSnappedSample == null && !this.pointerDragged) {
            this.updateToDefaultPosition();
        }
        if (Preferences.useAdvancedGraphics()) {
            graphics.setAntialias(1);
        }
        graphics.setForegroundColor(this.getForegroundColor());
        this.xValue = this.currentSnappedSample.getXValue();
        this.yValue = this.currentSnappedSample.getYValue();
        int x = this.xAxis.getValuePosition(this.xValue, false);
        int y = this.yAxis.getValuePosition(this.yValue, false);
        Point p = new Point();
        p.setLocation(y, x);
        graphics.drawLine(x - 5, y - 5, x + 5, y + 5);
        graphics.drawLine(x - 5, y + 5, x + 5, y - 5);
        graphics.drawLine(x, y + 5, x, y - 5);
        graphics.drawLine(x - 5, y, x + 5, y);
    }
}

