/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.internal.xygraph.toolbar;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RemoveAnnotationDialog
extends Dialog {
    private XYGraph xyGraph;
    private Combo annotationsCombo;
    private Annotation removedAnnotation;

    public RemoveAnnotationDialog(Shell parentShell, XYGraph xyGraph) {
        super(parentShell);
        this.xyGraph = xyGraph;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Remove Annotation");
    }

    protected Control createDialogArea(Composite parent) {
        Composite parent_composite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parent_composite, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        Label removeLabel = new Label(composite, 0);
        removeLabel.setLayoutData((Object)new GridData());
        if (this.xyGraph.getPlotArea().getAnnotationList().size() > 0) {
            removeLabel.setText("Select the annotation to be removed: ");
            this.annotationsCombo = new Combo(composite, 4);
            this.annotationsCombo.setLayoutData((Object)new GridData(4, 0, true, false));
            for (Annotation annotation : this.xyGraph.getPlotArea().getAnnotationList()) {
                this.annotationsCombo.add(annotation.getName());
            }
            this.annotationsCombo.select(0);
        } else {
            removeLabel.setText("There is no annotation on the graph.");
        }
        return parent_composite;
    }

    protected void okPressed() {
        if (this.annotationsCombo != null) {
            this.removedAnnotation = this.xyGraph.getPlotArea().getAnnotationList().get(this.annotationsCombo.getSelectionIndex());
        }
        super.okPressed();
    }

    public Annotation getAnnotation() {
        return this.removedAnnotation;
    }
}

