/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.gui.view;

import de.rcenvironment.components.excel.common.ChannelValue;
import de.rcenvironment.components.excel.common.ExcelService;
import de.rcenvironment.components.excel.common.ExcelServiceAccess;
import de.rcenvironment.components.excel.common.ExcelUtils;
import de.rcenvironment.components.excel.gui.view.ChannelFilter;
import de.rcenvironment.components.excel.gui.view.ChannelValueContentProvider;
import de.rcenvironment.components.excel.gui.view.ChannelValueLabelProvider;
import de.rcenvironment.components.excel.gui.view.DoubleClickListener;
import de.rcenvironment.components.excel.gui.view.Messages;
import de.rcenvironment.components.excel.gui.view.ModelProvider;
import de.rcenvironment.components.excel.gui.view.NewFileWizard;
import de.rcenvironment.components.excel.gui.view.SelectionProviderIntermediate;
import de.rcenvironment.components.excel.gui.view.TableSorter;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import de.rcenvironment.core.gui.workflow.view.ComponentRuntimeView;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class ExcelView
extends ViewPart
implements ComponentRuntimeView,
Observer {
    private static final String FILETYPENAME = "Excel";
    private static final Log LOGGER = LogFactory.getLog(ExcelView.class);
    private final ModelProvider model = new ModelProvider();
    private ComponentExecutionInformation compExeInfo = null;
    private Composite parentComposite = null;
    private ScrolledForm form = null;
    private TableViewer inputTableViewer = null;
    private TableViewer outputTableViewer = null;
    private TableSorter tableSorter = null;
    private ChannelFilter inputChannelFilter = null;
    private ChannelFilter outputChannelFilter = null;
    private SelectionProviderIntermediate spi = null;
    private Action copyClipboardAction = null;
    private Action exportToExcel = null;

    public ExcelView() {
        this.model.addObserver(this);
        this.inputChannelFilter = new ChannelFilter();
        this.inputChannelFilter.setChannelFilter(true);
        this.outputChannelFilter = new ChannelFilter();
        this.outputChannelFilter.setChannelFilter(false);
        this.spi = new SelectionProviderIntermediate();
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        FormToolkit tk = new FormToolkit(this.parentComposite.getDisplay());
        this.form = tk.createScrolledForm(this.parentComposite);
        this.form.setText(Messages.viewName);
        if (this.compExeInfo != null) {
            this.form.setText(String.valueOf(Messages.viewName) + this.compExeInfo.getInstanceName());
        }
        this.parentComposite = this.form.getBody();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.horizontalSpacing = 75;
        this.parentComposite.setLayout((Layout)gridLayout);
        this.createTableViewer(this.parentComposite);
        this.tableSorter = new TableSorter();
        this.inputTableViewer.setInput(this.model.getChannelValues());
        this.inputTableViewer.setSorter((ViewerSorter)this.tableSorter);
        this.inputTableViewer.addFilter((ViewerFilter)this.inputChannelFilter);
        this.outputTableViewer.setInput(this.model.getChannelValues());
        this.outputTableViewer.setSorter((ViewerSorter)this.tableSorter);
        this.outputTableViewer.addFilter((ViewerFilter)this.outputChannelFilter);
        this.getSite().setSelectionProvider((ISelectionProvider)this.spi);
        this.createActions();
        this.createToolbar();
        ExcelUtils.destroyGarbage();
    }

    private void createTableViewer(Composite parent) {
        this.inputTableViewer = new TableViewer(parent, 66306);
        this.createColumns(parent, this.inputTableViewer);
        this.inputTableViewer.setContentProvider((IContentProvider)new ChannelValueContentProvider());
        this.inputTableViewer.setLabelProvider((IBaseLabelProvider)new ChannelValueLabelProvider());
        this.inputTableViewer.getTable().setToolTipText(Messages.inputChannelNameType);
        this.inputTableViewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener(this.parentComposite));
        this.outputTableViewer = new TableViewer(parent, 66306);
        this.createColumns(parent, this.outputTableViewer);
        this.outputTableViewer.setContentProvider((IContentProvider)new ChannelValueContentProvider());
        this.outputTableViewer.setLabelProvider((IBaseLabelProvider)new ChannelValueLabelProvider());
        this.outputTableViewer.getTable().setToolTipText(Messages.outputChannelNameType);
        this.outputTableViewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener(this.parentComposite));
        GridData gridData = new GridData(4, 4, true, true);
        this.inputTableViewer.getTable().setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true);
        this.outputTableViewer.getTable().setLayoutData((Object)gridData);
    }

    private void createColumns(Composite parent, final TableViewer tv) {
        final Menu headerMenu = new Menu((Control)parent);
        String[] titles = new String[]{Messages.valueColumnName, Messages.channelColumnName, Messages.valueColumnIteration};
        int[] bounds = new int[]{150, 150, 75};
        int i = 0;
        while (i < titles.length) {
            final int index = i;
            TableViewerColumn viewerColumn = new TableViewerColumn(tv, 0);
            final TableColumn column = viewerColumn.getColumn();
            column.setAlignment(131072);
            column.setText(titles[i]);
            column.setWidth(bounds[i]);
            column.setResizable(true);
            column.setMoveable(true);
            this.createMenuItem(headerMenu, column);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExcelView.this.tableSorter.setColumn(index);
                    int dir = tv.getTable().getSortDirection();
                    dir = tv.getTable().getSortColumn() == column ? (dir == 128 ? 1024 : 128) : 1024;
                    tv.getTable().setSortDirection(dir);
                    tv.getTable().setSortColumn(column);
                    tv.refresh();
                }
            });
            ++i;
        }
        final Table table = tv.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                table.setMenu(headerMenu);
            }
        });
    }

    private void createMenuItem(Menu parent, final TableColumn column) {
        final MenuItem itemName = new MenuItem(parent, 32);
        itemName.setText(column.getText());
        itemName.setSelection(column.getResizable());
        itemName.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (itemName.getSelection()) {
                    column.setWidth(150);
                    column.setResizable(true);
                } else {
                    column.setWidth(0);
                    column.setResizable(false);
                }
            }
        });
    }

    public void setFocus() {
        if (this.compExeInfo != null) {
            this.form.setText(String.valueOf(Messages.viewName) + this.compExeInfo.getInstanceName());
        }
        this.form.reflow(true);
        this.form.getParent().setFocus();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.parentComposite.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExcelView.this.inputTableViewer.refresh();
                ExcelView.this.outputTableViewer.refresh();
            }
        });
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.copyClipboardAction);
        mgr.add((IAction)this.exportToExcel);
    }

    private void createActions() {
        this.copyClipboardAction = new Action(Messages.copyToClipboard){

            public void run() {
                ExcelView.this.copyToClipboard();
                LOGGER.debug((Object)"Copy to clipboard...");
            }
        };
        this.copyClipboardAction.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.COPY_16));
        this.exportToExcel = new Action(Messages.exportExcel){

            public void run() {
                boolean isNewXLFile = ExcelView.this.model.getChannelValues().get(0).getFile().getName().endsWith("xlsx");
                NewFileWizard wizz = isNewXLFile ? new NewFileWizard(ExcelView.FILETYPENAME, "xlsx", new String("empty").getBytes(), null) : new NewFileWizard(ExcelView.FILETYPENAME, "xls", new String("empty").getBytes(), null);
                wizz.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
                WizardDialog dialog = new WizardDialog(ExcelView.this.parentComposite.getShell(), (IWizard)wizz);
                dialog.create();
                int a = dialog.open();
                if (a == 0) {
                    ExcelView.this.exportToExcel(new File(wizz.getFile().getLocation().toPortableString()));
                }
                try {
                    dialog.close();
                }
                catch (SWTException sWTException) {
                    LOGGER.debug((Object)"Widget is disposed.");
                }
                LOGGER.debug((Object)"Export to Excel...");
            }
        };
        this.exportToExcel.setImageDescriptor(ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.EXCEL_SMALL));
    }

    private void exportToExcel(File saveTo) {
        ExcelService excel = ExcelServiceAccess.get();
        ConcurrencyUtils.getAsyncTaskService().execute("Export values to Excel", () -> {
            try {
                String postMacroName;
                List<ChannelValue> allValues = this.model.getChannelValues();
                FileUtils.copyFile((File)allValues.get(0).getFile(), (File)saveTo);
                String preMacroName = allValues.get(0).getPreMacro();
                if (preMacroName != null && !preMacroName.isEmpty()) {
                    excel.runMacro(saveTo, preMacroName);
                }
                for (ChannelValue cval : allValues) {
                    if (!cval.isInputValue()) continue;
                    excel.setValues(saveTo, cval.getExcelAddress(), cval.getValues());
                }
                String runMacroName = allValues.get(0).getRunMacro();
                if (runMacroName != null && !runMacroName.isEmpty()) {
                    excel.runMacro(saveTo, runMacroName);
                }
                if ((postMacroName = allValues.get(0).getPostMacro()) != null && !postMacroName.isEmpty()) {
                    excel.runMacro(saveTo, postMacroName);
                }
                this.parentComposite.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Image image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.EXCEL_SMALL);
                        MessageDialog md = new MessageDialog(ExcelView.this.parentComposite.getShell(), Messages.exportExcel, image, Messages.actionDone, 2, new String[]{Messages.actionButton}, 0);
                        md.open();
                    }
                });
            }
            catch (RuntimeException re) {
                LOGGER.error((Object)"Could not interact with Excel.", (Throwable)re);
                this.parentComposite.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Image image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.EXCEL_SMALL);
                        MessageDialog md = new MessageDialog(ExcelView.this.parentComposite.getShell(), Messages.exportExcel, image, Messages.actionError, 1, new String[]{Messages.actionButton}, 0);
                        md.open();
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error((Object)"Cannot copy origin file to exporting directory.", (Throwable)e);
            }
        });
    }

    private void copyToClipboard() {
        IStructuredSelection sel;
        ISelection selection = null;
        ArrayList<ChannelValue> channelValueList = new ArrayList<ChannelValue>();
        this.spi.setSelectionProviderDelegate((ISelectionProvider)this.inputTableViewer);
        selection = this.getSite().getSelectionProvider().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            sel = (IStructuredSelection)selection;
            for (ChannelValue channelValue : sel) {
                channelValueList.add(channelValue);
            }
        }
        this.spi.setSelectionProviderDelegate((ISelectionProvider)this.outputTableViewer);
        selection = this.getSite().getSelectionProvider().getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            sel = (IStructuredSelection)selection;
            for (ChannelValue channelValue : sel) {
                channelValueList.add(channelValue);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (ChannelValue cval : channelValueList) {
            sb.append(this.channelValueToString(cval));
            sb.append("\r\n");
        }
        sb.delete(sb.lastIndexOf("\r\n"), sb.length());
        ClipboardHelper.setContent((String)sb.toString());
        this.inputTableViewer.getTable().deselectAll();
        this.outputTableViewer.getTable().deselectAll();
    }

    private String channelValueToString(ChannelValue channelValue) {
        return ExcelUtils.smallTableToString((SmallTableTD)channelValue.getValues(), (String)"\t", (String)"\r\n");
    }

    public void initializeData(ComponentExecutionInformation compInstanceDescr) {
        this.compExeInfo = compInstanceDescr;
        try {
            this.model.subscribeToLocalToolRunPlatForm(this.compExeInfo.getExecutionIdentifier(), (ResolvableNodeId)this.compExeInfo.getNodeId());
        }
        catch (RemoteOperationException e) {
            LogFactory.getLog(this.getClass()).error((Object)("Subscribing to remote notifiactions failed " + (Object)((Object)e)));
        }
    }

    public void dispose() {
        super.dispose();
        ExcelUtils.destroyGarbage();
    }

    public void initializeView() {
        if (this.form != null) {
            this.form.setText(String.valueOf(Messages.viewName) + this.compExeInfo.getInstanceName());
        }
    }
}

